# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exporter import Exporter


class GL2PSExporter(Exporter):
    """
    GL2PSExporter - export a scene as a post_script file using Gl2ps.
    
    Superclass: Exporter
    
    GL2PSExporter is a concrete subclass of Exporter that writes
    high quality vector post_script (PS/EPS), PDF or SVG files by using
    Gl2ps.  Gl2ps can be obtained at: http://www.geuz.org/gl2ps/.  This
    can be very useful when one requires publication quality pictures.
    This class works best with simple 3D scenes and most 2D plots. Please
    note that Gl2ps has its limitations since post_script is not an ideal
    language to represent complex 3D scenes.  However, this class does
    allow one to write mixed vector/raster files by using the
    write3d_props_as_raster_image ivar.  Please do read the caveats section
    of this documentation.
    
    By default GL2PSExporter generates Encapsulated post_script (EPS)
    output along with the text in portrait orientation with the
    background color of the window being drawn.  The generated output is
    also compressed using zlib. The various other options are set to
    sensible defaults.
    
    The output file format (file_format) can be either post_script (PS),
    Encapsulated post_script (EPS), PDF, SVG or TeX.  The file extension
    is generated automatically depending on the file_format.  The default
    is EPS.  When TeX output is chosen, only the text strings in the plot
    are generated and put into a picture environment.  One can turn on
    and off the text when generating PS/EPS/PDF/SVG files by using the
    Text boolean variable.  By default the text is drawn. The background
    color of the renderwindow is drawn by default.  To make the
    background white instead use the draw_background_off function. 
    Landscape figures can be generated by using the landscape_on function.
     Portrait orientation is used by default. Several of the Gl2ps
    options can be set.  The names of the ivars for these options are
    similar to the ones that Gl2ps provides. Compress, simple_line_offset,
    Silent, best_root, Ps3_shading and occlusion_cull are similar to the
    options provided by Gl2ps.  Please read the function documentation or
    the Gl2ps documentation for more details.  The ivar
    write3d_props_as_raster_image allows one to generate mixed vector/raster
    images.  All the 3D props in the scene will be written as a raster
    image and all 2D actors will be written as vector graphic primitives.
     This makes it possible to handle transparency and complex 3D scenes.
     This ivar is set to Off by default.  Specific 3D props can be
    excluded from the rasterization process by adding them to the
    raster_exclusions ivar.  Props in this collection will be rendered as
    2D vector primitives instead.
    
    @warning
    By default (with write3d_props_as_raster_image set to Off) exporting
    complex 3D scenes can take a long while and result in huge output
    files.  Generating correct vector graphics output for scenes with
    transparency is almost impossible.  However, one can set
    write3d_props_as_raster_image_on and generate mixed vector/raster files.
    This should work fine with complex scenes along with transparent
    actors.
    
    @sa
    Exporter
    
    @par Thanks: Thanks to Goodwin Lawlor and Prabhu Ramachandran for
    this class.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGL2PSExporter, obj, update, **traits)
    
    best_root = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off the Gl2ps__best__root option.  When enabled the
        construction of the BSP tree is optimized by choosing the root
        primitives leading to the minimum number of splits.  Defaults to
        on.
        """
    )

    def _best_root_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBestRoot,
                        self.best_root_)

    compress = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off compression when generating post_script or PDF output.
        By default compression is on.
        """
    )

    def _compress_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompress,
                        self.compress_)

    draw_background = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off drawing the background frame.  If off the background
        is treated as white.  By default the background is drawn. On the
        open_gl2 backend, the background is always drawn.
        """
    )

    def _draw_background_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawBackground,
                        self.draw_background_)

    landscape = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off landscape orientation.  If off (default) the
        orientation is set to portrait.
        """
    )

    def _landscape_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLandscape,
                        self.landscape_)

    occlusion_cull = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off culling of occluded polygons (Gl2ps__occlusion__cull).
        When enabled hidden polygons are removed.  This reduces file size
        considerably.  Defaults to on.
        """
    )

    def _occlusion_cull_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOcclusionCull,
                        self.occlusion_cull_)

    ps3_shading = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off the Gl2ps__ps3__shading option.  When enabled the
        shfill post_script level 3 operator is used.  Read the Gl2ps
        documentation for more details.  Defaults to on.
        """
    )

    def _ps3_shading_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPS3Shading,
                        self.ps3_shading_)

    silent = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off Gl2ps messages sent to stderr (Gl2ps__silent).  When
        enabled Gl2ps messages are suppressed.  Defaults to off.
        """
    )

    def _silent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSilent,
                        self.silent_)

    simple_line_offset = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off the Gl2ps__simple__line__offset option.  When enabled a
        small offset is added in the z-buffer to all the lines in the
        plot.  This results in an anti-aliasing like solution.  Defaults
        to on.
        """
    )

    def _simple_line_offset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSimpleLineOffset,
                        self.simple_line_offset_)

    text_as_path = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off exporting text as path information, rather than
        character data. This is useful for the PDF backend, which does
        not properly support aligned text otherwise. Defaults to Off.
        """
    )

    def _text_as_path_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextAsPath,
                        self.text_as_path_)

    text = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off drawing the text.  If on (default) the text is drawn.
        If the file_format is set to TeX output then a la_te_x picture is
        generated with the text strings.  If off text output is
        suppressed.
        """
    )

    def _text_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetText,
                        self.text_)

    write3d_props_as_raster_image = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off writing 3D props as raster images.  2D props are
        rendered using vector graphics primitives.  If you have hi-res
        actors and are using transparency you probably need to turn this
        on.  Defaults to Off. This option has no effect when the open_gl2
        backend is in use, as all 3D props (excluding TextActor3D) are
        rasterized into the background.
        """
    )

    def _write3d_props_as_raster_image_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWrite3DPropsAsRasterImage,
                        self.write3d_props_as_raster_image_)

    file_format = tvtk_base.RevPrefixMap({'eps': 1, 'pdf': 2, 'ps': 0, 'svg': 4, 'tex': 3}, default_value='eps', desc=\
        """
        Specify the format of file to write out.  This can be one of:
        PS_FILE, EPS_FILE, PDF_FILE, TEX_FILE.  Defaults to EPS_FILE.
        Depending on the option chosen it generates the appropriate file
        (with correct extension) when the Write function is called.
        """
    )

    def _file_format_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileFormat,
                        self.file_format_)

    sort = tvtk_base.RevPrefixMap({'simple': 1, 'bsp': 2, 'off': 0}, default_value='simple', desc=\
        """
        Set the type of sorting algorithm to order primitives from back
        to front.  Successive algorithms are more memory intensive. 
        Simple is the default but BSP is perhaps the best.
        """
    )

    def _sort_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSort,
                        self.sort_)

    buffer_size = traits.Int(4194304, enter_set=True, auto_set=False, desc=\
        """
        The initial size of the Gl2ps export buffer in bytes. The buffer
        is used to store the exported image prior to writing to file. If
        the buffer is too small, the exporter will enlarge the buffer and
        rerender until the export is successful. Setting a larger value
        here can reduce the time needed to export a complex scene by
        reducing the number of iterations required. The default initial
        size is 4 MB.
        """
    )

    def _buffer_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBufferSize,
                        self.buffer_size)

    file_prefix = tvtk_base.vtk_file_prefix("", desc=\
        """
        Specify the prefix of the files to write out. The resulting
        filenames will have .ps or .eps or .tex appended to them
        depending on the other options chosen.
        """
    )

    def _file_prefix_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFilePrefix,
                        self.file_prefix)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        """
        
        """
    )

    line_width_factor = traits.Float(0.7142857313156128, enter_set=True, auto_set=False, desc=\
        """
        Set the ratio between the open_gl line_width and that used by Gl2ps
        to generate post_script.  Defaults to a ratio of 5/7.
        """
    )

    def _line_width_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineWidthFactor,
                        self.line_width_factor)

    point_size_factor = traits.Float(0.7142857313156128, enter_set=True, auto_set=False, desc=\
        """
        Set the ratio between the open_gl point_size and that used by Gl2ps
        to generate post_script.  Defaults to a ratio of 5/7.
        """
    )

    def _point_size_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointSizeFactor,
                        self.point_size_factor)

    def _get_raster_exclusions(self):
        return wrap_vtk(self._vtk_obj.GetRasterExclusions())
    def _set_raster_exclusions(self, arg):
        old_val = self._get_raster_exclusions()
        self._wrap_call(self._vtk_obj.SetRasterExclusions,
                        deref_vtk(arg))
        self.trait_property_changed('raster_exclusions', old_val, arg)
    raster_exclusions = traits.Property(_get_raster_exclusions, _set_raster_exclusions, desc=\
        """
        
        """
    )

    title = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set the title for the output, if supported. If nullptr, "VTK Gl2ps
        Export" is used.
        """
    )

    def _title_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTitle,
                        self.title)

    def use_painter_settings(self):
        """
        use_painter_settings(self) -> None
        C++: void use_painter_settings()
        Configure the exporter to expect a painter-ordered 2D rendering,
        that is, a rendering at a fixed depth where primitives are drawn
        from the bottom up. This disables sorting, which will break the
        painter ordering, and turns off the simple line offset, which can
        cause line primitives to be drawn on top of all other geometry.
        """
        ret = self._vtk_obj.UsePainterSettings()
        return ret
        

    _updateable_traits_ = \
    (('best_root', 'GetBestRoot'), ('compress', 'GetCompress'),
    ('draw_background', 'GetDrawBackground'), ('landscape',
    'GetLandscape'), ('occlusion_cull', 'GetOcclusionCull'),
    ('ps3_shading', 'GetPS3Shading'), ('silent', 'GetSilent'),
    ('simple_line_offset', 'GetSimpleLineOffset'), ('text_as_path',
    'GetTextAsPath'), ('text', 'GetText'),
    ('write3d_props_as_raster_image', 'GetWrite3DPropsAsRasterImage'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_format', 'GetFileFormat'), ('sort',
    'GetSort'), ('buffer_size', 'GetBufferSize'), ('file_prefix',
    'GetFilePrefix'), ('line_width_factor', 'GetLineWidthFactor'),
    ('point_size_factor', 'GetPointSizeFactor'), ('title', 'GetTitle'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['best_root', 'compress', 'debug', 'draw_background',
    'global_warning_display', 'landscape', 'occlusion_cull',
    'ps3_shading', 'silent', 'simple_line_offset', 'text', 'text_as_path',
    'write3d_props_as_raster_image', 'file_format', 'sort', 'buffer_size',
    'file_prefix', 'line_width_factor', 'point_size_factor', 'title'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GL2PSExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GL2PSExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['best_root', 'compress', 'draw_background', 'landscape',
            'occlusion_cull', 'ps3_shading', 'silent', 'simple_line_offset',
            'text', 'text_as_path', 'write3d_props_as_raster_image'],
            ['file_format', 'sort'], ['buffer_size', 'file_prefix',
            'line_width_factor', 'point_size_factor', 'title']),
            title='Edit GL2PSExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GL2PSExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

