# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class ExtractCells(UnstructuredGridAlgorithm):
    """
    ExtractCells - subset a DataSet to create a UnstructuredGrid
    
    Superclass: UnstructuredGridAlgorithm
    
    Given a DataSet and a list of cell ids, create a
    UnstructuredGrid
       composed of these cells.  If the cell list is empty when
    ExtractCells
       executes, it will set up the ugrid, point and cell arrays, with no
    points,
       cells or data.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractCells, obj, update, **traits)
    
    assume_sorted_and_unique_ids = tvtk_base.false_bool_trait(desc=\
        """
        If the cell ids specified are already sorted and unique, then set
        this to true to avoid the filter from doing time-consuming sorts
        and uniquification operations. Defaults to false.
        """
    )

    def _assume_sorted_and_unique_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAssumeSortedAndUniqueIds,
                        self.assume_sorted_and_unique_ids_)

    extract_all_cells = tvtk_base.false_bool_trait(desc=\
        """
        If all cells are being extracted, this filter can use fast path
        to speed up the extraction. In that case, one can set this flag
        to true. When set to true, cell ids added via the various methods
        are simply ignored. Defaults to false.
        """
    )

    def _extract_all_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtractAllCells,
                        self.extract_all_cells_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_cell_ids(self, *args):
        """
        add_cell_ids(self, ptr:(int, ...), numValues:int) -> None
        C++: void add_cell_ids(const IdType *ptr, IdType numValues)"""
        ret = self._wrap_call(self._vtk_obj.AddCellIds, *args)
        return ret

    def add_cell_list(self, *args):
        """
        add_cell_list(self, l:IdList) -> None
        C++: void add_cell_list(IdList *l)
        Add the supplied list of cell IDs to those that will be included
        in the output UnstructuredGrid. The cell ids should be >=0.
        """
        my_args = deref_array(args, [['vtkIdList']])
        ret = self._wrap_call(self._vtk_obj.AddCellList, *my_args)
        return ret

    def add_cell_range(self, *args):
        """
        add_cell_range(self, from_:int, to:int) -> None
        C++: void add_cell_range(IdType from, IdType to)
        Add this range of cell IDs to those that will be included in the
        output UnstructuredGrid. Note that (from < to), and (from >=
        0).
        """
        ret = self._wrap_call(self._vtk_obj.AddCellRange, *args)
        return ret

    def set_cell_ids(self, *args):
        """
        set_cell_ids(self, ptr:(int, ...), numValues:int) -> None
        C++: void set_cell_ids(const IdType *ptr, IdType numValues)
        Another way to provide ids using a pointer to IdType array.
        """
        ret = self._wrap_call(self._vtk_obj.SetCellIds, *args)
        return ret

    def set_cell_list(self, *args):
        """
        set_cell_list(self, l:IdList) -> None
        C++: void set_cell_list(IdList *l)
        Set the list of cell IDs that the output UnstructuredGrid will
        be composed of.  Replaces any other cell ID list supplied so far.
         (Set to nullptr to free memory used by cell list.)  The cell ids
        should be >=0.
        """
        my_args = deref_array(args, [['vtkIdList']])
        ret = self._wrap_call(self._vtk_obj.SetCellList, *my_args)
        return ret

    _updateable_traits_ = \
    (('assume_sorted_and_unique_ids', 'GetAssumeSortedAndUniqueIds'),
    ('extract_all_cells', 'GetExtractAllCells'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'assume_sorted_and_unique_ids', 'debug',
    'extract_all_cells', 'global_warning_display', 'release_data_flag',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractCells, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractCells properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['assume_sorted_and_unique_ids', 'extract_all_cells'], [], []),
            title='Edit ExtractCells properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractCells properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

