# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DSPFilterGroup(Object):
    """
    DSPFilterGroup - used by the Exodus readers
    
    Superclass: Object
    
    DSPFilterGroup is used by ExodusReader, ExodusIIReader and
    PExodusReader to do temporal smoothing of data
    @sa
    DSPFilterDefinition ExodusReader ExodusIIReader
    PExodusReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDSPFilterGroup, obj, update, **traits)
    
    def get_cached_input(self, *args):
        """
        get_cached_input(self, a_whichFilter:int, a_whichTimestep:int)
            -> FloatArray
        C++: FloatArray *get_cached_input(int a_whichFilter,
            int a_whichTimestep)"""
        ret = self._wrap_call(self._vtk_obj.GetCachedInput, *args)
        return wrap_vtk(ret)

    def get_cached_output(self, *args):
        """
        get_cached_output(self, a_whichFilter:int, a_whichTimestep:int)
            -> FloatArray
        C++: FloatArray *get_cached_output(int a_whichFilter,
            int a_whichTimestep)"""
        ret = self._wrap_call(self._vtk_obj.GetCachedOutput, *args)
        return wrap_vtk(ret)

    def get_filter(self, *args):
        """
        get_filter(self, a_whichFilter:int) -> DSPFilterDefinition
        C++: DSPFilterDefinition *get_filter(int a_whichFilter)"""
        ret = self._wrap_call(self._vtk_obj.GetFilter, *args)
        return wrap_vtk(ret)

    def get_input_variable_name(self, *args):
        """
        get_input_variable_name(self, a_whichFilter:int) -> str
        C++: const char *get_input_variable_name(int a_whichFilter)"""
        ret = self._wrap_call(self._vtk_obj.GetInputVariableName, *args)
        return ret

    def _get_num_filters(self):
        return self._vtk_obj.GetNumFilters()
    num_filters = traits.Property(_get_num_filters, desc=\
        """
        
        """
    )

    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    output = traits.Property(_get_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self):
        """
        get_output(self, a_whichFilter:int, a_whichTimestep:int,
            a_instancesCalculated:int) -> FloatArray
        C++: FloatArray *get_output(int a_whichFilter,
            int a_whichTimestep, int &a_instancesCalculated)"""
        return wrap_vtk(self._vtk_obj.GetOutput())

    def add_filter(self, *args):
        """
        add_filter(self, filter:DSPFilterDefinition) -> None
        C++: void add_filter(DSPFilterDefinition *filter)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddFilter, *my_args)
        return ret

    def add_input_variable_instance(self, *args):
        """
        add_input_variable_instance(self, a_name:str, a_timestep:int,
            a_data:FloatArray) -> None
        C++: void add_input_variable_instance(const char *a_name,
            int a_timestep, FloatArray *a_data)"""
        my_args = deref_array(args, [('string', 'int', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.AddInputVariableInstance, *my_args)
        return ret

    def copy(self, *args):
        """
        copy(self, other:DSPFilterGroup) -> None
        C++: void copy(DSPFilterGroup *other)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Copy, *my_args)
        return ret

    def is_this_input_variable_instance_cached(self, *args):
        """
        is_this_input_variable_instance_cached(self, a_name:str,
            a_timestep:int) -> bool
        C++: bool is_this_input_variable_instance_cached(const char *a_name,
            int a_timestep)"""
        ret = self._wrap_call(self._vtk_obj.IsThisInputVariableInstanceCached, *args)
        return ret

    def is_this_input_variable_instance_needed(self, *args):
        """
        is_this_input_variable_instance_needed(self, a_name:str,
            a_timestep:int, a_outputTimestep:int) -> bool
        C++: bool is_this_input_variable_instance_needed(const char *a_name,
            int a_timestep, int a_outputTimestep)"""
        ret = self._wrap_call(self._vtk_obj.IsThisInputVariableInstanceNeeded, *args)
        return ret

    def remove_filter(self, *args):
        """
        remove_filter(self, a_outputVariableName:str) -> None
        C++: void remove_filter(const char *a_outputVariableName)"""
        ret = self._wrap_call(self._vtk_obj.RemoveFilter, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DSPFilterGroup, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DSPFilterGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit DSPFilterGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DSPFilterGroup properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

