# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class Contour3DLinearGrid(DataObjectAlgorithm):
    """
    Contour3DLinearGrid - fast generation of isosurface from 3D linear
    cells
    
    Superclass: DataObjectAlgorithm
    
    Contour3DLinearGrid is a specialized filter that generates
    isocontours from an input UnstructuredGrid consisting of 3D linear
    cells: tetrahedra, hexahedra, voxels, pyramids, and/or wedges. (The
    cells are linear in the sense that each cell edge is a straight
    line.) The filter is designed for high-speed, specialized operation.
    All other cell types are skipped and produce no output. (Note: the
    filter will also process input CompositeDataSets containing
    UnstructuredGrids.)
    
    To use this filter you must specify an input unstructured grid or
    CompositeDataSet, and one or more contour values.  You can either
    use the method set_value() to specify each contour value, or use
    generate_values() to generate a series of evenly spaced contours.
    
    The filter performance varies depending on optional output
    information. Basically if point merging is required (when
    point_merging, interpolate_attributes, and/or compute_normals is
    enabled), a sorting process is required to eliminate duplicate output
    points in the isosurface. Otherwise when point merging is not
    required, a fast path process produces independent triangles
    representing the isosurface. In many situations the results of the
    fast path are quite good and do not require additional processing.
    
    Note that another performance option exists, using a ScalarTree,
    which is an object that accelerates isosurface extraction, at the
    initial cost of building the scalar tree. (This feature is useful for
    exploratory isosurface extraction when the isovalue is frequently
    changed.) In some cases this can improve performance, however this
    algorithm is so highly tuned that random memory jumps (due to random
    access of cells provided by the scalar tree) can actually negatively
    impact performance, especially if the input dataset type consists of
    homogeneous cell types.
    
    @warning
    When the input is of type CompositeDataSet the filter will process
    the unstructured grid(s) contained in the composite data set. As a
    result the output of this filter is then a MultiBlockDataSet
    containing multiple PolyData. When a UnstructuredGrid is
    provided as input the output is a single PolyData.
    
    @warning
    The fast path simply produces output points and triangles (the fast
    path executes when merge_points if off; interpolate_attributes is off;
    and compute_normals is off). Since the fast path does not merge
    points, it produces many more output points, typically on the order
    of 5-6x more than when merge_points is enabled. Adding in the other
    options point merging, field interpolation, and normal generation
    results in additional performance impacts. By default the fast path
    is enabled.
    
    @warning
    When a CompositeDataSet is provided as input, and use_scalar_tree is
    enabled and a scalar_tree specified, then the specified scalar tree is
    cloned to create new ones for each dataset in the composite dataset.
    Otherwise (i.e., when UnstructuredGrid input) the specified scalar
    tree is directly used (no cloning required).
    
    @warning
    Internal to this filter, a caching iterator is used to traverse the
    cells that compose the UnstructuredGrid. Maximum performance is
    obtained if the cells are all of one type (i.e., input grid of
    homogeneous cell types); repeated switching from different types may
    have detrimental effects on performance.
    
    @warning
    For unstructured data, gradients are not computed. Normals are
    computed if requested; they are "pseudo-normals" in that the normals
    of output triangles that use a common point are averaged at the
    point. Alternatively use PolyDataNormals to compute the surface
    normals.
    
    @warning
    The output of this filter is subtly different than the more general
    filter ContourGrid. ContourGrid eliminates small, degenerate
    triangles with concident points which are consequently not sent to
    the output. In practice this makes little impact on visual appearance
    but may have repercussions if the output is used for modelling and/or
    analysis.
    
    @warning
    Input cells that are not of 3D linear type (tetrahedron, hexahedron,
    wedge, pyramid, and voxel) are simply skipped and not processed.
    
    @warning
    The filter is templated on types of input and output points, and
    input scalar type. To reduce object file bloat, only real points
    (float,double) are processed, and a limited subset of scalar types.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    ContourGrid ContourFilter FlyingEdges3D MarchingCubes
    PolyDataNormals StaticEdgeLocatorTemplate.h ScalarTree
    SpanSpace
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContour3DLinearGrid, obj, update, **traits)
    
    compute_normals = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to compute output point normals. An averaging
        method is used to average shared triangle normals. By default
        this if off. This is a relatively expensive option so use
        judiciously.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    compute_scalars = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get flag to compute scalars. When enabled, and when the
        interpolate_attributes option is on, Contour3DLinearGrid will
        add an array corresponding to the array used to compute the
        contour and populate it with values.
        """
    )

    def _compute_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalars,
                        self.compute_scalars_)

    interpolate_attributes = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to interpolate input attributes onto the
        isosurface. By default this option is off.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    merge_points = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to merge coincident points. This takes extra
        time and produces fewer output points, creating a "watertight"
        contour surface. By default this is off.
        """
    )

    def _merge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePoints,
                        self.merge_points_)

    sequential_processing = tvtk_base.false_bool_trait(desc=\
        """
        Force sequential processing (i.e. single thread) of the
        contouring process. By default, sequential processing is off.
        Note this flag only applies if the class has been compiled with
        VTK_SMP_IMPLEMENTATION_TYPE set to something other than
        Sequential. (If set to Sequential, then the filter always runs in
        serial mode.) This flag is typically used for benchmarking
        purposes.
        """
    )

    def _sequential_processing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSequentialProcessing,
                        self.sequential_processing_)

    use_scalar_tree = tvtk_base.false_bool_trait(desc=\
        """
        Enable the use of a scalar tree to accelerate contour extraction.
        By default this is off. If enabled, and a scalar tree is not
        specified, then a SpanSpace instance will be constructed and
        used.
        """
    )

    def _use_scalar_tree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseScalarTree,
                        self.use_scalar_tree_)

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_scalar_tree(self):
        return wrap_vtk(self._vtk_obj.GetScalarTree())
    def _set_scalar_tree(self, arg):
        old_val = self._get_scalar_tree()
        self._wrap_call(self._vtk_obj.SetScalarTree,
                        deref_vtk(arg))
        self.trait_property_changed('scalar_tree', old_val, arg)
    scalar_tree = traits.Property(_get_scalar_tree, _set_scalar_tree, desc=\
        """
        
        """
    )

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        C++: void set_value(int i, double value)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        """
        Inform the user as to whether large ids were used during filter
        execution. This flag only has meaning after the filter has
        executed. Large ids are used when the id of the larges cell or
        point is greater than signed 32-bit precision. (Smaller ids
        reduce memory usage and speed computation. Note that large_ids are
        only available on 64-bit architectures.)
        """
    )

    def _get_number_of_threads_used(self):
        return self._vtk_obj.GetNumberOfThreadsUsed()
    number_of_threads_used = traits.Property(_get_number_of_threads_used, desc=\
        """
        Return the number of threads actually used during execution. This
        is valid only after algorithm execution.
        """
    )

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        """
        
        """
    )

    def get_values(self, *args):
        """
        get_values(self) -> Pointer
        C++: double *get_values()
        get_values(self, contourValues:[float, ...]) -> None
        C++: void get_values(double *contourValues)"""
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def can_fully_process_data_object(self, *args):
        """
        can_fully_process_data_object(object:DataObject,
            scalarArrayName:str) -> bool
        C++: static bool can_fully_process_data_object(DataObject *object,
            const char *scalarArrayName)
        Returns true if the data object passed in is fully supported by
        this filter, i.e., all cell types are linear. For composite
        datasets, this means all dataset leaves have only linear cell
        types that can be processed by this filter. The second array is
        the name of the array to process.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanFullyProcessDataObject, *my_args)
        return ret

    def generate_values(self, *args):
        """
        generate_values(self, numContours:int, range:[float, float])
            -> None
        C++: void generate_values(int numContours, double range[2])
        generate_values(self, numContours:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_values(int numContours, double rangeStart,
            double rangeEnd)"""
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_normals', 'GetComputeNormals'), ('compute_scalars',
    'GetComputeScalars'), ('interpolate_attributes',
    'GetInterpolateAttributes'), ('merge_points', 'GetMergePoints'),
    ('sequential_processing', 'GetSequentialProcessing'),
    ('use_scalar_tree', 'GetUseScalarTree'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_contours',
    'GetNumberOfContours'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normals', 'compute_scalars', 'debug',
    'global_warning_display', 'interpolate_attributes', 'merge_points',
    'release_data_flag', 'sequential_processing', 'use_scalar_tree',
    'number_of_contours', 'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Contour3DLinearGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normals', 'compute_scalars', 'interpolate_attributes',
            'merge_points', 'sequential_processing', 'use_scalar_tree'], [],
            ['number_of_contours', 'output_points_precision']),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

