# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class ContextMapper2D(Algorithm):
    """
    ContextMapper2D - Abstract class for 2D context mappers.
    
    Superclass: Algorithm
    
    This class provides an abstract base for 2D context mappers. They
    currently only accept Table objects as input.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContextMapper2D, obj, update, **traits)
    
    def get_input_array_to_process(self, *args):
        """
        get_input_array_to_process(self, idx:int, input:DataObject)
            -> DataArray
        C++: DataArray *get_input_array_to_process(int idx,
            DataObject *input)
        Make the arrays accessible to the plot objects.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetInputArrayToProcess, *my_args)
        return wrap_vtk(ret)

    def set_input_array_to_process(self, *args):
        """
        set_input_array_to_process(self, idx:int, port:int, connection:int,
            fieldAssociation:int, name:str) -> None
        C++: virtual void set_input_array_to_process(int idx, int port,
            int connection, int fieldAssociation, const char *name)
        set_input_array_to_process(self, idx:int, port:int, connection:int,
            fieldAssociation:int, fieldAttributeType:int) -> None
        C++: virtual void set_input_array_to_process(int idx, int port,
            int connection, int fieldAssociation, int fieldAttributeType)
        set_input_array_to_process(self, idx:int, info:Information) -> None
        C++: virtual void set_input_array_to_process(int idx,
            Information *info)
        set_input_array_to_process(self, idx:int, port:int, connection:int,
            fieldAssociation:str, attributeTypeorName:str) -> None
        C++: virtual void set_input_array_to_process(int idx, int port,
            int connection, const char *fieldAssociation,
            const char *attributeTypeorName)
        Set the input data arrays that this algorithm will process.
        Specifically the idx array that this algorithm will process
        (starting from 0) is the array on port, connection with the
        specified association and name or attribute type (such as
        SCALARS). The fieldAssociation refers to which field in the data
        object the array is stored. See DataObject::FieldAssociations
        for detail.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *my_args)
        return ret

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        
        """
    )

    def get_input_abstract_array_to_process(self, *args):
        """
        get_input_abstract_array_to_process(self, idx:int, input:DataObject)
             -> AbstractArray
        C++: AbstractArray *get_input_abstract_array_to_process(int idx,
            DataObject *input)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetInputAbstractArrayToProcess, *my_args)
        return wrap_vtk(ret)

    def set_input_data(self, *args):
        """
        set_input_data(self, input:Table) -> None
        C++: virtual void set_input_data(Table *input)
        Set/Get the input for this object - only accepts Table as
        input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ContextMapper2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ContextMapper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ContextMapper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ContextMapper2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

