# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_widget import AbstractWidget


class CameraOrientationWidget(AbstractWidget):
    """
    CameraOrientationWidget - A widget to manipulate
    CameraOrientationWidget.
    
    Superclass: AbstractWidget
    
    This 3D widget creates and manages its own
    CameraOrientationRepresentation. To use this widget, make sure you
    call set_parent_renderer() and enable the widget. The
    jump-to-axis-viewpoint feature is animated over 20 frames. See
    set_animator_total_frames() Turn off animation with animate_off()
    
    @par Event Bindings: By default, the widget responds to the following
    VTK events (i.e., it watches the RenderWindowInteractor for these
    events):
    
    left_button_press_event - select the appropriate handle
    left_button_release_event - release the currently selected handle If one
    of the six handles are selected:
      mouse_move_event - rotate (if left button) , else set hover
    representation for nearest handle.  These input events are not
    forwarded to any other observers. This widget eats up mouse events.
    (abort_flag_on).
    
    @par Event Bindings: Note that the event bindings described above can
    be changed using this class's WidgetEventTranslator, which
    translates VTK events into the CameraOrientationWidget's widget
    events:
    
    
      WidgetEvent::Select -- some part of the widget has been selected
      WidgetEvent::EndSelect -- the selection process has completed
      WidgetEvent::Move -- a request for motion has been invoked 
    
    @par Event Bindings: This class, and the affiliated
    CameraOrientationRepresentation, are second generation VTK
    widgets.
    
    @sa
    CameraOrientationRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCameraOrientationWidget, obj, update, **traits)
    
    animate = tvtk_base.true_bool_trait(desc=\
        """
        Enable jump-to-axis-view animation. See animator_total_frames.
        """
    )

    def _animate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnimate,
                        self.animate_)

    animator_total_frames = traits.Trait(20, traits.Range(2, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Length of animation. (in frames)
        """
    )

    def _animator_total_frames_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnimatorTotalFrames,
                        self.animator_total_frames)

    def _get_parent_renderer(self):
        return wrap_vtk(self._vtk_obj.GetParentRenderer())
    def _set_parent_renderer(self, arg):
        old_val = self._get_parent_renderer()
        self._wrap_call(self._vtk_obj.SetParentRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('parent_renderer', old_val, arg)
    parent_renderer = traits.Property(_get_parent_renderer, _set_parent_renderer, desc=\
        """
        
        """
    )

    def square_resize(self):
        """
        square_resize(self) -> None
        C++: void square_resize()
        Fits the widget's renderer to a square viewport.
        """
        ret = self._vtk_obj.SquareResize()
        return ret
        

    _updateable_traits_ = \
    (('animate', 'GetAnimate'), ('manages_cursor', 'GetManagesCursor'),
    ('process_events', 'GetProcessEvents'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('picking_managed',
    'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('animator_total_frames', 'GetAnimatorTotalFrames'), ('priority',
    'GetPriority'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['animate', 'debug', 'enabled', 'global_warning_display',
    'key_press_activation', 'manages_cursor', 'picking_managed',
    'process_events', 'animator_total_frames',
    'key_press_activation_value', 'priority'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CameraOrientationWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CameraOrientationWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['animate', 'enabled', 'key_press_activation', 'manages_cursor',
            'picking_managed', 'process_events'], [], ['animator_total_frames',
            'key_press_activation_value', 'priority']),
            title='Edit CameraOrientationWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CameraOrientationWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

