# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class CameraOrientationRepresentation(WidgetRepresentation):
    """
    CameraOrientationRepresentation - a 3D axes representation for
    interactive widgets
    
    Superclass: WidgetRepresentation
    
    This class is a concrete representation for
    CameraOrientationWidget. It is used to represent 3D axes in the
    scene and control attached renderer's camera.
    
    @sa
    CameraOrientationWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCameraOrientationRepresentation, obj, update, **traits)
    
    container_visibility = tvtk_base.false_bool_trait(desc=\
        """
        Show container to indicate mouse presence.
        """
    )

    def _container_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContainerVisibility,
                        self.container_visibility_)

    container_circumferential_resolution = traits.Trait(32, traits.Range(3, 256, enter_set=True, auto_set=False), desc=\
        """
        Set container's circumferential resolution.
        """
    )

    def _container_circumferential_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContainerCircumferentialResolution,
                        self.container_circumferential_resolution)

    container_radial_resolution = traits.Trait(1, 1, traits.Range(3, 256, enter_set=True, auto_set=False), desc=\
        """
        Set container's radial resolution.
        """
    )

    def _container_radial_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContainerRadialResolution,
                        self.container_radial_resolution)

    handle_circumferential_resolution = traits.Trait(32, traits.Range(3, 256, enter_set=True, auto_set=False), desc=\
        """
        Set Handle's circumferential resolution.
        """
    )

    def _handle_circumferential_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleCircumferentialResolution,
                        self.handle_circumferential_resolution)

    normalized_handle_dia = traits.Float(0.4, enter_set=True, auto_set=False, desc=\
        """
        Set the normalized (0-1) diameter of the Handle. Default value:
        0.4
        """
    )

    def _normalized_handle_dia_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalizedHandleDia,
                        self.normalized_handle_dia)

    padding = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(10, 10), cols=2, desc=\
        """
        Get/Set the widget padding in display coordinates.
        """
    )

    def _padding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPadding,
                        self.padding)

    shaft_resolution = traits.Trait(10, traits.Range(3, 256, enter_set=True, auto_set=False), desc=\
        """
        Set shaft's resolution.
        """
    )

    def _shaft_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShaftResolution,
                        self.shaft_resolution)

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(120, 120), cols=2, desc=\
        """
        Get/Set the widget size in display coordinates.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    total_length = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set the total length of the axes in 3 dimensions. This is basis
        of normalization. Default value: 1.
        """
    )

    def _total_length_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTotalLength,
                        self.total_length)

    def _get_anchor_position(self):
        return self._vtk_obj.GetAnchorPosition()
    anchor_position = traits.Property(_get_anchor_position, desc=\
        """
        Get/Set the widget anchor type
        """
    )

    def _get_azimuth(self):
        return self._vtk_obj.GetAzimuth()
    azimuth = traits.Property(_get_azimuth, desc=\
        """
        Orientation properties. (read only)
        """
    )

    def _get_back(self):
        return self._vtk_obj.GetBack()
    back = traits.Property(_get_back, desc=\
        """
        
        """
    )

    def _get_container_property(self):
        return wrap_vtk(self._vtk_obj.GetContainerProperty())
    container_property = traits.Property(_get_container_property, desc=\
        """
        Get the container property.
        """
    )

    def _get_elevation(self):
        return self._vtk_obj.GetElevation()
    elevation = traits.Property(_get_elevation, desc=\
        """
        
        """
    )

    def _get_interaction_state_as_enum(self):
        return self._vtk_obj.GetInteractionStateAsEnum()
    interaction_state_as_enum = traits.Property(_get_interaction_state_as_enum, desc=\
        """
        Convenient method to get interaction_state as enum. This method
        clamps the interaction state to possible values. Hence, it does
        not raise any exceptions.
        """
    )

    def _get_picked_axis(self):
        return self._vtk_obj.GetPickedAxis()
    picked_axis = traits.Property(_get_picked_axis, desc=\
        """
        Get picked axis, direction
        """
    )

    def _get_picked_dir(self):
        return self._vtk_obj.GetPickedDir()
    picked_dir = traits.Property(_get_picked_dir, desc=\
        """
        
        """
    )

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    transform = traits.Property(_get_transform, desc=\
        """
        Retrieve internal transform of this widget representation.
        """
    )

    def _get_up(self):
        return self._vtk_obj.GetUp()
    up = traits.Property(_get_up, desc=\
        """
        
        """
    )

    def _get_x_minus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetXMinusLabelProperty())
    x_minus_label_property = traits.Property(_get_x_minus_label_property, desc=\
        """
        Get the '-' axis label properties.
        """
    )

    def _get_x_plus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetXPlusLabelProperty())
    x_plus_label_property = traits.Property(_get_x_plus_label_property, desc=\
        """
        Get the '+' axis label properties.
        """
    )

    def _get_y_minus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetYMinusLabelProperty())
    y_minus_label_property = traits.Property(_get_y_minus_label_property, desc=\
        """
        
        """
    )

    def _get_y_plus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetYPlusLabelProperty())
    y_plus_label_property = traits.Property(_get_y_plus_label_property, desc=\
        """
        
        """
    )

    def _get_z_minus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetZMinusLabelProperty())
    z_minus_label_property = traits.Property(_get_z_minus_label_property, desc=\
        """
        
        """
    )

    def _get_z_plus_label_property(self):
        return wrap_vtk(self._vtk_obj.GetZPlusLabelProperty())
    z_plus_label_property = traits.Property(_get_z_plus_label_property, desc=\
        """
        
        """
    )

    def anchor_to_lower_left(self):
        """
        anchor_to_lower_left(self) -> None
        C++: void anchor_to_lower_left()"""
        ret = self._vtk_obj.AnchorToLowerLeft()
        return ret
        

    def anchor_to_lower_right(self):
        """
        anchor_to_lower_right(self) -> None
        C++: void anchor_to_lower_right()"""
        ret = self._vtk_obj.AnchorToLowerRight()
        return ret
        

    def anchor_to_upper_left(self):
        """
        anchor_to_upper_left(self) -> None
        C++: void anchor_to_upper_left()"""
        ret = self._vtk_obj.AnchorToUpperLeft()
        return ret
        

    def anchor_to_upper_right(self):
        """
        anchor_to_upper_right(self) -> None
        C++: void anchor_to_upper_right()"""
        ret = self._vtk_obj.AnchorToUpperRight()
        return ret
        

    def apply_interaction_state(self, *args):
        """
        apply_interaction_state(self, state:InteractionStateType) -> None
        C++: void apply_interaction_state(const InteractionStateType &state)
        apply_interaction_state(self, state:int) -> None
        C++: void apply_interaction_state(const int &state)
        The interaction state may be set from a widget (e.g.,
        CameraOrientationWidget) or other object. This call updates
        the representation to match the interaction state.
        """
        ret = self._wrap_call(self._vtk_obj.ApplyInteractionState, *args)
        return ret

    _updateable_traits_ = \
    (('container_visibility', 'GetContainerVisibility'),
    ('need_to_render', 'GetNeedToRender'), ('picking_managed',
    'GetPickingManaged'), ('dragable', 'GetDragable'), ('pickable',
    'GetPickable'), ('use_bounds', 'GetUseBounds'), ('visibility',
    'GetVisibility'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('container_circumferential_resolution',
    'GetContainerCircumferentialResolution'),
    ('container_radial_resolution', 'GetContainerRadialResolution'),
    ('handle_circumferential_resolution',
    'GetHandleCircumferentialResolution'), ('normalized_handle_dia',
    'GetNormalizedHandleDia'), ('padding', 'GetPadding'),
    ('shaft_resolution', 'GetShaftResolution'), ('size', 'GetSize'),
    ('total_length', 'GetTotalLength'), ('handle_size', 'GetHandleSize'),
    ('place_factor', 'GetPlaceFactor'), ('estimated_render_time',
    'GetEstimatedRenderTime'), ('render_time_multiplier',
    'GetRenderTimeMultiplier'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['container_visibility', 'debug', 'dragable',
    'global_warning_display', 'need_to_render', 'pickable',
    'picking_managed', 'use_bounds', 'visibility',
    'container_circumferential_resolution', 'container_radial_resolution',
    'estimated_render_time', 'handle_circumferential_resolution',
    'handle_size', 'normalized_handle_dia', 'padding', 'place_factor',
    'render_time_multiplier', 'shaft_resolution', 'size', 'total_length'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CameraOrientationRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CameraOrientationRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['container_visibility', 'need_to_render', 'picking_managed',
            'use_bounds', 'visibility'], [],
            ['container_circumferential_resolution',
            'container_radial_resolution', 'estimated_render_time',
            'handle_circumferential_resolution', 'handle_size',
            'normalized_handle_dia', 'padding', 'place_factor',
            'render_time_multiplier', 'shaft_resolution', 'size',
            'total_length']),
            title='Edit CameraOrientationRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CameraOrientationRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

