# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_base import UnstructuredGridBase


class UnstructuredGrid(UnstructuredGridBase):
    """
    UnstructuredGrid - dataset represents arbitrary combinations of
    all possible cell types
    
    Superclass: UnstructuredGridBase
    
    UnstructuredGrid is a data object that is a concrete
    implementation of DataSet. UnstructuredGrid represents any
    combinations of any cell types. This includes 0d (e.g., points), 1d
    (e.g., lines, polylines), 2d (e.g., triangles, polygons), and 3d
    (e.g., hexahedron, tetrahedron, polyhedron, etc.).
    UnstructuredGrid provides random access to cells, as well as
    topological information (such as lists of cells using each point).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUnstructuredGrid, obj, update, **traits)
    
    def get_cells(self):
        """
        V.get_cells() -> CellArray
        C++: CellArray *GetCells()
        Return the unstructured grid connectivity array.
        """
        ret = wrap_vtk(self._vtk_obj.GetCells())
        return ret
        

    def set_cells(self, *args):
        """
        V.set_cells(int, CellArray)
        C++: void SetCells(int type, CellArray *cells)
        V.set_cells([int, ...], CellArray)
        C++: void SetCells(int *types, CellArray *cells)
        V.set_cells(UnsignedCharArray, CellArray)
        C++: void SetCells(UnsignedCharArray *cellTypes,
            CellArray *cells)
        V.set_cells(UnsignedCharArray, CellArray, IdTypeArray,
            IdTypeArray)
        C++: void SetCells(UnsignedCharArray *cellTypes,
            CellArray *cells, IdTypeArray *faceLocations,
            IdTypeArray *faces)
        V.set_cells(UnsignedCharArray, IdTypeArray, CellArray)
        C++: void SetCells(UnsignedCharArray *cellTypes,
            IdTypeArray *cellLocations, CellArray *cells)
        V.set_cells(UnsignedCharArray, IdTypeArray, CellArray,
            IdTypeArray, IdTypeArray)
        C++: void SetCells(UnsignedCharArray *cellTypes,
            IdTypeArray *cellLocations, CellArray *cells,
            IdTypeArray *faceLocations, IdTypeArray *faces)
        Provide cell information to define the dataset.
        
        Cells like Polyhedron require points plus a list of faces. To
        handle Polyhedron, set_cells() support a special input
        cell_connectivities format (num_cell_faces, num_face0_pts, id1, id2,
        id3, num_face1_pts,id_1, id2, id3, ...) The functions use
        Polyhedron::DecomposeAPolyhedronCell() to convert polyhedron
        cells into standard format.
        """
        my_args = deref_array(args, [('int', 'vtkCellArray'), (['int', Ellipsis], 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkCellArray', 'vtkIdTypeArray', 'vtkIdTypeArray'), ('vtkUnsignedCharArray', 'vtkIdTypeArray', 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkIdTypeArray', 'vtkCellArray', 'vtkIdTypeArray', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.SetCells, *my_args)
        return ret

    def _get_cell_links(self):
        return wrap_vtk(self._vtk_obj.GetCellLinks())
    cell_links = traits.Property(_get_cell_links, desc=\
        """
        Get the cell links. The cell links will be one of nullptr=0;
        CellLinks=1; StaticCellLinksTemplate<VTK_UNSIGNED_SHORT>=2;
        StaticCellLinksTemplate<VTK_UNSIGNED_INT>=3;
        StaticCellLinksTemplate<VTK_ID_TYPE>=4.  (See enum types
        defined in AbstractCellLinks.)
        """
    )

    def _get_cell_locations_array(self):
        return wrap_vtk(self._vtk_obj.GetCellLocationsArray())
    cell_locations_array = traits.Property(_get_cell_locations_array, desc=\
        """
        Get the array of all the starting indices of cell definitions in
        the cell array.
        
        @warning CellArray supports random access now. This array is
            no
        longer used.
        """
    )

    def _get_cell_types_array(self):
        return wrap_vtk(self._vtk_obj.GetCellTypesArray())
    cell_types_array = traits.Property(_get_cell_types_array, desc=\
        """
        Get the array of all cell types in the grid. Each
        single-component tuple in the array at an index that corresponds
        to the type of the cell with the same index. To get an array of
        only the distinct cell types in the dataset, use get_cell_types().
        """
    )

    def _get_face_locations(self):
        return wrap_vtk(self._vtk_obj.GetFaceLocations())
    face_locations = traits.Property(_get_face_locations, desc=\
        """
        Get pointer to faces and facelocations. Support for polyhedron
        cells.
        """
    )

    def get_face_stream(self, *args):
        """
        V.get_face_stream(int, IdList)
        C++: void GetFaceStream(IdType cellId, IdList *ptIds)
        V.get_face_stream(int, int, (int, ...))
        C++: void GetFaceStream(IdType cellId, IdType &nfaces,
            IdType const *&ptIds)
        Get the face stream of a polyhedron cell in the following format:
        (num_cell_faces, num_face0_pts, id1, id2, id3, num_face1_pts,id_1, id2,
        id3, ...). If the requested cell is not a polyhedron, then the
        standard get_cell_points is called to return a list of unique point
        ids (id1, id2, id3, ...).
        """
        my_args = deref_array(args, [('int', 'vtkIdList'), ('int', 'int', ('int', Ellipsis))])
        ret = self._wrap_call(self._vtk_obj.GetFaceStream, *my_args)
        return ret

    def _get_faces(self):
        return wrap_vtk(self._vtk_obj.GetFaces())
    faces = traits.Property(_get_faces, desc=\
        """
        Special support for polyhedron. Return nullptr for all other cell
        types.
        """
    )

    def get_faces(self, *args):
        """
        V.get_faces(int) -> (int, ...)
        C++: IdType *GetFaces(IdType cellId)
        V.get_faces() -> IdTypeArray
        C++: IdTypeArray *GetFaces()
        Special support for polyhedron. Return nullptr for all other cell
        types.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaces, *args)
        return wrap_vtk(ret)

    def _get_ghost_level(self):
        return self._vtk_obj.GetGhostLevel()
    ghost_level = traits.Property(_get_ghost_level, desc=\
        """
        Get the ghost level.
        """
    )

    def _get_mesh_m_time(self):
        return self._vtk_obj.GetMeshMTime()
    mesh_m_time = traits.Property(_get_mesh_m_time, desc=\
        """
        Return the mesh (geometry/topology) modification time. This time
        is different from the usual MTime which also takes into account
        the modification of data arrays. This function can be used to
        track the changes on the mesh separately from the data arrays
        (eg. static mesh over time with transient data).
        """
    )

    def _get_number_of_pieces(self):
        return self._vtk_obj.GetNumberOfPieces()
    number_of_pieces = traits.Property(_get_number_of_pieces, desc=\
        """
        Set / Get the piece and the number of pieces. Similar to extent
        in 3d.
        """
    )

    def _get_piece(self):
        return self._vtk_obj.GetPiece()
    piece = traits.Property(_get_piece, desc=\
        """
        Set / Get the piece and the number of pieces. Similar to extent
        in 3d.
        """
    )

    def add_reference_to_cell(self, *args):
        """
        V.add_reference_to_cell(int, int)
        C++: void AddReferenceToCell(IdType ptId, IdType cellId)
        Use these methods only if the dataset has been specified as
        Editable. See PointSet for more information.
        """
        ret = self._wrap_call(self._vtk_obj.AddReferenceToCell, *args)
        return ret

    def allocate_estimate(self, *args):
        """
        V.allocate_estimate(int, int) -> bool
        C++: bool AllocateEstimate(IdType numCells,
            IdType maxCellSize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param num_cells The number of expected cells in the dataset.
        @param max_cell_size The number of points per cell to allocate
            memory for.
        @return True if allocation succeeds.
        @sa Squeeze();
        """
        ret = self._wrap_call(self._vtk_obj.AllocateEstimate, *args)
        return ret

    def allocate_exact(self, *args):
        """
        V.allocate_exact(int, int) -> bool
        C++: bool AllocateExact(IdType numCells,
            IdType connectivitySize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param num_cells The number of expected cells in the dataset.
        @param connectivity_size The total number of point_ids stored for
            all cells.
        @return True if allocation succeeds.
        @sa Squeeze();
        """
        ret = self._wrap_call(self._vtk_obj.AllocateExact, *args)
        return ret

    def build_links(self):
        """
        V.build_links()
        C++: void BuildLinks()
        Build topological links from points to lists of cells that use
        each point. See AbstractCellLinks for more information.
        """
        ret = self._vtk_obj.BuildLinks()
        return ret
        

    def convert_face_stream_point_ids(self, *args):
        """
        V.convert_face_stream_point_ids(IdList, [int, ...])
        C++: static void ConvertFaceStreamPointIds(IdList *faceStream,
            IdType *idMap)
        V.convert_face_stream_point_ids(int, [int, ...], [int, ...])
        C++: static void ConvertFaceStreamPointIds(IdType nfaces,
            IdType *faceStream, IdType *idMap)
        Convert pid in a face stream into id_map[pid]. The face stream is
        of format [n_cell_faces, n_face0_pts, i, j, k, n_face1_pts, i, j, k,
        ...]. The user is responsible to make sure all the Ids in
        face_stream do not exceed the range of id_map.
        """
        my_args = deref_array(args, [('vtkIdList', ['int', Ellipsis]), ('int', ['int', Ellipsis], ['int', Ellipsis])])
        ret = self._wrap_call(self._vtk_obj.ConvertFaceStreamPointIds, *my_args)
        return ret

    def decompose_a_polyhedron_cell(self, *args):
        """
        V.decompose_a_polyhedron_cell(CellArray, int, int, CellArray,
            IdTypeArray)
        C++: static void DecomposeAPolyhedronCell(
            CellArray *polyhedronCellArray, IdType &nCellpts,
            IdType &nCellfaces, CellArray *cellArray,
            IdTypeArray *faces)
        V.decompose_a_polyhedron_cell((int, ...), int, int, CellArray,
            IdTypeArray)
        C++: static void DecomposeAPolyhedronCell(
            const IdType *polyhedronCellStream, IdType &nCellpts,
            IdType &nCellfaces, CellArray *cellArray,
            IdTypeArray *faces)
        V.decompose_a_polyhedron_cell(int, (int, ...), int, CellArray,
            IdTypeArray)
        C++: static void DecomposeAPolyhedronCell(IdType nCellFaces,
            const IdType *inFaceStream, IdType &nCellpts,
            CellArray *cellArray, IdTypeArray *faces)
        A static method for converting a polyhedron CellArray of
        format [n_cell_faces, n_face0_pts, i, j, k, n_face1_pts, i, j, k, ...]
        into three components: (1) an integer indicating the number of
        faces (2) a standard CellArray storing point ids [n_cell0_pts,
        i, j, k] and (3) an IdTypeArray storing face connectivity in
        format [n_face0_pts, i, j, k, n_face1_pts, i, j, k, ...] Note: input
        is assumed to contain only one polyhedron cell. Outputs (2) and
        (3) will be stacked at the end of the input cell_array and faces.
        The original data in the input will not be touched.
        """
        my_args = deref_array(args, [('vtkCellArray', 'int', 'int', 'vtkCellArray', 'vtkIdTypeArray'), (('int', Ellipsis), 'int', 'int', 'vtkCellArray', 'vtkIdTypeArray'), ('int', ('int', Ellipsis), 'int', 'vtkCellArray', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.DecomposeAPolyhedronCell, *my_args)
        return ret

    def initialize_faces_representation(self, *args):
        """
        V.initialize_faces_representation(int) -> int
        C++: int InitializeFacesRepresentation(IdType numPrevCells)
        Special function used by UnstructuredGridReader. By default
        UnstructuredGrid does not contain face information, which is
        only used by polyhedron cells. If so far no polyhedron cells have
        been added, Faces and face_locations pointers will be nullptr. In
        this case, need to initialize the arrays and assign values to the
        previous non-polyhedron cells.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeFacesRepresentation, *args)
        return ret

    def insert_next_linked_cell(self, *args):
        """
        V.insert_next_linked_cell(int, int, (int, ...)) -> int
        C++: IdType InsertNextLinkedCell(int type, int npts,
            const IdType pts[])
        Use these methods only if the dataset has been specified as
        Editable. See PointSet for more information.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextLinkedCell, *args)
        return ret

    def remove_ghost_cells(self):
        """
        V.remove_ghost_cells()
        C++: void RemoveGhostCells()
        This method will remove any cell that is marked as ghost (has the
        DataSetAttributes::DUPLICATECELL bit set).
        """
        ret = self._vtk_obj.RemoveGhostCells()
        return ret
        

    def remove_reference_to_cell(self, *args):
        """
        V.remove_reference_to_cell(int, int)
        C++: void RemoveReferenceToCell(IdType ptId, IdType cellId)
        Use these methods only if the dataset has been specified as
        Editable. See PointSet for more information.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveReferenceToCell, *args)
        return ret

    def reset(self):
        """
        V.reset()
        C++: void Reset()
        Standard DataSet methods; see DataSet.h for documentation.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def resize_cell_list(self, *args):
        """
        V.resize_cell_list(int, int)
        C++: void ResizeCellList(IdType ptId, int size)
        Use these methods only if the dataset has been specified as
        Editable. See PointSet for more information.
        """
        ret = self._wrap_call(self._vtk_obj.ResizeCellList, *args)
        return ret

    _updateable_traits_ = \
    (('editable', 'GetEditable'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'editable', 'global_release_data_flag',
    'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(UnstructuredGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['editable', 'global_release_data_flag'], [], []),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

