# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.window import Window


class HardwareWindow(Window):
    """
    HardwareWindow - create a window for renderers to draw into
    
    Superclass: Window
    
    HardwareWindow is an abstract object representing a UI based
    window that can be drawn to. This class is defines an interface that
    GUI specific subclasses (Win32, X, Cocoa) should support.
    
    This class is meant to be Graphics library agnostic. In that it
    should contain as little graphics library specific code as possible,
    ideally none. In contrast to classes such as WinOpenGLRenderWindow
    which contain significant ties to open_gl.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHardwareWindow, obj, update, **traits)
    
    def create(self):
        """
        V.create()
        C++: virtual void Create()"""
        ret = self._vtk_obj.Create()
        return ret
        

    def destroy(self):
        """
        V.destroy()
        C++: virtual void Destroy()"""
        ret = self._vtk_obj.Destroy()
        return ret
        

    _updateable_traits_ = \
    (('double_buffer', 'GetDoubleBuffer'), ('erase', 'GetErase'),
    ('off_screen_rendering', 'GetOffScreenRendering'), ('show_window',
    'GetShowWindow'), ('use_off_screen_buffers',
    'GetUseOffScreenBuffers'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('dpi',
    'GetDPI'), ('position', 'GetPosition'), ('size', 'GetSize'),
    ('tile_scale', 'GetTileScale'), ('tile_viewport', 'GetTileViewport'),
    ('window_name', 'GetWindowName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'double_buffer', 'erase', 'global_warning_display',
    'off_screen_rendering', 'show_window', 'use_off_screen_buffers',
    'dpi', 'position', 'size', 'tile_scale', 'tile_viewport',
    'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HardwareWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HardwareWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['double_buffer', 'erase', 'off_screen_rendering',
            'show_window', 'use_off_screen_buffers'], [], ['dpi', 'position',
            'size', 'tile_scale', 'tile_viewport', 'window_name']),
            title='Edit HardwareWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HardwareWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

