# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set import PointSet


class ExplicitStructuredGrid(PointSet):
    """
    ExplicitStructuredGrid - structured grid with explicit topology
    and geometry
    
    Superclass: PointSet
    
    ExplicitStructuredGrid is a data object that is a concrete
    implementation of DataSet. ExplicitStructuredGrid represents a
    geometric structure that is a topologically regular array of
    hexahedron. The topology is that of a cube that has been subdivided
    into a regular array of smaller cubes. Each cell can be addressed
    with i-j-k indices, however neighbor hexahedrons does not necessarily
    share a face and hexahedron can be blanked (turned-off).
    
    Like unstructured grid, ExplicitStructuredGrid has explicit point
    coordinates and cell to point indexing. Unlike unstructured grid,
    ExplicitStructuredGrid does not keep a cell type list as all
    visible cells are known to be hexahedra. ExplicitStructuredGrid
    can take advantage of its layout to perform operations based on the
    i, j, k parameters, similar to structured grid. This makes some
    operations faster on this class, without losing the flexibility of
    the cell -> points mapping. The most common use of this class would
    be in situations where you have all hexahedra but the points used by
    the cells are not exactly defined by the i, j, k parameters. One
    example of this is a structured grid with a half voxel shift
    occurring in the middle of it such as with a geologic fault.
    
    The order and number of points is arbitrary. The order and number of
    cells must match that specified by the dimensions of the grid minus
    1, because in vtk structured datasets the dimensions correspond to
    the points. The cells order increases in i fastest (from 0 <= i <=
    dims[0] - 2), then j (0 <= j <= dims[1] - 2), then k ( 0 <= k <=
    dims[2] - 2) where dims[] are the dimensions of the grid in the i-j-k
    topological directions. The number of cells is (dims[0] - 1) *
    (dims[1] - 1) * (dims[2] - 1).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExplicitStructuredGrid, obj, update, **traits)
    
    def _get_cells(self):
        return wrap_vtk(self._vtk_obj.GetCells())
    def _set_cells(self, arg):
        old_val = self._get_cells()
        my_arg = deref_array([arg], [['vtkCellArray']])
        self._wrap_call(self._vtk_obj.SetCells,
                        my_arg[0])
        self.trait_property_changed('cells', old_val, arg)
    cells = traits.Property(_get_cells, _set_cells, desc=\
        """
        Set/Get the cell array defining hexahedron.
        """
    )

    def get_dimensions(self, *args):
        """
        V.get_dimensions([int, int, int])
        C++: void GetDimensions(int dim[3])
        Set/Get the dimensions of this structured dataset in term of
        number of points along each direction. This is just a convenience
        method which calls set/_get_extent internally.
        """
        ret = self._wrap_call(self._vtk_obj.GetDimensions, *args)
        return ret

    def set_dimensions(self, *args):
        """
        V.set_dimensions(int, int, int)
        C++: void SetDimensions(int i, int j, int k)
        V.set_dimensions([int, int, int])
        C++: void SetDimensions(int dim[3])
        Set/Get the dimensions of this structured dataset in term of
        number of points along each direction. This is just a convenience
        method which calls set/_get_extent internally.
        """
        ret = self._wrap_call(self._vtk_obj.SetDimensions, *args)
        return ret

    extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int64", value=(0, 0, 0, 0, -1664149456, 451), cols=3, desc=\
        """
        Set/Get the extent of this structured dataset in term of number
        of points along each direction. Setting the extent will reset the
        internal cell_array and Links and a correctly sized cell array
        will be created. The Extent is stored  in the order (X, Y, Z).
        """
    )

    def _extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtent,
                        self.extent)

    faces_connectivity_flags_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get the name of the faces connectivity flags array.
        """
    )

    def _faces_connectivity_flags_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFacesConnectivityFlagsArrayName,
                        self.faces_connectivity_flags_array_name)

    def get_cell_dims(self, *args):
        """
        V.get_cell_dims([int, int, int])
        C++: void GetCellDims(int cellDims[3])
        Computes the cell dimensions according to internal point
        dimensions. The total number of cells can be achieved simply by
        cell_dims[_0] * cell_dims[_1] * cell_dims[_2].
        """
        ret = self._wrap_call(self._vtk_obj.GetCellDims, *args)
        return ret

    def _get_data_dimension(self):
        return self._vtk_obj.GetDataDimension()
    data_dimension = traits.Property(_get_data_dimension, desc=\
        """
        Return the dimensionality of the data.
        """
    )

    def _get_links(self):
        return wrap_vtk(self._vtk_obj.GetLinks())
    links = traits.Property(_get_links, desc=\
        """
        Create/Get upward links from points to cells that use each point.
        Enables topologically complex queries.
        """
    )

    def blank_cell(self, *args):
        """
        V.blank_cell(int)
        C++: void BlankCell(IdType cellId)
        Methods for supporting blanking of cells. Blanking turns on or
        off cells in the structured grid. These methods should be called
        only after the dimensions of the grid are set.
        """
        ret = self._wrap_call(self._vtk_obj.BlankCell, *args)
        return ret

    def build_links(self):
        """
        V.build_links()
        C++: void BuildLinks()
        Create/Get upward links from points to cells that use each point.
        Enables topologically complex queries.
        """
        ret = self._vtk_obj.BuildLinks()
        return ret
        

    def check_and_reorder_faces(self):
        """
        V.check_and_reorder_faces()
        C++: void CheckAndReorderFaces()
        Check faces are numbered correctly regarding ijk numbering If not
        this will reorganize cell points order so face order is valid.
        This is made in two pass, first it check that faces are on the
        correct axis and corrects it Then it check if faces are mirrored
        and corrects it. Make sure cells and extent have been set before
        calling this method and recompute face connectivity afterwards.
        """
        ret = self._vtk_obj.CheckAndReorderFaces()
        return ret
        

    def compute_cell_id(self, *args):
        """
        V.compute_cell_id(int, int, int, bool) -> int
        C++: IdType ComputeCellId(int i, int j, int k,
            bool adjustForExtent=true)
        Given a location in structured coordinates (i-j-k), return the
        cell id. If adjust_for_extent is true, (i,j,k) is interpreted as a
        position relative to the beginning of the extent. If
        adjust_for_extent is false, (i,j,k) is interpreted literally and
        the cell id is returned regardless of the extent beginning. The
        default adjust_for_extent is true.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeCellId, *args)
        return ret

    def compute_cell_structured_coords(self, *args):
        """
        V.compute_cell_structured_coords(int, int, int, int, bool)
        C++: void ComputeCellStructuredCoords(IdType cellId, int &i,
            int &j, int &k, bool adjustForExtent=true)
        Given a cell_id, get the structured coordinates (i-j-k). If
        adjust_for_extent is true, (i,j,k) is computed as a position
        relative to the beginning of the extent. If adjust_for_extent is
        false, (i,j,k) is computed regardless of the extent beginning.
        The default adjust_for_extent is true.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeCellStructuredCoords, *args)
        return ret

    def compute_faces_connectivity_flags_array(self):
        """
        V.compute_faces_connectivity_flags_array()
        C++: void ComputeFacesConnectivityFlagsArray()
        Compute the faces connectivity flags array.
        """
        ret = self._vtk_obj.ComputeFacesConnectivityFlagsArray()
        return ret
        

    def is_cell_ghost(self, *args):
        """
        V.is_cell_ghost(int) -> int
        C++: unsigned char IsCellGhost(IdType cellId)
        Return non-zero value if specified cell is a ghost cell. These
        methods should be called only after the dimensions of the grid
        are set.
        """
        ret = self._wrap_call(self._vtk_obj.IsCellGhost, *args)
        return ret

    def is_cell_visible(self, *args):
        """
        V.is_cell_visible(int) -> int
        C++: unsigned char IsCellVisible(IdType cellId)
        Return non-zero value if specified cell is visible. These methods
        should be called only after the dimensions of the grid are set.
        """
        ret = self._wrap_call(self._vtk_obj.IsCellVisible, *args)
        return ret

    def un_blank_cell(self, *args):
        """
        V.un_blank_cell(int)
        C++: void UnBlankCell(IdType cellId)
        Methods for supporting blanking of cells. Blanking turns on or
        off cells in the structured grid. These methods should be called
        only after the dimensions of the grid are set.
        """
        ret = self._wrap_call(self._vtk_obj.UnBlankCell, *args)
        return ret

    _updateable_traits_ = \
    (('editable', 'GetEditable'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('extent',
    'GetExtent'), ('faces_connectivity_flags_array_name',
    'GetFacesConnectivityFlagsArrayName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'editable', 'global_release_data_flag',
    'global_warning_display', 'extent',
    'faces_connectivity_flags_array_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExplicitStructuredGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExplicitStructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['editable', 'global_release_data_flag'], [], ['extent',
            'faces_connectivity_flags_array_name']),
            title='Edit ExplicitStructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExplicitStructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

