# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class DistributedDataFilter(DataObjectAlgorithm):
    """
    DistributedDataFilter - Serial stand-in for parallel filter that
    distributes data among processors
    
    Superclass: DataObjectAlgorithm
    
    This filter is a serial implementation of the
    PDistributedDataFilter filter with the intent that it can be used
    in non-MPI builds. This filter acts almost as a "pass-through" filter
    when run in serial, though when the input is a non-composite dataset,
    the output will be an UnstructuredGrid to be consistent with the
    parallel filter. The combination of this filter and its parallel
    counterpart serves to unify the API for serial and parallel builds.
    
    @sa PDistributedDataFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDistributedDataFilter, obj, update, **traits)
    
    clip_cells = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _clip_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClipCells,
                        self.clip_cells_)

    include_all_intersecting_cells = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _include_all_intersecting_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIncludeAllIntersectingCells,
                        self.include_all_intersecting_cells_)

    retain_kdtree = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _retain_kdtree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRetainKdtree,
                        self.retain_kdtree_)

    timing = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _timing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTiming,
                        self.timing_)

    use_minimal_memory = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _use_minimal_memory_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseMinimalMemory,
                        self.use_minimal_memory_)

    boundary_mode = tvtk_base.RevPrefixMap({'assign_to_one_region': 0, 'assign_to_all_intersecting_regions': 1, 'split_boundary_cells': 2}, default_value='assign_to_one_region', desc=\
        """
        Handling of clip_cells and include_all_intersecting_cells.
        """
    )

    def _boundary_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryMode,
                        self.boundary_mode_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/Get the communicator object
        """
    )

    def _get_cuts(self):
        return wrap_vtk(self._vtk_obj.GetCuts())
    def _set_cuts(self, arg):
        old_val = self._get_cuts()
        self._wrap_call(self._vtk_obj.SetCuts,
                        deref_vtk(arg))
        self.trait_property_changed('cuts', old_val, arg)
    cuts = traits.Property(_get_cuts, _set_cuts, desc=\
        """
        You can set the k-d tree decomposition, rather than have D3
        compute it.  This allows you to divide a dataset using the
        decomposition computed for another dataset.  Obtain a description
        of the k-d tree cuts this way:
        
        * BSPCuts *cuts = d3_object1->_get_cuts()
        
        * And set it this way:
        
        * d3_object2->_set_cuts(cuts)
        """
    )

    minimum_ghost_level = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _minimum_ghost_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumGhostLevel,
                        self.minimum_ghost_level)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_kdtree(self):
        return wrap_vtk(self._vtk_obj.GetKdtree())
    kdtree = traits.Property(_get_kdtree, desc=\
        """
        Get a pointer to the parallel k-d tree object.  Required for
        changing default behavior for region assignment, changing default
        depth of tree, or other tree building default parameters.  See
        PKdTree and KdTree for more information about these
        options. NOTE: Changing the tree returned by this method does NOT
        change the d3 filter. Make sure to call Modified() on the d3
        object if you want it to re-execute.
        """
    )

    def set_user_region_assignments(self, *args):
        """
        V.set_user_region_assignments((int, ...), int)
        C++: void SetUserRegionAssignments(const int *map, int numRegions)
        BSPCuts doesn't have information about process assignments for
        the cuts. Typically D3 filter simply reassigns the processes for
        each cut. However, that may not always work, sometimes the
        processes have be pre-assigned and we want to preserve that
        partitioning. In that case, one sets the region assignments
        explicitly. Look at PKdTree::AssignRegions for details about
        the arguments. Calling set_user_region_assignments(nullptr, 0) will
        revert to default behavior i.e. letting the kd_tree come up with
        the assignments.
        """
        ret = self._wrap_call(self._vtk_obj.SetUserRegionAssignments, *args)
        return ret

    _updateable_traits_ = \
    (('clip_cells', 'GetClipCells'), ('include_all_intersecting_cells',
    'GetIncludeAllIntersectingCells'), ('retain_kdtree',
    'GetRetainKdtree'), ('timing', 'GetTiming'), ('use_minimal_memory',
    'GetUseMinimalMemory'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('boundary_mode', 'GetBoundaryMode'), ('minimum_ghost_level',
    'GetMinimumGhostLevel'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'clip_cells', 'debug', 'global_warning_display',
    'include_all_intersecting_cells', 'release_data_flag',
    'retain_kdtree', 'timing', 'use_minimal_memory', 'boundary_mode',
    'minimum_ghost_level', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DistributedDataFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['clip_cells', 'include_all_intersecting_cells',
            'retain_kdtree', 'timing', 'use_minimal_memory'], ['boundary_mode'],
            ['minimum_ghost_level']),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DistributedDataFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

