# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.find_cell_strategy import FindCellStrategy


class CellLocatorStrategy(FindCellStrategy):
    """
    CellLocatorStrategy - implement a specific PointSet::FindCell()
    strategy based
             on using a cell locator
    
    Superclass: FindCellStrategy
    
    CellLocatorStrategy is implements a find_cell() strategy based on
    using the find_cell() method in a cell locator. This is often the
    slowest strategy, but the most robust.
    
    @sa
    FindCellStrategy PointSet
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellLocatorStrategy, obj, update, **traits)
    
    def _get_cell_locator(self):
        return wrap_vtk(self._vtk_obj.GetCellLocator())
    def _set_cell_locator(self, arg):
        old_val = self._get_cell_locator()
        self._wrap_call(self._vtk_obj.SetCellLocator,
                        deref_vtk(arg))
        self.trait_property_changed('cell_locator', old_val, arg)
    cell_locator = traits.Property(_get_cell_locator, _set_cell_locator, desc=\
        """
        Set / get an instance of AbstractCellLocator which is used to
        implement the strategy for find_cell(). The locator is required to
        already be built and non-NULL.
        """
    )

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellLocatorStrategy, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellLocatorStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit CellLocatorStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellLocatorStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

