# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell import Cell


class Cell3D(Cell):
    """
    Cell3D - abstract class to specify 3d cell interface
    
    Superclass: Cell
    
    Cell3D is an abstract class that extends the interfaces for 3d
    data cells, and implements methods needed to satisfy the Cell API.
    The 3d cells include hexehedra, tetrahedra, wedge, pyramid, and
    voxel.
    
    @sa
    Tetra Hexahedron Voxel Wedge Pyramid
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCell3D, obj, update, **traits)
    
    merge_tolerance = traits.Trait(0.01, traits.Range(0.0001, 0.25, enter_set=True, auto_set=False), desc=\
        """
        Set the tolerance for merging clip intersection points that are
        near the vertices of cells. This tolerance is used to prevent the
        generation of degenerate tetrahedra during clipping.
        """
    )

    def _merge_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergeTolerance,
                        self.merge_tolerance)

    def get_centroid(self, *args):
        """
        V.get_centroid([float, float, float]) -> bool
        C++: virtual bool GetCentroid(double centroid[3])
        Computes the centroid of the cell.
        """
        ret = self._wrap_call(self._vtk_obj.GetCentroid, *args)
        return ret

    def get_edge_points(self, *args):
        """
        V.get_edge_points(int, (int, ...))
        C++: virtual void GetEdgePoints(IdType edgeId,
            const IdType *&pts)
        V.get_edge_points(int, [int, ...])
        C++: virtual void GetEdgePoints(int edgeId, int *&pts)
        Get the pair of vertices that define an edge. The method returns
        the number of vertices, along with an array of vertices. Note
        that the vertices are 0-offset; that is, they refer to the ids of
        the cell, not the point ids of the mesh that the cell belongs to.
        The edge_id must range between 0<=edge_id<this->_get_number_of_edges().
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgePoints, *args)
        return ret

    def get_edge_to_adjacent_faces(self, *args):
        """
        V.get_edge_to_adjacent_faces(int, (int, ...))
        C++: virtual void GetEdgeToAdjacentFaces(IdType edgeId,
            const IdType *&faceIds)
        Get the ids of the two adjacent faces to edge of id edge_id. The
        output face ids are sorted from id of lowest rank to highest.
        Note that the faces are 0-offset; that is, they refer to the ids
        of the cells, not the face ids of the mesh that the cell belongs
        to. The edge_id must range between
        0<=edge_id<this->_get_number_of_edges().
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeToAdjacentFaces, *args)
        return ret

    def get_face_points(self, *args):
        """
        V.get_face_points(int, (int, ...)) -> int
        C++: virtual IdType GetFacePoints(IdType faceId,
            const IdType *&pts)
        V.get_face_points(int, [int, ...])
        C++: virtual void GetFacePoints(int faceId, int *&pts)
        Get the list of vertices that define a face. The list is
        terminated with a negative number. Note that the vertices are
        0-offset; that is, they refer to the ids of the cell, not the
        point ids of the mesh that the cell belongs to. The face_id must
        range between 0<=face_id<this->_get_number_of_faces().
        
        @return The number of points in face face_id
        """
        ret = self._wrap_call(self._vtk_obj.GetFacePoints, *args)
        return ret

    def get_face_to_adjacent_faces(self, *args):
        """
        V.get_face_to_adjacent_faces(int, (int, ...)) -> int
        C++: virtual IdType GetFaceToAdjacentFaces(IdType faceId,
            const IdType *&faceIds)
        Get the ids of the adjacent faces to face of id face_id. The order
        of faces is consistent. They are always ordered in counter
        clockwise w.r.t. normal orientation. The first id faces[0]
        corresponds to the face sharing point of id pts[0] where pts is
        obtained from this->_get_face_points(face_id, pts), being the "most counter
        clockwise" oriented w.r.t. face face_id. Note that the faces are
        0-offset; that is, they refer to the ids of the cell, not the
        face ids of the mesh that the cell belongs to. The face_id must be
        between 0<=face_id<this->_get_number_of_faces();
        
        @warning If the Cell3D is "inside out", i.e. normals point
            inside the cell, the order is
        inverted.
        @return The number of adjacent faces to face_id.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaceToAdjacentFaces, *args)
        return ret

    def get_point_to_incident_edges(self, *args):
        """
        V.get_point_to_incident_edges(int, (int, ...)) -> int
        C++: virtual IdType GetPointToIncidentEdges(IdType pointId,
            const IdType *&edgeIds)
        Get the ids of the incident edges to point of id point_id. Edges
        are sorted in counter clockwise order w.r.t. bisectrix pointing
        outside the cell at point of id point_id. The first edge
        corresponds to the edge containing point of id pts[0], where pts
        is obtained from this->_get_point_to_on_ring_vertices(point_id, pts).
        Note that the edges are 0-offset; that is, they refer to the ids
        of the cell, not the edge ids of the mesh that the cell belongs
        to. The edge_id must be between
        0<=edge_id<this->_get_number_of_edges();
        
        @warning If the Cell3D is "inside out", i.e. normals point
            inside the cell, the order is
        inverted.
        @return The valence of point point_id.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentEdges, *args)
        return ret

    def get_point_to_incident_faces(self, *args):
        """
        V.get_point_to_incident_faces(int, (int, ...)) -> int
        C++: virtual IdType GetPointToIncidentFaces(IdType pointId,
            const IdType *&faceIds)
        Get the ids of the incident faces point of id point_id. Faces are
        sorted in counter clockwise order w.r.t. bisectrix pointing
        outside the cell at point of id point_id. The first face
        corresponds to the face containing edge of id edges[0], where
        edges is obtained from this->_get_point_to_incident_edges(point_id,
        edges), such that face faces[0] is the "most counterclockwise"
        face incident to point point_id containing edges[0]. Note that the
        faces are 0-offset; that is, they refer to the ids of the cell,
        not the face ids of the mesh that the cell belongs to. The
        point_id must be between 0<=point_id<this->_get_number_of_points().
        
        @warning If the Cell3D is "inside out", i.e. normals point
            inside the cell, the order is
        inverted.
        @return The valence of point point_id.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentFaces, *args)
        return ret

    def get_point_to_one_ring_points(self, *args):
        """
        V.get_point_to_one_ring_points(int, (int, ...)) -> int
        C++: virtual IdType GetPointToOneRingPoints(IdType pointId,
            const IdType *&pts)
        Get the ids of a one-ring surrounding point of id point_id. Points
        are sorted in counter clockwise order w.r.t. bisectrix pointing
        outside the cell at point of id point_id. The first point
        corresponds to the point contained in edges[0], where edges is
        obtained from this->_get_point_to_incident_edges(point_id, edges). Note
        that the points are 0-offset; that is, they refer to the ids of
        the cell, not the point ids of the mesh that the cell belongs to.
        The point_id must be between 0<point_id<this->_get_number_of_points().
        @return The valence of point point_id.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToOneRingPoints, *args)
        return ret

    def is_inside_out(self):
        """
        V.is_inside_out() -> bool
        C++: virtual bool IsInsideOut()
        Returns true if the normals of the Cell3D point inside the
        cell.
        
        @warning This flag is not precomputed. It is advised for the
            return result of
        this method to be stored in a local boolean by the user if needed
        multiple times.
        """
        ret = self._vtk_obj.IsInsideOut()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('merge_tolerance', 'GetMergeTolerance'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'merge_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Cell3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Cell3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['merge_tolerance']),
            title='Edit Cell3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Cell3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

