# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class TrimmedExtrusionFilter(PolyDataAlgorithm):
    """
    TrimmedExtrusionFilter - extrude polygonal data trimmed by a
    second input surface
    
    Superclass: PolyDataAlgorithm
    
    TrimmedExtrusionFilter is a modeling filter. It takes polygonal
    data as input and generates polygonal data on output. The input
    dataset is swept along a specified direction forming a "skirt" from
    the boundary edges 2d primitives (i.e., edges used by only one
    polygon); and/or from vertices and lines. The extent of the sweeping
    is limited by a second input: defined where the sweep intersects a
    user-specified surface.
    
    Capping of the extrusion can be enabled. In this case the input,
    generating primitive is copied inplace as well as to the end of the
    extrusion skirt. (See warnings below on what happens if the
    intersecting sweep does not intersect, or partially intersects the
    trim surface.)
    
    Note that this filter operates in two fundamentally different modes
    based on the extrusion strategy. If the strategy is BOUNDARY_EDGES,
    then only the boundary edges of the input's 2d primitives are
    extruded (verts and lines are extruded to generate lines and quads).
    However, if the extrusions strategy is ALL_EDGES, then every edge of
    the 2d primitives is used to sweep out a quadrilateral polygon (again
    verts and lines are swept to produce lines and quads).
    
    @warning
    The extrusion direction is assumed to define an infinite line. The
    intersection with the trim surface is along a ray from the - to +
    direction, however only the first intersection is taken.
    
    @warning
    Some polygonal objects have no free edges (e.g., sphere). When swept,
    this will result in two separate surfaces if capping is on and
    BOUNDARY_EDGES enabled, or no surface if capping is off and
    BOUNDARY_EDGES is enabled.
    
    @warning
    If all the extrusion lines emanating from an extruding primitive do
    not intersect the trim surface, then no output for that primitive
    will be generated. In extreme cases, it it possible that no output
    whatsoever will be generated by the filter.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    LinearExtrusionFilter RotationalExtrusionFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTrimmedExtrusionFilter, obj, update, **traits)
    
    capping = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off the capping of the extruded skirt.
        """
    )

    def _capping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapping,
                        self.capping_)

    capping_strategy = tvtk_base.RevPrefixMap({'maximum_distance': 2, 'average_distance': 3, 'intersection': 0, 'minimum_distance': 1}, default_value='maximum_distance', desc=\
        """
        Specify a strategy for capping. By default the points of the cap
        polygons are located where the extrusion intersects the capping
        surface. However, to preserve planarity, or to place the capping
        surface at the average/minimum/maximum distance of extrusion,
        different strategies can be used. By default the average distance
        is used.
        
        Note if none of the extrusion rays intersect the trim surface,
        then capping is not performed, nor is an extrusion skirt sent to
        the output. Also note that if the capping strategy is set to
        INTERSECTION, and one of the extrusion rays of the generating
        primitive does not intersect the trim surface, then no output
        will be generated for that primitive. However if any other
        capping strategy is used, capping will succeed if at least one
        extrusion ray strikes the trim surface (although missed extrusion
        ray intersections will not factor into the determination of final
        cap location).
        
        Finally, note that any capping strategy other than INTERSECTION
        may produce more points than expected because the output
        primitives may have to be "split apart" to satisy the capping
        constraint.
        """
    )

    def _capping_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCappingStrategy,
                        self.capping_strategy_)

    extrusion_strategy = tvtk_base.RevPrefixMap({'boundary_edges': 0, 'all_edges': 1}, default_value='boundary_edges', desc=\
        """
        Specify a strategy for extrusion. If the strategy is set to
        "BOUNDARY_EDGES" then the boundary edges of the input polygons
        and triangle strips are swept. (A boundary edge is an edge used
        by only one 2d primitive, e.g., polygon or triangle.)
        Alternatively, all edges can be swept. (This is particularly
        useful when only sinple disconnected polygons exist in the input
        and so boundary calculation can be avoided.) By default boundary
        edges are extruded.
        """
    )

    def _extrusion_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtrusionStrategy,
                        self.extrusion_strategy_)

    extrusion_direction = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        """
        Set/Get the extrusion direction.
        """
    )

    def _extrusion_direction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtrusionDirection,
                        self.extrusion_direction)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        Specify a cell locator. By default a StaticCellLocator is
        used. The locator performs efficient searches to intersect cells.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_trim_surface(self):
        return wrap_vtk(self._vtk_obj.GetTrimSurface())
    trim_surface = traits.Property(_get_trim_surface, desc=\
        """
        Return a pointer to the enclosing surface.
        """
    )

    def get_trim_surface(self, *args):
        """
        V.get_trim_surface() -> PolyData
        C++: PolyData *GetTrimSurface()
        V.get_trim_surface(InformationVector) -> PolyData
        C++: PolyData *GetTrimSurface(InformationVector *sourceInfo)
        Return a pointer to the enclosing surface.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTrimSurface, *my_args)
        return wrap_vtk(ret)

    def set_trim_surface_connection(self, *args):
        """
        V.set_trim_surface_connection(AlgorithmOutput)
        C++: void SetTrimSurfaceConnection(AlgorithmOutput *algOutput)
        Specify the surface which trims the surface.  Note that the
        method set_trim_surface_data does not connect the pipeline. The
        algorithm will work on the input data as it is without updating
        the producer of the data.  The method set_trim_surface_connection
        connects the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTrimSurfaceConnection, *my_args)
        return ret

    def set_trim_surface_data(self, *args):
        """
        V.set_trim_surface_data(PolyData)
        C++: void SetTrimSurfaceData(PolyData *pd)
        Specify the surface which trims the surface.  Note that the
        method set_trim_surface_data does not connect the pipeline. The
        algorithm will work on the input data as it is without updating
        the producer of the data.  The method set_trim_surface_connection
        connects the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTrimSurfaceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('capping', 'GetCapping'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('capping_strategy', 'GetCappingStrategy'), ('extrusion_strategy',
    'GetExtrusionStrategy'), ('extrusion_direction',
    'GetExtrusionDirection'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'capping', 'debug', 'global_warning_display',
    'release_data_flag', 'capping_strategy', 'extrusion_strategy',
    'extrusion_direction', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TrimmedExtrusionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TrimmedExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['capping'], ['capping_strategy', 'extrusion_strategy'],
            ['extrusion_direction']),
            title='Edit TrimmedExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TrimmedExtrusionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

