# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.plot import Plot


class RangeHandlesItem(Plot):
    """
    RangeHandlesItem - item to show and control the range of a
    ColorTransferFunction
    
    Superclass: Plot
    
    RangeHandlesItem provides range handles painting and management
    for a provided ColorTransferFunction. Handles can be moved by
    clicking on them. The range is shown when hovering or moving the
    handles. It emits a start_interaction_event when starting to interact
    with a handle, an interaction_event when interacting with a handle and
    an end_interaction_event when releasing a handle. It emits a
    left_mouse_button_double_click_event when double clicked.
    
    @sa
    ControlPointsItem ScalarsToColorsItem
    ColorTransferFunctionItem
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRangeHandlesItem, obj, update, **traits)
    
    def _get_color_transfer_function(self):
        return wrap_vtk(self._vtk_obj.GetColorTransferFunction())
    def _set_color_transfer_function(self, arg):
        old_val = self._get_color_transfer_function()
        self._wrap_call(self._vtk_obj.SetColorTransferFunction,
                        deref_vtk(arg))
        self.trait_property_changed('color_transfer_function', old_val, arg)
    color_transfer_function = traits.Property(_get_color_transfer_function, _set_color_transfer_function, desc=\
        """
        Get/set the color transfer function to interact with.
        """
    )

    handle_width = traits.Float(2.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the handles width in pixels. Default is 2.
        """
    )

    def _handle_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleWidth,
                        self.handle_width)

    def get_handles_range(self, *args):
        """
        V.get_handles_range([float, float])
        C++: virtual void GetHandlesRange(double range[2])
        Recover the range currently set by the handles Use this method by
        observing end_interaction_event
        """
        ret = self._wrap_call(self._vtk_obj.GetHandlesRange, *args)
        return ret

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input table used by the plot.
        """
    )

    def compute_handles_draw_range(self):
        """
        V.compute_handles_draw_range()
        C++: void ComputeHandlesDrawRange()
        Compute the handles draw range by using the handle width and the
        transfer function
        """
        ret = self._vtk_obj.ComputeHandlesDrawRange()
        return ret
        

    _updateable_traits_ = \
    (('legend_visibility', 'GetLegendVisibility'), ('selectable',
    'GetSelectable'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('handle_width', 'GetHandleWidth'),
    ('label', 'GetLabel'), ('tooltip_label_format',
    'GetTooltipLabelFormat'), ('tooltip_notation', 'GetTooltipNotation'),
    ('tooltip_precision', 'GetTooltipPrecision'),
    ('use_index_for_x_series', 'GetUseIndexForXSeries'), ('width',
    'GetWidth'), ('opacity', 'GetOpacity'), ('interactive',
    'GetInteractive'), ('visible', 'GetVisible'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'legend_visibility',
    'selectable', 'handle_width', 'interactive', 'label', 'opacity',
    'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
    'use_index_for_x_series', 'visible', 'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RangeHandlesItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['legend_visibility', 'selectable'], [], ['handle_width',
            'interactive', 'label', 'opacity', 'tooltip_label_format',
            'tooltip_notation', 'tooltip_precision', 'use_index_for_x_series',
            'visible', 'width']),
            title='Edit RangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

