# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Property(Object):
    """
    Property - represent surface properties of a geometric object
    
    Superclass: Object
    
    Property is an object that represents lighting and other surface
    properties of a geometric object. The primary properties that can be
    set are colors (overall, ambient, diffuse, specular, and edge color);
    specular power; opacity of the object; the representation of the
    object (points, wireframe, or surface); and the shading method to be
    used (flat, Gouraud, and Phong). Also, some special graphics features
    like backface properties can be set and manipulated with this object.
    
    @sa
    Actor PropertyDevice
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkProperty, obj, update, **traits)
    
    backface_culling = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off fast culling of polygons based on orientation of
        normal with respect to camera. If backface culling is on,
        polygons facing away from camera are not drawn.
        """
    )

    def _backface_culling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackfaceCulling,
                        self.backface_culling_)

    edge_visibility = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off the visibility of edges. On some renderers it is
        possible to render the edges of geometric primitives separately
        from the interior.
        """
    )

    def _edge_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeVisibility,
                        self.edge_visibility_)

    frontface_culling = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off fast culling of polygons based on orientation of
        normal with respect to camera. If frontface culling is on,
        polygons facing towards camera are not drawn.
        """
    )

    def _frontface_culling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrontfaceCulling,
                        self.frontface_culling_)

    lighting = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get lighting flag for an object. Initial value is true.
        """
    )

    def _lighting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLighting,
                        self.lighting_)

    render_lines_as_tubes = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get rendering of lines as tubes. The width of the line in
        pixels is controlled by the line_width attribute. May not be
        supported on every platform and the implementation may be half
        tubes, or something only tube like in appearance.
        """
    )

    def _render_lines_as_tubes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderLinesAsTubes,
                        self.render_lines_as_tubes_)

    render_points_as_spheres = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get rendering of points as spheres. The size of the sphere in
        pixels is controlled by the point_size attribute. Note that half
        spheres may be rendered instead of spheres.
        """
    )

    def _render_points_as_spheres_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderPointsAsSpheres,
                        self.render_points_as_spheres_)

    shading = tvtk_base.false_bool_trait(desc=\
        """
        Enable/Disable shading. When shading is enabled, the Material
        must be set.
        """
    )

    def _shading_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShading,
                        self.shading_)

    vertex_visibility = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off the visibility of vertices. On some renderers it is
        possible to render the vertices of geometric primitives
        separately from the interior.
        """
    )

    def _vertex_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexVisibility,
                        self.vertex_visibility_)

    interpolation = tvtk_base.RevPrefixMap({'gouraud': 1, 'flat': 0, 'pbr': 3, 'phong': 2}, default_value='gouraud', desc=\
        """
        Set the shading interpolation method for an object.
        """
    )

    def _interpolation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolation,
                        self.interpolation_)

    representation = tvtk_base.RevPrefixMap({'surface': 2, 'points': 0, 'wireframe': 1}, default_value='surface', desc=\
        """
        Control the surface geometry representation for the object.
        """
    )

    def _representation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRepresentation,
                        self.representation_)

    ambient = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the ambient lighting coefficient.
        """
    )

    def _ambient_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbient,
                        self.ambient)

    ambient_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        """
        Set/Get the ambient surface color. Not all renderers support
        separate ambient and diffuse colors. From a physical standpoint
        it really doesn't make too much sense to have both. For the
        rendering libraries that don't support both, the diffuse color is
        used.
        """
    )

    def _ambient_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbientColor,
                        self.ambient_color, True)

    color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        """
        Set the color of the object. Has the side effect of setting the
        ambient diffuse and specular colors as well. This is basically a
        quick overall color setting method.
        """
    )

    def _color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColor,
                        self.color, True)

    diffuse = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the diffuse lighting coefficient.
        """
    )

    def _diffuse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuse,
                        self.diffuse)

    diffuse_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        """
        Set/Get the diffuse surface color. For PBR Interpolation,
        diffuse_color is used as the base color
        """
    )

    def _diffuse_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuseColor,
                        self.diffuse_color, True)

    edge_color = tvtk_base.vtk_color_trait((0.0, 0.0, 0.0), desc=\
        """
        Set/Get the color of primitive edges (if edge visibility is
        enabled).
        """
    )

    def _edge_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeColor,
                        self.edge_color, True)

    emissive_factor = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        """
        Set/Get the emissive factor. This value is multiplied with the
        emissive color when an emissive texture is present. This
        parameter is only used by PBR Interpolation. Default value is
        [1.0, 1.0, 1.0]
        """
    )

    def _emissive_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEmissiveFactor,
                        self.emissive_factor)

    def _get_information(self):
        return wrap_vtk(self._vtk_obj.GetInformation())
    def _set_information(self, arg):
        old_val = self._get_information()
        self._wrap_call(self._vtk_obj.SetInformation,
                        deref_vtk(arg))
        self.trait_property_changed('information', old_val, arg)
    information = traits.Property(_get_information, _set_information, desc=\
        """
        Set/Get the information object associated with the Property.
        """
    )

    line_stipple_pattern = traits.Int(65535, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the stippling pattern of a Line, as a 16-bit binary
        pattern (1 = pixel on, 0 = pixel off). This is only implemented
        for open_gl, not open_gl2. The default is 0x_ffff.
        """
    )

    def _line_stipple_pattern_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineStipplePattern,
                        self.line_stipple_pattern)

    line_stipple_repeat_factor = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the stippling repeat factor of a Line, which specifies
        how many times each bit in the pattern is to be repeated. This is
        only implemented for open_gl, not open_gl2. The default is 1.
        """
    )

    def _line_stipple_repeat_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineStippleRepeatFactor,
                        self.line_stipple_repeat_factor)

    line_width = traits.Trait(1.0, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the width of a Line. The width is expressed in screen
        units. This is only implemented for open_gl. The default is 1.0.
        """
    )

    def _line_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineWidth,
                        self.line_width)

    material_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Returns the name of the material currently loaded, if any.
        """
    )

    def _material_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaterialName,
                        self.material_name)

    metallic = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the metallic coefficient. Usually this value is either 0
        or 1 for real material but any value in between is valid. This
        parameter is only used by PBR Interpolation. Default value is 0.0
        """
    )

    def _metallic_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMetallic,
                        self.metallic)

    normal_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the normal scale coefficient. This value affects the
        strength of the normal deviation from the texture. Default value
        is 1.0
        """
    )

    def _normal_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalScale,
                        self.normal_scale)

    occlusion_strength = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the occlusion strength coefficient. This value affects
        the strength of the occlusion if a material texture is present.
        This parameter is only used by PBR Interpolation. Default value
        is 1.0
        """
    )

    def _occlusion_strength_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOcclusionStrength,
                        self.occlusion_strength)

    opacity = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the object's opacity. 1.0 is totally opaque and 0.0 is
        completely transparent.
        """
    )

    def _opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOpacity,
                        self.opacity)

    point_size = traits.Trait(1.0, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the diameter of a point. The size is expressed in screen
        units. This is only implemented for open_gl. The default is 1.0.
        """
    )

    def _point_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointSize,
                        self.point_size)

    roughness = traits.Trait(0.5, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the roughness coefficient. This value have to be between
        0 (glossy) and 1 (rough). A glossy material have reflections and
        a high specular part. This parameter is only used by PBR
        Interpolation. Default value is 0.5
        """
    )

    def _roughness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRoughness,
                        self.roughness)

    specular = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the specular lighting coefficient.
        """
    )

    def _specular_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecular,
                        self.specular)

    specular_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        """
        Set/Get the specular surface color.
        """
    )

    def _specular_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularColor,
                        self.specular_color, True)

    specular_power = traits.Trait(1.0, traits.Range(0.0, 128.0, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the specular power.
        """
    )

    def _specular_power_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularPower,
                        self.specular_power)

    def get_texture(self, *args):
        """
        V.get_texture(string) -> Texture
        C++: Texture *GetTexture(const char *name)
        Set/Get the texture object to control rendering texture maps.
        This will be a Texture object. A property does not need to
        have an associated texture map and multiple properties can share
        one texture. Textures must be assigned unique names. Note that
        for texture blending the textures will be rendering is
        alphabetical order and after any texture defined in the actor.
        There exists 4 special textures with reserved names: "albedo_tex",
        "material_tex", "normal_tex" and "emissive_tex". While these
        textures can be added with the regular set_texture method, it is
        prefered to use to method set_base_color_texture, set_orm_texture,
        set_normal_texture and set_emissive_texture respectively.
        """
        ret = self._wrap_call(self._vtk_obj.GetTexture, *args)
        return wrap_vtk(ret)

    def set_texture(self, *args):
        """
        V.set_texture(string, Texture)
        C++: void SetTexture(const char *name, Texture *texture)
        Set/Get the texture object to control rendering texture maps.
        This will be a Texture object. A property does not need to
        have an associated texture map and multiple properties can share
        one texture. Textures must be assigned unique names. Note that
        for texture blending the textures will be rendering is
        alphabetical order and after any texture defined in the actor.
        There exists 4 special textures with reserved names: "albedo_tex",
        "material_tex", "normal_tex" and "emissive_tex". While these
        textures can be added with the regular set_texture method, it is
        prefered to use to method set_base_color_texture, set_orm_texture,
        set_normal_texture and set_emissive_texture respectively.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTexture, *my_args)
        return ret

    vertex_color = tvtk_base.vtk_color_trait((0.5, 1.0, 0.5), desc=\
        """
        Set/Get the color of primitive vertices (if vertex visibility is
        enabled).
        """
    )

    def _vertex_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexColor,
                        self.vertex_color, True)

    def _get_number_of_textures(self):
        return self._vtk_obj.GetNumberOfTextures()
    number_of_textures = traits.Property(_get_number_of_textures, desc=\
        """
        Returns the number of textures in this property.
        """
    )

    def add_shader_variable(self, *args):
        """
        V.add_shader_variable(string, int, [int, ...])
        C++: virtual void AddShaderVariable(const char *name, int numVars,
             int *x)
        V.add_shader_variable(string, int, [float, ...])
        C++: virtual void AddShaderVariable(const char *name, int numVars,
             double *x)
        V.add_shader_variable(string, int)
        C++: void AddShaderVariable(const char *name, int v)
        V.add_shader_variable(string, float)
        C++: void AddShaderVariable(const char *name, double v)
        V.add_shader_variable(string, int, int)
        C++: void AddShaderVariable(const char *name, int v1, int v2)
        V.add_shader_variable(string, float, float)
        C++: void AddShaderVariable(const char *name, double v1,
            double v2)
        V.add_shader_variable(string, int, int, int)
        C++: void AddShaderVariable(const char *name, int v1, int v2,
            int v3)
        V.add_shader_variable(string, float, float, float)
        C++: void AddShaderVariable(const char *name, double v1,
            double v2, double v3)
        Provide values to initialize shader variables. Useful to
        initialize shader variables that change over time (animation, GUI
        widgets inputs, etc. )
        - name - hardware name of the uniform variable
        - num_vars - number of variables being set
        - x - values
        """
        ret = self._wrap_call(self._vtk_obj.AddShaderVariable, *args)
        return ret

    def backface_render(self, *args):
        """
        V.backface_render(Actor, Renderer)
        C++: virtual void BackfaceRender(Actor *, Renderer *)
        This method renders the property as a backface property.
        two_sided_lighting must be turned off to see any backface
        properties. Note that only colors and opacity are used for
        backface properties. Other properties such as Representation,
        Culling are specified by the Property.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BackfaceRender, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        V.deep_copy(Property)
        C++: void DeepCopy(Property *p)
        Assign one property to another.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def post_render(self, *args):
        """
        V.post_render(Actor, Renderer)
        C++: virtual void PostRender(Actor *, Renderer *)
        This method is called after the actor has been rendered. Don't
        call this directly. This method cleans up any shaders allocated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PostRender, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        V.release_graphics_resources(Window)
        C++: virtual void ReleaseGraphicsResources(Window *win)
        Release any graphics resources that are being consumed by this
        property. The parameter window could be used to determine which
        graphic resources to release.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_all_textures(self):
        """
        V.remove_all_textures()
        C++: void RemoveAllTextures()
        Remove all the textures.
        """
        ret = self._vtk_obj.RemoveAllTextures()
        return ret
        

    def remove_texture(self, *args):
        """
        V.remove_texture(string)
        C++: void RemoveTexture(const char *name)
        Remove a texture from the collection.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveTexture, *args)
        return ret

    def render(self, *args):
        """
        V.render(Actor, Renderer)
        C++: virtual void Render(Actor *, Renderer *)
        This method causes the property to set up whatever is required
        for its instance variables. This is actually handled by a
        subclass of Property, which is created automatically. This
        method includes the invoking actor as an argument which can be
        used by property devices that require the actor.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def set_base_color_texture(self, *args):
        """
        V.set_base_color_texture(Texture)
        C++: void SetBaseColorTexture(Texture *texture)
        Set the base color texture. Also called albedo, this texture is
        only used while rendering with PBR interpolation. This is the
        color of the object. This texture must be in s_rgb color space.
        @sa set_interpolation_to_pbr Texture::UseSRGBColorSpaceOn
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBaseColorTexture, *my_args)
        return ret

    def set_emissive_texture(self, *args):
        """
        V.set_emissive_texture(Texture)
        C++: void SetEmissiveTexture(Texture *texture)
        Set the emissive texture. When present, this RGB texture provides
        location and color to the shader where the PolyData should
        emit light. Emited light is scaled by emissive_factor. This is
        only supported by PBR interpolation model. This texture must be
        in s_rgb color space.
        @sa set_interpolation_to_pbr set_emissive_factor
            Texture::UseSRGBColorSpaceOn
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEmissiveTexture, *my_args)
        return ret

    def set_normal_texture(self, *args):
        """
        V.set_normal_texture(Texture)
        C++: void SetNormalTexture(Texture *texture)
        Set the normal texture. This texture is required for normal
        mapping. It is valid for both PBR and Phong interpolation. The
        normal mapping is enabled if this texture is present and both
        normals and tangents are presents in the PolyData. This
        texture must be in linear color space.
        @sa PolyDataTangents set_normal_scale
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNormalTexture, *my_args)
        return ret

    def set_orm_texture(self, *args):
        """
        V.set_orm_texture(Texture)
        C++: void SetORMTexture(Texture *texture)
        Set the ORM texture. This texture contains three RGB independent
        components corresponding to the Occlusion value, Roughness value
        and Metallic value respectively. Each texture value is scaled by
        the Occlusion strength, roughness coefficient and metallic
        coefficient. This texture must be in linear color space. This is
        only used by the PBR shading model.
        @sa set_interpolation_to_pbr set_occlusion_strength set_metallic
            set_roughness
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetORMTexture, *my_args)
        return ret

    _updateable_traits_ = \
    (('backface_culling', 'GetBackfaceCulling'), ('edge_visibility',
    'GetEdgeVisibility'), ('frontface_culling', 'GetFrontfaceCulling'),
    ('lighting', 'GetLighting'), ('render_lines_as_tubes',
    'GetRenderLinesAsTubes'), ('render_points_as_spheres',
    'GetRenderPointsAsSpheres'), ('shading', 'GetShading'),
    ('vertex_visibility', 'GetVertexVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation', 'GetInterpolation'), ('representation',
    'GetRepresentation'), ('ambient', 'GetAmbient'), ('ambient_color',
    'GetAmbientColor'), ('color', 'GetColor'), ('diffuse', 'GetDiffuse'),
    ('diffuse_color', 'GetDiffuseColor'), ('edge_color', 'GetEdgeColor'),
    ('emissive_factor', 'GetEmissiveFactor'), ('line_stipple_pattern',
    'GetLineStipplePattern'), ('line_stipple_repeat_factor',
    'GetLineStippleRepeatFactor'), ('line_width', 'GetLineWidth'),
    ('material_name', 'GetMaterialName'), ('metallic', 'GetMetallic'),
    ('normal_scale', 'GetNormalScale'), ('occlusion_strength',
    'GetOcclusionStrength'), ('opacity', 'GetOpacity'), ('point_size',
    'GetPointSize'), ('roughness', 'GetRoughness'), ('specular',
    'GetSpecular'), ('specular_color', 'GetSpecularColor'),
    ('specular_power', 'GetSpecularPower'), ('vertex_color',
    'GetVertexColor'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['backface_culling', 'debug', 'edge_visibility', 'frontface_culling',
    'global_warning_display', 'lighting', 'render_lines_as_tubes',
    'render_points_as_spheres', 'shading', 'vertex_visibility',
    'interpolation', 'representation', 'ambient', 'ambient_color',
    'color', 'diffuse', 'diffuse_color', 'edge_color', 'emissive_factor',
    'line_stipple_pattern', 'line_stipple_repeat_factor', 'line_width',
    'material_name', 'metallic', 'normal_scale', 'occlusion_strength',
    'opacity', 'point_size', 'roughness', 'specular', 'specular_color',
    'specular_power', 'vertex_color'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Property, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['backface_culling', 'edge_visibility', 'frontface_culling',
            'lighting', 'render_lines_as_tubes', 'render_points_as_spheres',
            'shading', 'vertex_visibility'], ['interpolation', 'representation'],
            ['ambient', 'ambient_color', 'color', 'diffuse', 'diffuse_color',
            'edge_color', 'emissive_factor', 'line_stipple_pattern',
            'line_stipple_repeat_factor', 'line_width', 'material_name',
            'metallic', 'normal_scale', 'occlusion_strength', 'opacity',
            'point_size', 'roughness', 'specular', 'specular_color',
            'specular_power', 'vertex_color']),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def __getstate__(self):
        d = tvtk_base.TVTKBase.__getstate__(self)
        if 'color' in d:
            del d['color']
        return d
    
    def __setstate__(self, dict):
        tvtk_base.TVTKBase.__setstate__(self, dict)
        self.update_traits()

