# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell3d import Cell3D


class Pyramid(Cell3D):
    """
    Pyramid - a 3d cell that represents a linear pyramid
    
    Superclass: Cell3D
    
    Pyramid is a concrete implementation of Cell to represent a 3d
    pyramid. A pyramid consists of a rectangular base with four
    triangular faces. Pyramid uses the standard isoparametric shape
    functions for a linear pyramid. The pyramid is defined by the five
    points (0-4) where (0,1,2,3) is the base of the pyramid which, using
    the right hand rule, forms a quadrilaterial whose normal points in
    the direction of the pyramid apex at vertex #4. The parametric
    location of vertex #4 is [0, 0, 1].
    
    @sa
    ConvexPointSet Hexahedron Tetra Voxel Wedge
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPyramid, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        V.get_edge_array(int) -> (int, int)
        C++: static const IdType *GetEdgeArray(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edge_id`/`face_id'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points, and so Cell ids can be used as inputs in algorithms
        such as Polygon::ComputeNormal.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_edge_to_adjacent_faces_array(self, *args):
        """
        V.get_edge_to_adjacent_faces_array(int) -> (int, int)
        C++: static const IdType *GetEdgeToAdjacentFacesArray(
            IdType edgeId)
        Static method version of get_edge_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeToAdjacentFacesArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        V.get_face_array(int) -> (int, int, int, int)
        C++: static const IdType *GetFaceArray(IdType faceId)
        Return the ids of the vertices defining edge/face
        (`edge_id`/`face_id'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points, and so Cell ids can be used as inputs in algorithms
        such as Polygon::ComputeNormal.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def get_face_to_adjacent_faces_array(self, *args):
        """
        V.get_face_to_adjacent_faces_array(int) -> (int, int, int, int)
        C++: static const IdType *GetFaceToAdjacentFacesArray(
            IdType faceId)
        Static method version of get_face_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaceToAdjacentFacesArray, *args)
        return ret

    def get_point_to_incident_edges_array(self, *args):
        """
        V.get_point_to_incident_edges_array(int) -> (int, int, int, int)
        C++: static const IdType *GetPointToIncidentEdgesArray(
            IdType pointId)
        Static method version of get_point_to_incident_edges_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentEdgesArray, *args)
        return ret

    def get_point_to_incident_faces_array(self, *args):
        """
        V.get_point_to_incident_faces_array(int) -> (int, int, int, int)
        C++: static const IdType *GetPointToIncidentFacesArray(
            IdType pointId)
        Static method version of get_point_to_incident_faces_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentFacesArray, *args)
        return ret

    def get_point_to_one_ring_points_array(self, *args):
        """
        V.get_point_to_one_ring_points_array(int) -> (int, int, int, int)
        C++: static const IdType *GetPointToOneRingPointsArray(
            IdType pointId)
        Static method version of get_point_to_one_ring_points.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToOneRingPointsArray, *args)
        return ret

    def get_triangle_cases(self, *args):
        """
        V.get_triangle_cases(int) -> (int, ...)
        C++: static int *GetTriangleCases(int caseId)
        Return the case table for table-based isocontouring (aka marching
        cubes style implementations). A linear 3d cell with N vertices
        will have 2**N cases. The returned case array lists three edges
        in order to produce one output triangle which may be repeated to
        generate multiple triangles. The list of cases terminates with a
        -1 entry.
        """
        ret = self._wrap_call(self._vtk_obj.GetTriangleCases, *args)
        return ret

    def compute_centroid(self, *args):
        """
        V.compute_centroid(Points, (int, ...), [float, float, float])
            -> bool
        C++: static bool ComputeCentroid(Points *points,
            const IdType *pointIds, double centroid[3])
        Static method version of get_centroid.
        """
        my_args = deref_array(args, [('vtkPoints', ('int', Ellipsis), ['float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.ComputeCentroid, *my_args)
        return ret

    def interpolation_derivs(self, *args):
        """
        V.interpolation_derivs((float, float, float), [float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float])
        C++: static void InterpolationDerivs(const double pcoords[3],
            double derivs[15])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        V.interpolation_functions((float, float, float), [float, float,
            float, float, float])
        C++: static void InterpolationFunctions(const double pcoords[3],
            double weights[5])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('merge_tolerance', 'GetMergeTolerance'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'merge_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Pyramid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Pyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['merge_tolerance']),
            title='Edit Pyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Pyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

