# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.renderer import Renderer


class OpenGLRenderer(Renderer):
    """
    OpenGLRenderer - open_gl renderer
    
    Superclass: Renderer
    
    OpenGLRenderer is a concrete implementation of the abstract class
    Renderer. OpenGLRenderer interfaces to the open_gl graphics
    library.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLRenderer, obj, update, **traits)
    
    def get_environment_texture(self):
        """
        V.get_environment_texture() -> Texture
        C++: virtual Texture *GetEnvironmentTexture()
        Set/Get the environment texture used for image based lighting.
        This texture is supposed to represent the scene background. If it
        is not a cubemap, the texture is supposed to represent an
        equirectangular projection. If used with raytracing backends, the
        texture must be an equirectangular projection and must be
        constructed with a valid ImageData. Warning, this texture must
        be expressed in linear color space. If the texture is in s_rgb
        color space, set the color flag on the texture or set the
        argument is_srgb to true.
        @sa Texture::UseSRGBColorSpaceOn
        """
        ret = wrap_vtk(self._vtk_obj.GetEnvironmentTexture())
        return ret
        

    def set_environment_texture(self, *args):
        """
        V.set_environment_texture(Texture, bool)
        C++: void SetEnvironmentTexture(Texture *texture,
            bool isSRGB=false) override;
        Overriden in order to connect the texture to the environment map
        textures.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEnvironmentTexture, *my_args)
        return ret

    def _get_user_light_transform(self):
        return wrap_vtk(self._vtk_obj.GetUserLightTransform())
    def _set_user_light_transform(self, arg):
        old_val = self._get_user_light_transform()
        self._wrap_call(self._vtk_obj.SetUserLightTransform,
                        deref_vtk(arg))
        self.trait_property_changed('user_light_transform', old_val, arg)
    user_light_transform = traits.Property(_get_user_light_transform, _set_user_light_transform, desc=\
        """
        Set the user light transform applied after the camera transform.
        Can be null to disable it.
        """
    )

    def _get_depth_peeling_higher_layer(self):
        return self._vtk_obj.GetDepthPeelingHigherLayer()
    depth_peeling_higher_layer = traits.Property(_get_depth_peeling_higher_layer, desc=\
        """
        Is rendering at translucent geometry stage using depth peeling
        and rendering a layer other than the first one? (Boolean value)
        If so, the uniform variables use_texture and Texture can be set.
        (Used by OpenGLProperty or OpenGLTexture)
        """
    )

    def _get_env_map_irradiance(self):
        return wrap_vtk(self._vtk_obj.GetEnvMapIrradiance())
    env_map_irradiance = traits.Property(_get_env_map_irradiance, desc=\
        """
        Get environment textures used for image based lighting.
        """
    )

    def _get_env_map_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetEnvMapLookupTable())
    env_map_lookup_table = traits.Property(_get_env_map_lookup_table, desc=\
        """
        Get environment textures used for image based lighting.
        """
    )

    def _get_env_map_prefiltered(self):
        return wrap_vtk(self._vtk_obj.GetEnvMapPrefiltered())
    env_map_prefiltered = traits.Property(_get_env_map_prefiltered, desc=\
        """
        Get environment textures used for image based lighting.
        """
    )

    def _get_lighting_complexity(self):
        return self._vtk_obj.GetLightingComplexity()
    lighting_complexity = traits.Property(_get_lighting_complexity, desc=\
        """
        
        """
    )

    def _get_lighting_count(self):
        return self._vtk_obj.GetLightingCount()
    lighting_count = traits.Property(_get_lighting_count, desc=\
        """
        
        """
    )

    def _get_lighting_uniforms(self):
        return self._vtk_obj.GetLightingUniforms()
    lighting_uniforms = traits.Property(_get_lighting_uniforms, desc=\
        """
        
        """
    )

    def _get_state(self):
        return wrap_vtk(self._vtk_obj.GetState())
    state = traits.Property(_get_state, desc=\
        """
        
        """
    )

    def have_apple_primitive_id_bug(self):
        """
        V.have_apple_primitive_id_bug() -> bool
        C++: bool HaveApplePrimitiveIdBug()
        Indicate if this system is subject to the Apple/AMD bug of not
        having a working gl_primitive_id <rdar://20747550>. The bug is
        fixed on mac_os 10.11 and later, and this method will return false
        when the OS is new enough.
        """
        ret = self._vtk_obj.HaveApplePrimitiveIdBug()
        return ret
        

    def have_apple_query_allocation_bug(self):
        """
        V.have_apple_query_allocation_bug() -> bool
        C++: static bool HaveAppleQueryAllocationBug()
        Indicate if this system is subject to the apple/NVIDIA bug that
        causes crashes in the driver when too many query objects are
        allocated.
        """
        ret = self._vtk_obj.HaveAppleQueryAllocationBug()
        return ret
        

    def is_dual_depth_peeling_supported(self):
        """
        V.is_dual_depth_peeling_supported() -> bool
        C++: bool IsDualDepthPeelingSupported()
        Dual depth peeling may be disabled for certain runtime
        configurations. This method returns true if
        DualDepthPeelingPass will be used in place of
        DepthPeelingPass.
        """
        ret = self._vtk_obj.IsDualDepthPeelingSupported()
        return ret
        

    def update_lighting_uniforms(self, *args):
        """
        V.update_lighting_uniforms(ShaderProgram)
        C++: void UpdateLightingUniforms(ShaderProgram *prog)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateLightingUniforms, *my_args)
        return ret

    def update_lights(self):
        """
        V.update_lights() -> int
        
        Ask lights to load themselves into graphics pipeline.
        """
        ret = self._vtk_obj.UpdateLights()
        return ret
        

    _updateable_traits_ = \
    (('automatic_light_creation', 'GetAutomaticLightCreation'),
    ('backing_store', 'GetBackingStore'), ('draw', 'GetDraw'), ('erase',
    'GetErase'), ('interactive', 'GetInteractive'),
    ('light_follow_camera', 'GetLightFollowCamera'),
    ('preserve_color_buffer', 'GetPreserveColorBuffer'),
    ('preserve_depth_buffer', 'GetPreserveDepthBuffer'),
    ('textured_background', 'GetTexturedBackground'),
    ('two_sided_lighting', 'GetTwoSidedLighting'),
    ('use_depth_peeling_for_volumes', 'GetUseDepthPeelingForVolumes'),
    ('use_depth_peeling', 'GetUseDepthPeeling'), ('use_fxaa',
    'GetUseFXAA'), ('use_hidden_line_removal', 'GetUseHiddenLineRemoval'),
    ('use_image_based_lighting', 'GetUseImageBasedLighting'),
    ('use_shadows', 'GetUseShadows'), ('gradient_background',
    'GetGradientBackground'), ('gradient_environmental_bg',
    'GetGradientEnvironmentalBG'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('allocated_render_time', 'GetAllocatedRenderTime'), ('ambient',
    'GetAmbient'), ('clipping_range_expansion',
    'GetClippingRangeExpansion'), ('environment_right',
    'GetEnvironmentRight'), ('environment_up', 'GetEnvironmentUp'),
    ('layer', 'GetLayer'), ('maximum_number_of_peels',
    'GetMaximumNumberOfPeels'), ('near_clipping_plane_tolerance',
    'GetNearClippingPlaneTolerance'), ('occlusion_ratio',
    'GetOcclusionRatio'), ('aspect', 'GetAspect'), ('background',
    'GetBackground'), ('background2', 'GetBackground2'),
    ('background_alpha', 'GetBackgroundAlpha'), ('display_point',
    'GetDisplayPoint'), ('environmental_bg', 'GetEnvironmentalBG'),
    ('environmental_bg2', 'GetEnvironmentalBG2'), ('pixel_aspect',
    'GetPixelAspect'), ('view_point', 'GetViewPoint'), ('viewport',
    'GetViewport'), ('world_point', 'GetWorldPoint'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic_light_creation', 'backing_store', 'debug', 'draw',
    'erase', 'global_warning_display', 'gradient_background',
    'gradient_environmental_bg', 'interactive', 'light_follow_camera',
    'preserve_color_buffer', 'preserve_depth_buffer',
    'textured_background', 'two_sided_lighting', 'use_depth_peeling',
    'use_depth_peeling_for_volumes', 'use_fxaa',
    'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
    'allocated_render_time', 'ambient', 'aspect', 'background',
    'background2', 'background_alpha', 'clipping_range_expansion',
    'display_point', 'environment_right', 'environment_up',
    'environmental_bg', 'environmental_bg2', 'layer',
    'maximum_number_of_peels', 'near_clipping_plane_tolerance',
    'occlusion_ratio', 'pixel_aspect', 'view_point', 'viewport',
    'world_point'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLRenderer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic_light_creation', 'backing_store', 'draw', 'erase',
            'gradient_background', 'gradient_environmental_bg', 'interactive',
            'light_follow_camera', 'preserve_color_buffer',
            'preserve_depth_buffer', 'textured_background', 'two_sided_lighting',
            'use_depth_peeling', 'use_depth_peeling_for_volumes', 'use_fxaa',
            'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows'],
            [], ['allocated_render_time', 'ambient', 'aspect', 'background',
            'background2', 'background_alpha', 'clipping_range_expansion',
            'display_point', 'environment_right', 'environment_up',
            'environmental_bg', 'environmental_bg2', 'layer',
            'maximum_number_of_peels', 'near_clipping_plane_tolerance',
            'occlusion_ratio', 'pixel_aspect', 'view_point', 'viewport',
            'world_point']),
            title='Edit OpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

