# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_volume_mapper import AbstractVolumeMapper


class OpenGLFluidMapper(AbstractVolumeMapper):
    """
    OpenGLFluidMapper - Render fluid from position data (and color, if
    available)
    
    Superclass: AbstractVolumeMapper
    
    An open_gl mapper that display fluid volume using a screen space fluid
    rendering technique. Thanks to Nghia Truong for the algorihtm and
    initial implementation.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLFluidMapper, obj, update, **traits)
    
    scalar_visibility = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off flag to control whether scalar data is used to color
        objects.
        """
    )

    def _scalar_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarVisibility,
                        self.scalar_visibility_)

    additional_reflection = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the fluid surface additional reflection scale This value
        is in [0, 1], which 0 means using the reflection color computed
        from fresnel equation, and 1 means using reflection color as [1,
        1, 1] Default value is 0
        """
    )

    def _additional_reflection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAdditionalReflection,
                        self.additional_reflection)

    attenuation_color = tvtk_base.vtk_color_trait((0.5, 0.20000000298023224, 0.05000000074505806), desc=\
        """
        Get/Set the fluid attenuation color (color that will be absorpted
        exponentially when going through the fluid volume)
        """
    )

    def _attenuation_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttenuationColor,
                        self.attenuation_color, False)

    attenuation_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the fluid volume attenuation scale, which will be
        multiplied with attennuation color Default value is 1.0, and can
        be set to any non-negative number The larger attennuation scale,
        the darker fluid color
        """
    )

    def _attenuation_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttenuationScale,
                        self.attenuation_scale)

    opaque_color = tvtk_base.vtk_color_trait((0.0, 0.0, 0.949999988079071), desc=\
        """
        Get/Set the fluid surface color if rendered in opaque surface
        mode without particle color
        """
    )

    def _opaque_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOpaqueColor,
                        self.opaque_color, False)

    particle_color_power = traits.Float(0.10000000149011612, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the power value for particle color if input data has
        particle color Default value is 0.1, and can be set to any
        non-negative number The particle color is then recomputed as
        new_color = pow(old_color, power) * scale
        """
    )

    def _particle_color_power_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParticleColorPower,
                        self.particle_color_power)

    particle_color_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the scale value for particle color if input data has
        particle color Default value is 1.0, and can be set to any
        non-negative number The particle color is then recomputed as
        new_color = pow(old_color, power) * scale
        """
    )

    def _particle_color_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParticleColorScale,
                        self.particle_color_scale)

    particle_radius = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the particle radius, must be explicitly set by user To
        fuse the gaps between particles and obtain a smooth surface, this
        parameter need to be slightly larger than the actual particle
        radius, (particle radius is the half distance between two
        consecutive particles in regular pattern sampling)
        """
    )

    def _particle_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParticleRadius,
                        self.particle_radius)

    refraction_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the scale value for refraction This is needed for tweak
        refraction of volumes with different size scales For example,
        fluid volume having diameter of 100.0 will refract light much
        more than volume with diameter 1.0 This value is in [0, 1],
        default value is 1.0
        """
    )

    def _refraction_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRefractionScale,
                        self.refraction_scale)

    refractive_index = traits.Float(1.3300000429153442, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the fluid refraction index. The default value is 1.33
        (water)
        """
    )

    def _refractive_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRefractiveIndex,
                        self.refractive_index)

    thickness_and_volume_color_filter_radius = traits.Float(10.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the filter radius to filter the volume thickness and
        particle color This is an optional parameter, default value is 10
        (pixels)
        """
    )

    def _thickness_and_volume_color_filter_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetThicknessAndVolumeColorFilterRadius,
                        self.thickness_and_volume_color_filter_radius)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Specify the input data to map.
        """
    )

    def set_bilateral_gaussian_filter_parameter(self, *args):
        """
        V.set_bilateral_gaussian_filter_parameter(float)
        C++: void SetBilateralGaussianFilterParameter(float sigmaDepth)
        Optional parameters, exclusively for bilateral gaussian filter
        The parameter is for controlling smoothing between surface depth
        values
        """
        ret = self._wrap_call(self._vtk_obj.SetBilateralGaussianFilterParameter, *args)
        return ret

    def set_input_data(self, *args):
        """
        V.set_input_data(PolyData)
        C++: void SetInputData(PolyData *in)
        Specify the input data to map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    def set_narrow_range_filter_parameters(self, *args):
        """
        V.set_narrow_range_filter_parameters(float, float)
        C++: void SetNarrowRangeFilterParameters(float lambda, float mu)
        Optional parameters, exclusively for narrow range filter The
        first parameter is to control smoothing between surface depth
        values The second parameter is to control curvature of the
        surface edges
        """
        ret = self._wrap_call(self._vtk_obj.SetNarrowRangeFilterParameters, *args)
        return ret

    _updateable_traits_ = \
    (('scalar_visibility', 'GetScalarVisibility'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('scalar_mode', 'GetScalarMode'),
    ('additional_reflection', 'GetAdditionalReflection'),
    ('attenuation_color', 'GetAttenuationColor'), ('attenuation_scale',
    'GetAttenuationScale'), ('opaque_color', 'GetOpaqueColor'),
    ('particle_color_power', 'GetParticleColorPower'),
    ('particle_color_scale', 'GetParticleColorScale'), ('particle_radius',
    'GetParticleRadius'), ('refraction_scale', 'GetRefractionScale'),
    ('refractive_index', 'GetRefractiveIndex'),
    ('thickness_and_volume_color_filter_radius',
    'GetThicknessAndVolumeColorFilterRadius'), ('array_access_mode',
    'GetArrayAccessMode'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_visibility', 'scalar_mode',
    'additional_reflection', 'array_access_mode', 'attenuation_color',
    'attenuation_scale', 'opaque_color', 'particle_color_power',
    'particle_color_scale', 'particle_radius', 'progress_text',
    'refraction_scale', 'refractive_index',
    'thickness_and_volume_color_filter_radius'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLFluidMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLFluidMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['scalar_visibility'], ['scalar_mode'],
            ['additional_reflection', 'array_access_mode', 'attenuation_color',
            'attenuation_scale', 'opaque_color', 'particle_color_power',
            'particle_color_scale', 'particle_radius', 'refraction_scale',
            'refractive_index', 'thickness_and_volume_color_filter_radius']),
            title='Edit OpenGLFluidMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLFluidMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

