# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class HyperTreeGrid(DataObject):
    """
    HyperTreeGrid - A dataset containing a grid of HyperTree
    instances arranged as a rectilinear grid.
    
    Superclass: DataObject
    
    An hypertree grid is a dataset containing a rectilinear grid of root
    nodes, each of which can be refined as a HyperTree grid. This
    organization of the root nodes allows for the definition of
    tree-based AMR grids that do not have uniform geometry. Some filters
    can be applied on this dataset: contour, outline, geometry.
    
    JB A valider la suite The order and number of points must match that
    specified by the dimensions of the grid. The point order increases in
    i fastest (from 0<=i<dims[0]), then j (0<=j<dims[1]), then k
    (0<=k<dims[2]) where dims[] are the dimensions of the grid in the
    i-j-k topological directions. The number of points is
    dims[0]*dims[1]*dims[2]. The same is true for the cells of the grid.
    The order and number of cells must match that specified by the
    dimensions of the grid. The cell order increases in i fastest (from
    0<=i<(dims[0]-1)), then j (0<=j<(dims[1]-1)), then k
    (0<=k<(dims[2]-1)) The number of cells is
    (dims[0]-1)*(dims[1]-1)*(dims[2]-1). JB Dimensions : number of points
    by direction of rectilinear grid cell_dims : number of cells by
    directions of rectilinear grid (1 for each dimensions 1)
    
    @warning
    It is not a spatial search object. If you are looking for this kind
    of octree see CellLocator instead. Extent support is not finished
    yet.
    
    @sa
    HyperTree RectilinearGrid
    
    @par Thanks: This class was written by Philippe Pebay, Joachim
    Pouderoux, and Charles Law, Kitware 2013 This class was modified by
    Guenole Harel and Jacques-Bernard Lekien 2014 This class was
    rewritten by Philippe Pebay, 2016 This class was modified by
    Jacques-Bernard Lekien 2018 This work was supported by Commissariat a
    l'Energie Atomique CEA, DAM, DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGrid, obj, update, **traits)
    
    has_interface = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get presence or absence of interface
        """
    )

    def _has_interface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHasInterface,
                        self.has_interface_)

    branch_factor = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the subdivision factor in the grid refinement scheme
        """
    )

    def _branch_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBranchFactor,
                        self.branch_factor)

    depth_limiter = traits.Int(4294967295, enter_set=True, auto_set=False, desc=\
        """
        Set/Get depth limiter value
        """
    )

    def _depth_limiter_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDepthLimiter,
                        self.depth_limiter)

    dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(0, 0, 0), cols=3, desc=\
        """
        Set/Get sizes of this rectilinear grid dataset
        """
    )

    def _dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensions,
                        self.dimensions)

    extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int64", value=(0, -1, 0, -1, 0, -1), cols=3, desc=\
        """
        Different ways to set the extent of the data array.  The extent
        should be set before the "Scalars" are set or allocated. The
        Extent is stored in the order (X, Y, Z). Set/Get extent of this
        rectilinear grid dataset.
        """
    )

    def _extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtent,
                        self.extent)

    interface_intercepts_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get names of interface intercepts arrays
        """
    )

    def _interface_intercepts_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterfaceInterceptsName,
                        self.interface_intercepts_name)

    interface_normals_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get names of interface normal vectors arrays
        """
    )

    def _interface_normals_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterfaceNormalsName,
                        self.interface_normals_name)

    def _get_mask(self):
        return wrap_vtk(self._vtk_obj.GetMask())
    def _set_mask(self, arg):
        old_val = self._get_mask()
        my_arg = deref_array([arg], [['vtkBitArray']])
        self._wrap_call(self._vtk_obj.SetMask,
                        my_arg[0])
        self.trait_property_changed('mask', old_val, arg)
    mask = traits.Property(_get_mask, _set_mask, desc=\
        """
        Set/Get the blanking mask of primal leaf cells
        """
    )

    mode_squeeze = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get mode squeeze
        """
    )

    def _mode_squeeze_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetModeSqueeze,
                        self.mode_squeeze)

    transposed_root_indexing = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
    )

    def _transposed_root_indexing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransposedRootIndexing,
                        self.transposed_root_indexing)

    def get_tree(self, *args):
        """
        V.get_tree(int, bool) -> HyperTree
        C++: virtual HyperTree *GetTree(IdType, bool create=false)
        Return tree located at given index of hyper tree grid NB: This
        will construct a new hyper_tree if grid slot is empty.
        """
        ret = self._wrap_call(self._vtk_obj.GetTree, *args)
        return wrap_vtk(ret)

    def set_tree(self, *args):
        """
        V.set_tree(int, HyperTree)
        C++: void SetTree(IdType, HyperTree *)
        Assign given tree to given index of hyper tree grid NB: This will
        create a new slot in the grid if needed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTree, *my_args)
        return ret

    def _get_x_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetXCoordinates())
    def _set_x_coordinates(self, arg):
        old_val = self._get_x_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetXCoordinates,
                        my_arg[0])
        self.trait_property_changed('x_coordinates', old_val, arg)
    x_coordinates = traits.Property(_get_x_coordinates, _set_x_coordinates, desc=\
        """
        Set/Get the grid coordinates in the x-direction.
        """
    )

    def _get_y_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetYCoordinates())
    def _set_y_coordinates(self, arg):
        old_val = self._get_y_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetYCoordinates,
                        my_arg[0])
        self.trait_property_changed('y_coordinates', old_val, arg)
    y_coordinates = traits.Property(_get_y_coordinates, _set_y_coordinates, desc=\
        """
        Set/Get the grid coordinates in the y-direction.
        """
    )

    def _get_z_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetZCoordinates())
    def _set_z_coordinates(self, arg):
        old_val = self._get_z_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetZCoordinates,
                        my_arg[0])
        self.trait_property_changed('z_coordinates', old_val, arg)
    z_coordinates = traits.Property(_get_z_coordinates, _set_z_coordinates, desc=\
        """
        Set/Get the grid coordinates in the z-direction.
        """
    )

    def get1d_axis(self, *args):
        """
        V.get1d_axis(int)
        C++: void Get1DAxis(unsigned int &axis)
        JB retourne l'indice de la dimension valide.
        """
        ret = self._wrap_call(self._vtk_obj.Get1DAxis, *args)
        return ret

    def get2d_axes(self, *args):
        """
        V.get2d_axes(int, int)
        C++: void Get2DAxes(unsigned int &axis1, unsigned int &axis2)
        JB Retourne l'indice des deux dimensions valides.
        """
        ret = self._wrap_call(self._vtk_obj.Get2DAxes, *args)
        return ret

    def _get_actual_memory_size_bytes(self):
        return self._vtk_obj.GetActualMemorySizeBytes()
    actual_memory_size_bytes = traits.Property(_get_actual_memory_size_bytes, desc=\
        """
        Return the actual size of the data in kibibytes (1024 bytes).
        This number is valid only after the pipeline has updated. The
        memory size returned is guaranteed to be greater than or equal to
        the memory required to represent the data (e.g., extra space in
        arrays, etc. are not included in the return value). THIS METHOD
        IS THREAD SAFE.
        """
    )

    def _get_axes(self):
        return self._vtk_obj.GetAxes()
    axes = traits.Property(_get_axes, desc=\
        """
        JB Get the axis information (used for copy_structure)
        """
    )

    def _get_bounds(self):
        return self._vtk_obj.GetBounds()
    bounds = traits.Property(_get_bounds, desc=\
        """
        Return a pointer to the geometry bounding box in the form
        (xmin,xmax, ymin,ymax, zmin,zmax). THIS METHOD IS NOT THREAD
        SAFE.
        """
    )

    def get_bounds(self, *args):
        """
        V.get_bounds() -> (float, float, float, float, float, float)
        C++: virtual double *GetBounds()
        V.get_bounds([float, float, float, float, float, float])
        C++: void GetBounds(double bounds[6])
        Return a pointer to the geometry bounding box in the form
        (xmin,xmax, ymin,ymax, zmin,zmax). THIS METHOD IS NOT THREAD
        SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetBounds, *args)
        return ret

    def _get_cell_dims(self):
        return self._vtk_obj.GetCellDims()
    cell_dims = traits.Property(_get_cell_dims, desc=\
        """
        JB Get grid sizes of this structured cells dataset. Valeurs
        deduites a partir de Dimensions/Extent Les dimensions non
        exprimees auront pour valeur 1.
        """
    )

    def get_cell_dims(self, *args):
        """
        V.get_cell_dims() -> (int, int, int)
        C++: const unsigned int *GetCellDims()
        V.get_cell_dims([int, int, int])
        C++: void GetCellDims(int cellDims[3])
        JB Get grid sizes of this structured cells dataset. Valeurs
        deduites a partir de Dimensions/Extent Les dimensions non
        exprimees auront pour valeur 1.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellDims, *args)
        return ret

    def _get_center(self):
        return self._vtk_obj.GetCenter()
    center = traits.Property(_get_center, desc=\
        """
        Get the center of the bounding box. THIS METHOD IS NOT THREAD
        SAFE.
        """
    )

    def get_center(self, *args):
        """
        V.get_center() -> (float, float, float)
        C++: double *GetCenter()
        V.get_center([float, float, float])
        C++: void GetCenter(double center[3])
        Get the center of the bounding box. THIS METHOD IS NOT THREAD
        SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetCenter, *args)
        return ret

    def get_child_mask(self, *args):
        """
        V.get_child_mask(int) -> int
        C++: unsigned int GetChildMask(unsigned int)
        Return hard-coded bitcode correspondng to child mask Dimension 1:
        Factor 2: 0: 100, 1: 001 Factor 3: 0: 100, 1: 010, 2: 001
        Dimension 2: Factor 2: 0: 1101 0000 0, 1: 0110 0100 0 2: 0001
        0011 0, 3: 0000 0101 1 Factor 3: 0: 1101 0000 0, 1: 0100 0000 0,
        2: 0110 0100 0 3: 0001 0000 0, 4: 0000 1000 0, 5: 0000 0100 0 6:
        0001 0011 0, 7: 0000 0001 0, 8: 0000 0101 1 Dimension 3: Factor
        2: 0: 1101 1000 0110 1000 0000 0000 000, 1: 0110 1100 0011 0010
        0000 0000 000 2: 0001 1011 0000 1001 1000 0000 000, 3: 0000 1101
        1000 0010 1100 0000 000 4: 0000 0000 0110 1000 0011 0110 000, 5:
        0000 0000 0011 0010 0001 1011 000 6: 0000 0000 0000 1001 1000
        0110 110, 7: 0000 0000 0000 0010 1100 0011 011 Factor 3: 0: 1101
        1000 0110 1000 0000 0000 000 1: 0100 1000 0010 0000 0000 0000 000
        2: 0110 1100 0011 0010 0000 0000 000 3: 0001 1000 0000 1000 0000
        0000 000 4: 0000 1000 0000 0000 0000 0000 000 5: 0000 1100 0000
        0010 0000 0000 000 6: 0001 1011 0000 1001 1000 0000 000 7: 0000
        1001 0000 0000 1000 0000 000 8: 0000 1101 1000 0010 1100 0000 000
        9: 0000 0000 0110 1000 0000 0000 000 10: 0000 0000 0010 0000 0000
        0000 000 11: 0000 0000 0011 0010 0000 0000 000 12: 0000 0000 0000
        1000 0000 0000 000 13: 0000 0000 0000 0100 0000 0000 000 14: 0000
        0000 0000 0010 0000 0000 000 15: 0000 0000 0000 1001 1000 0000
        000 16: 0000 0000 0000 0000 1000 0000 000 17: 0000 0000 0000 0010
        1100 0000 000 18: 0000 0000 0110 1000 0011 0110 000 19: 0000 0000
        0010 0000 0001 0010 000 20: 0000 0000 0011 0010 0001 1011 000 21:
        0000 0000 0000 1000 0000 0110 000 22: 0000 0000 0000 0000 0000
        0010 000 23: 0000 0000 0000 0010 0000 0011 000 24: 0000 0000 0000
        1001 1000 0110 110 25: 0000 0000 0000 0000 1000 0010 010 26: 0000
        0000 0000 0010 1100 0011 011
        """
        ret = self._wrap_call(self._vtk_obj.GetChildMask, *args)
        return ret

    def _get_dimension(self):
        return self._vtk_obj.GetDimension()
    dimension = traits.Property(_get_dimension, desc=\
        """
        JB Get the dimensionality of the grid deduite a partir de
        Dimensions/Extent.
        """
    )

    def _get_freeze_state(self):
        return self._vtk_obj.GetFreezeState()
    freeze_state = traits.Property(_get_freeze_state, desc=\
        """
        Get the state of frozen
        """
    )

    def _get_ghost_cells(self):
        return wrap_vtk(self._vtk_obj.GetGhostCells())
    ghost_cells = traits.Property(_get_ghost_cells, desc=\
        """
        Accessor on ghost cells
        """
    )

    def _get_global_node_index_max(self):
        return self._vtk_obj.GetGlobalNodeIndexMax()
    global_node_index_max = traits.Property(_get_global_node_index_max, desc=\
        """
        JB Retourne la valeur maximale du global index. Cette information
        est indispensable pour construire une nouvelle grandeur
        puisqu'elle devra au moins etre de cette taille. Pour les memes
        raisons, dans le cas de la construction du maillage dual, afin de
        reutiliser les grandeurs de l'HTG, le nombre de sommets sera
        dimensionne a cette valeur.
        """
    )

    def get_index_from_level_zero_coordinates(self, *args):
        """
        V.get_index_from_level_zero_coordinates(int, int, int, int)
        C++: void GetIndexFromLevelZeroCoordinates(IdType &,
            unsigned int, unsigned int, unsigned int)
        Convert the Cartesian coordinates of a root in the grid  to its
        global index.
        """
        ret = self._wrap_call(self._vtk_obj.GetIndexFromLevelZeroCoordinates, *args)
        return ret

    def get_level_zero_coordinates_from_index(self, *args):
        """
        V.get_level_zero_coordinates_from_index(int, int, int, int)
        C++: void GetLevelZeroCoordinatesFromIndex(IdType,
            unsigned int &, unsigned int &, unsigned int &)
        Convert the global index of a root to its Cartesian coordinates
        in the grid.
        """
        ret = self._wrap_call(self._vtk_obj.GetLevelZeroCoordinatesFromIndex, *args)
        return ret

    def get_level_zero_origin_and_size_from_index(self, *args):
        """
        V.get_level_zero_origin_and_size_from_index(int, [float, ...], [float,
            ...])
        C++: virtual void GetLevelZeroOriginAndSizeFromIndex(IdType,
            double *, double *)
        Convert the global index of a root to its Spacial coordinates
        origin and size.
        """
        ret = self._wrap_call(self._vtk_obj.GetLevelZeroOriginAndSizeFromIndex, *args)
        return ret

    def get_level_zero_origin_from_index(self, *args):
        """
        V.get_level_zero_origin_from_index(int, [float, ...])
        C++: virtual void GetLevelZeroOriginFromIndex(IdType, double *)
        JB Convert the global index of a root to its Spacial coordinates
        origin and size.
        """
        ret = self._wrap_call(self._vtk_obj.GetLevelZeroOriginFromIndex, *args)
        return ret

    def _get_max_number_of_trees(self):
        return self._vtk_obj.GetMaxNumberOfTrees()
    max_number_of_trees = traits.Property(_get_max_number_of_trees, desc=\
        """
        Return the maximum number of trees in the level 0 grid.
        """
    )

    def _get_number_of_children(self):
        return self._vtk_obj.GetNumberOfChildren()
    number_of_children = traits.Property(_get_number_of_children, desc=\
        """
        The number of children each node can have.
        """
    )

    def _get_number_of_leaves(self):
        return self._vtk_obj.GetNumberOfLeaves()
    number_of_leaves = traits.Property(_get_number_of_leaves, desc=\
        """
        Get the number of leaves in the primal tree grid.
        """
    )

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, desc=\
        """
        Return the number of levels in an individual (primal) tree.
        """
    )

    def get_number_of_levels(self, *args):
        """
        V.get_number_of_levels(int) -> int
        C++: unsigned int GetNumberOfLevels(IdType)
        V.get_number_of_levels() -> int
        C++: unsigned int GetNumberOfLevels()
        Return the number of levels in an individual (primal) tree.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfLevels, *args)
        return ret

    def _get_number_of_vertices(self):
        return self._vtk_obj.GetNumberOfVertices()
    number_of_vertices = traits.Property(_get_number_of_vertices, desc=\
        """
        Get the number of vertices in the primal tree grid.
        """
    )

    def _get_orientation(self):
        return self._vtk_obj.GetOrientation()
    orientation = traits.Property(_get_orientation, desc=\
        """
        Get the orientation of 1d or 2d grids: . in 1d: 0, 1, 2 = aligned
        along X, Y, Z axis . in 2d: 0, 1, 2 = normal to X, Y, Z axis NB:
        Not used in 3d
        """
    )

    def _get_point_data(self):
        return wrap_vtk(self._vtk_obj.GetPointData())
    point_data = traits.Property(_get_point_data, desc=\
        """
        Return a pointer to this dataset's point/tree data. THIS METHOD
        IS THREAD SAFE
        """
    )

    def _get_pure_mask(self):
        return wrap_vtk(self._vtk_obj.GetPureMask())
    pure_mask = traits.Property(_get_pure_mask, desc=\
        """
        Get or create pure material mask
        """
    )

    def get_shifted_level_zero_index(self, *args):
        """
        V.get_shifted_level_zero_index(int, int, int, int) -> int
        C++: IdType GetShiftedLevelZeroIndex(IdType, unsigned int,
            unsigned int, unsigned int)
        Return the root index of a root cell with given index displaced.
        by a Cartesian vector in the grid. NB: No boundary checks are
        performed.
        """
        ret = self._wrap_call(self._vtk_obj.GetShiftedLevelZeroIndex, *args)
        return ret

    def _get_tree_ghost_array(self):
        return wrap_vtk(self._vtk_obj.GetTreeGhostArray())
    tree_ghost_array = traits.Property(_get_tree_ghost_array, desc=\
        """
        Gets the array that defines the ghost type of each point. We
        cache the pointer to the array to save a lookup involving string
        comparisons
        """
    )

    def allocate_tree_ghost_array(self):
        """
        V.allocate_tree_ghost_array() -> UnsignedCharArray
        C++: UnsignedCharArray *AllocateTreeGhostArray()
        Allocate ghost array for points.
        """
        ret = wrap_vtk(self._vtk_obj.AllocateTreeGhostArray())
        return ret
        

    def copy_coordinates(self, *args):
        """
        V.copy_coordinates(HyperTreeGrid)
        C++: virtual void CopyCoordinates(const HyperTreeGrid *output)
        JB Augented services on Coordinates.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyCoordinates, *my_args)
        return ret

    def copy_empty_structure(self, *args):
        """
        V.copy_empty_structure(DataObject)
        C++: virtual void CopyEmptyStructure(DataObject *)
        Copy the internal structure with no data associated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyEmptyStructure, *my_args)
        return ret

    def copy_structure(self, *args):
        """
        V.copy_structure(DataObject)
        C++: virtual void CopyStructure(DataObject *)
        Copy the internal geometric and topological structure of a
        HyperTreeGrid object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyStructure, *my_args)
        return ret

    def DIMENSION(self):
        """
        V.dimension() -> InformationIntegerKey
        C++: static InformationIntegerKey *DIMENSION()"""
        ret = wrap_vtk(self._vtk_obj.DIMENSION())
        return ret
        

    def find_dichotomic_x(self, *args):
        """
        V.find_dichotomic_x(float) -> int
        C++: virtual unsigned int FindDichotomicX(double value)"""
        ret = self._wrap_call(self._vtk_obj.FindDichotomicX, *args)
        return ret

    def find_dichotomic_y(self, *args):
        """
        V.find_dichotomic_y(float) -> int
        C++: virtual unsigned int FindDichotomicY(double value)"""
        ret = self._wrap_call(self._vtk_obj.FindDichotomicY, *args)
        return ret

    def find_dichotomic_z(self, *args):
        """
        V.find_dichotomic_z(float) -> int
        C++: virtual unsigned int FindDichotomicZ(double value)"""
        ret = self._wrap_call(self._vtk_obj.FindDichotomicZ, *args)
        return ret

    def find_non_oriented_geometry_cursor(self, *args):
        """
        V.find_non_oriented_geometry_cursor([float, float, float])
            -> HyperTreeGridNonOrientedGeometryCursor
        C++: HyperTreeGridNonOrientedGeometryCursor *FindNonOrientedGeometryCursor(
            double x[3])
        JB Retourne un curseur geometrique pointant une des mailles
        comportant la position spatiale x
        """
        ret = self._wrap_call(self._vtk_obj.FindNonOrientedGeometryCursor, *args)
        return wrap_vtk(ret)

    def has_any_ghost_cells(self):
        """
        V.has_any_ghost_cells() -> bool
        C++: bool HasAnyGhostCells()
        Returns 1 if there are any ghost cells 0 otherwise.
        """
        ret = self._vtk_obj.HasAnyGhostCells()
        return ret
        

    def has_mask(self):
        """
        V.has_mask() -> bool
        C++: bool HasMask()
        Determine whether blanking mask is empty or not
        """
        ret = self._vtk_obj.HasMask()
        return ret
        

    def initialize_local_index_node(self):
        """
        V.initialize_local_index_node()
        C++: void InitializeLocalIndexNode()
        JB Permet d'initialiser les index locaux de chacun des HT de cet
        HTG une fois que TOUS les HTs aient ete COMPLETEMENT
        construits/raffines ! A l'utilisateur ensuite de fournir les
        grandeurs suivant cet ordre.
        """
        ret = self._vtk_obj.InitializeLocalIndexNode()
        return ret
        

    def initialize_non_oriented_cursor(self, *args):
        """
        V.initialize_non_oriented_cursor(HyperTreeGridNonOrientedCursor,
            int, bool)
        C++: void InitializeNonOrientedCursor(
            HyperTreeGridNonOrientedCursor *cursor, IdType index,
            bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedCursor, *my_args)
        return ret

    def initialize_non_oriented_geometry_cursor(self, *args):
        """
        V.initialize_non_oriented_geometry_cursor(
            HyperTreeGridNonOrientedGeometryCursor, int, bool)
        C++: void InitializeNonOrientedGeometryCursor(
            HyperTreeGridNonOrientedGeometryCursor *cursor,
            IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedGeometryCursor, *my_args)
        return ret

    def initialize_non_oriented_moore_super_cursor(self, *args):
        """
        V.initialize_non_oriented_moore_super_cursor(
            HyperTreeGridNonOrientedMooreSuperCursor, int, bool)
        C++: void InitializeNonOrientedMooreSuperCursor(
            HyperTreeGridNonOrientedMooreSuperCursor *cursor,
            IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedMooreSuperCursor, *my_args)
        return ret

    def initialize_non_oriented_moore_super_cursor_light(self, *args):
        """
        V.initialize_non_oriented_moore_super_cursor_light(
            HyperTreeGridNonOrientedMooreSuperCursorLight, int, bool)
        C++: void InitializeNonOrientedMooreSuperCursorLight(
            HyperTreeGridNonOrientedMooreSuperCursorLight *cursor,
            IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedMooreSuperCursorLight, *my_args)
        return ret

    def initialize_non_oriented_von_neumann_super_cursor(self, *args):
        """
        V.initialize_non_oriented_von_neumann_super_cursor(
            HyperTreeGridNonOrientedVonNeumannSuperCursor, int, bool)
        C++: void InitializeNonOrientedVonNeumannSuperCursor(
            HyperTreeGridNonOrientedVonNeumannSuperCursor *cursor,
            IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedVonNeumannSuperCursor, *my_args)
        return ret

    def initialize_non_oriented_von_neumann_super_cursor_light(self, *args):
        """
        V.initialize_non_oriented_von_neumann_super_cursor_light(
            HyperTreeGridNonOrientedVonNeumannSuperCursorLight, int,
            bool)
        C++: void InitializeNonOrientedVonNeumannSuperCursorLight(
            HyperTreeGridNonOrientedVonNeumannSuperCursorLight *cursor,
             IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeNonOrientedVonNeumannSuperCursorLight, *my_args)
        return ret

    def initialize_oriented_cursor(self, *args):
        """
        V.initialize_oriented_cursor(HyperTreeGridOrientedCursor, int,
            bool)
        C++: void InitializeOrientedCursor(
            HyperTreeGridOrientedCursor *cursor, IdType index,
            bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeOrientedCursor, *my_args)
        return ret

    def initialize_oriented_geometry_cursor(self, *args):
        """
        V.initialize_oriented_geometry_cursor(
            HyperTreeGridOrientedGeometryCursor, int, bool)
        C++: void InitializeOrientedGeometryCursor(
            HyperTreeGridOrientedGeometryCursor *cursor,
            IdType index, bool create=false)
        JB
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeOrientedGeometryCursor, *my_args)
        return ret

    def LEVELS(self):
        """
        V.levels() -> InformationIntegerKey
        C++: static InformationIntegerKey *LEVELS()"""
        ret = wrap_vtk(self._vtk_obj.LEVELS())
        return ret
        

    def new_non_oriented_cursor(self, *args):
        """
        V.new_non_oriented_cursor(int, bool)
            -> HyperTreeGridNonOrientedCursor
        C++: HyperTreeGridNonOrientedCursor *NewNonOrientedCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedCursor, *args)
        return wrap_vtk(ret)

    def new_non_oriented_geometry_cursor(self, *args):
        """
        V.new_non_oriented_geometry_cursor(int, bool)
            -> HyperTreeGridNonOrientedGeometryCursor
        C++: HyperTreeGridNonOrientedGeometryCursor *NewNonOrientedGeometryCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedGeometryCursor, *args)
        return wrap_vtk(ret)

    def new_non_oriented_moore_super_cursor(self, *args):
        """
        V.new_non_oriented_moore_super_cursor(int, bool)
            -> HyperTreeGridNonOrientedMooreSuperCursor
        C++: HyperTreeGridNonOrientedMooreSuperCursor *NewNonOrientedMooreSuperCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedMooreSuperCursor, *args)
        return wrap_vtk(ret)

    def new_non_oriented_moore_super_cursor_light(self, *args):
        """
        V.new_non_oriented_moore_super_cursor_light(int, bool)
            -> HyperTreeGridNonOrientedMooreSuperCursorLight
        C++: HyperTreeGridNonOrientedMooreSuperCursorLight *NewNonOrientedMooreSuperCursorLight(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedMooreSuperCursorLight, *args)
        return wrap_vtk(ret)

    def new_non_oriented_von_neumann_super_cursor(self, *args):
        """
        V.new_non_oriented_von_neumann_super_cursor(int, bool)
            -> HyperTreeGridNonOrientedVonNeumannSuperCursor
        C++: HyperTreeGridNonOrientedVonNeumannSuperCursor *NewNonOrientedVonNeumannSuperCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedVonNeumannSuperCursor, *args)
        return wrap_vtk(ret)

    def new_non_oriented_von_neumann_super_cursor_light(self, *args):
        """
        V.new_non_oriented_von_neumann_super_cursor_light(int, bool)
            -> HyperTreeGridNonOrientedVonNeumannSuperCursorLight
        C++: HyperTreeGridNonOrientedVonNeumannSuperCursorLight *NewNonOrientedVonNeumannSuperCursorLight(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewNonOrientedVonNeumannSuperCursorLight, *args)
        return wrap_vtk(ret)

    def new_oriented_cursor(self, *args):
        """
        V.new_oriented_cursor(int, bool) -> HyperTreeGridOrientedCursor
        C++: HyperTreeGridOrientedCursor *NewOrientedCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewOrientedCursor, *args)
        return wrap_vtk(ret)

    def new_oriented_geometry_cursor(self, *args):
        """
        V.new_oriented_geometry_cursor(int, bool)
            -> HyperTreeGridOrientedGeometryCursor
        C++: HyperTreeGridOrientedGeometryCursor *NewOrientedGeometryCursor(
            IdType index, bool create=false)"""
        ret = self._wrap_call(self._vtk_obj.NewOrientedGeometryCursor, *args)
        return wrap_vtk(ret)

    def ORIENTATION(self):
        """
        V.orientation() -> InformationIntegerKey
        C++: static InformationIntegerKey *ORIENTATION()"""
        ret = wrap_vtk(self._vtk_obj.ORIENTATION())
        return ret
        

    def recursively_initialize_pure_mask(self, *args):
        """
        V.recursively_initialize_pure_mask(HyperTreeGridNonOrientedCursor,
             DataArray) -> bool
        C++: bool RecursivelyInitializePureMask(
            HyperTreeGridNonOrientedCursor *cursor,
            DataArray *normale)
        Recursively initialize pure material mask
        """
        my_args = deref_array(args, [('vtkHyperTreeGridNonOrientedCursor', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.RecursivelyInitializePureMask, *my_args)
        return ret

    def SIZES(self):
        """
        V.sizes() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *SIZES()"""
        ret = wrap_vtk(self._vtk_obj.SIZES())
        return ret
        

    def set_fixed_coordinates(self, *args):
        """
        V.set_fixed_coordinates(int, float)
        C++: virtual void SetFixedCoordinates(unsigned int axis,
            double value)
        JB Augented services on Coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.SetFixedCoordinates, *args)
        return ret

    def set_indexing_mode_to_ijk(self):
        """
        V.set_indexing_mode_to_ijk()
        C++: void SetIndexingModeToIJK()
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
        ret = self._vtk_obj.SetIndexingModeToIJK()
        return ret
        

    def set_indexing_mode_to_kji(self):
        """
        V.set_indexing_mode_to_kji()
        C++: void SetIndexingModeToKJI()
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
        ret = self._vtk_obj.SetIndexingModeToKJI()
        return ret
        

    def squeeze(self):
        """
        V.squeeze()
        C++: virtual void Squeeze()
        Squeeze this representation.
        """
        ret = self._vtk_obj.Squeeze()
        return ret
        

    _updateable_traits_ = \
    (('has_interface', 'GetHasInterface'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('branch_factor', 'GetBranchFactor'), ('depth_limiter',
    'GetDepthLimiter'), ('dimensions', 'GetDimensions'), ('extent',
    'GetExtent'), ('interface_intercepts_name',
    'GetInterfaceInterceptsName'), ('interface_normals_name',
    'GetInterfaceNormalsName'), ('mode_squeeze', 'GetModeSqueeze'),
    ('transposed_root_indexing', 'GetTransposedRootIndexing'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'has_interface', 'branch_factor', 'depth_limiter', 'dimensions',
    'extent', 'interface_intercepts_name', 'interface_normals_name',
    'mode_squeeze', 'transposed_root_indexing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag', 'has_interface'], [],
            ['branch_factor', 'depth_limiter', 'dimensions', 'extent',
            'interface_intercepts_name', 'interface_normals_name', 'mode_squeeze',
            'transposed_root_indexing']),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

