# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_tree import DataObjectTree


class PartitionedDataSet(DataObjectTree):
    """
    PartitionedDataSet - composite dataset to encapsulates a dataset
    consisting of partitions.
    
    Superclass: DataObjectTree
    
    A PartitionedDataSet dataset groups multiple datasets together.
    For example, say a simulation running in parallel on 16 processes
    generated 16 datasets that when considering together form a whole
    dataset. These are referred to as the partitions of the whole
    dataset. Now imagine that we want to load a volume of 16 partitions
    in a visualization cluster of 4 nodes. Each node could get 4
    partitions, not necessarily forming a whole rectangular region. In
    this case, it is not possible to append the 4 partitions together
    into a ImageData. We can then collect these 4 partitions together
    using a PartitionedDataSet.
    
    It is required that all non-empty partitions have the same arrays and
    that they can be processed together as a whole by the same kind of
    filter. However, it is not required that they are of the same type.
    For example, it is possible to have structured datasets together with
    unstructured datasets as long as they are compatible meshes (i.e. can
    be processed together for the same kind of filter).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionedDataSet, obj, update, **traits)
    
    number_of_partitions = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the number of partitionss. This will cause allocation if the
        new number of partitions is greater than the current size. All
        new partitions are initialized to null.
        """
    )

    def _number_of_partitions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPartitions,
                        self.number_of_partitions)

    def get_partition(self, *args):
        """
        V.get_partition(int) -> DataSet
        C++: DataSet *GetPartition(unsigned int idx)
        Returns the partition at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetPartition, *args)
        return wrap_vtk(ret)

    def set_partition(self, *args):
        """
        V.set_partition(int, DataObject)
        C++: void SetPartition(unsigned int idx, DataObject *partition)
        Sets the data object as the given partition. The total number of
        partitions will be resized to fit the requested partition no.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPartition, *my_args)
        return ret

    def get_partition_as_data_object(self, *args):
        """
        V.get_partition_as_data_object(int) -> DataObject
        C++: DataObject *GetPartitionAsDataObject(unsigned int idx)
        Returns the partition at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetPartitionAsDataObject, *args)
        return wrap_vtk(ret)

    def remove_null_partitions(self):
        """
        V.remove_null_partitions()
        C++: void RemoveNullPartitions()
        Removes all partitions that have null datasets and resizes the
        dataset. Note any meta data associated with the null datasets
        will get lost.
        """
        ret = self._vtk_obj.RemoveNullPartitions()
        return ret
        

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_partitions', 'GetNumberOfPartitions'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'number_of_partitions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionedDataSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionedDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['number_of_partitions']),
            title='Edit PartitionedDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionedDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

