# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.actor import Actor


class FlagpoleLabel(Actor):
    """
    FlagpoleLabel - Renders a flagpole (line) with a label at the top
    that faces the camera
    
    Superclass: Actor
    
    This class draws a line from the base to the top of the flagpole. It
    then places a text annotation at the top, centered horizontally. The
    text is always oriented with the flagpole but will rotate aroundthe
    flagpole to face the camera.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFlagpoleLabel, obj, update, **traits)
    
    base_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        
        """
    )

    def _base_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBasePosition,
                        self.base_position)

    flag_size = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _flag_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFlagSize,
                        self.flag_size)

    def _get_input(self):
        return self._vtk_obj.GetInput()
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        arg)
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        """
        
        """
    )

    def _get_text_property(self):
        return wrap_vtk(self._vtk_obj.GetTextProperty())
    def _set_text_property(self, arg):
        old_val = self._get_text_property()
        self._wrap_call(self._vtk_obj.SetTextProperty,
                        deref_vtk(arg))
        self.trait_property_changed('text_property', old_val, arg)
    text_property = traits.Property(_get_text_property, _set_text_property, desc=\
        """
        
        """
    )

    top_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 1.0, 0.0), cols=3, desc=\
        """
        
        """
    )

    def _top_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTopPosition,
                        self.top_position)

    _updateable_traits_ = \
    (('force_opaque', 'GetForceOpaque'), ('force_translucent',
    'GetForceTranslucent'), ('dragable', 'GetDragable'), ('pickable',
    'GetPickable'), ('use_bounds', 'GetUseBounds'), ('visibility',
    'GetVisibility'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('base_position', 'GetBasePosition'),
    ('flag_size', 'GetFlagSize'), ('top_position', 'GetTopPosition'),
    ('orientation', 'GetOrientation'), ('origin', 'GetOrigin'),
    ('position', 'GetPosition'), ('scale', 'GetScale'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'force_opaque', 'force_translucent',
    'global_warning_display', 'pickable', 'use_bounds', 'visibility',
    'base_position', 'estimated_render_time', 'flag_size', 'orientation',
    'origin', 'position', 'render_time_multiplier', 'scale',
    'top_position'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FlagpoleLabel, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FlagpoleLabel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['force_opaque', 'force_translucent', 'use_bounds',
            'visibility'], [], ['base_position', 'estimated_render_time',
            'flag_size', 'orientation', 'origin', 'position',
            'render_time_multiplier', 'scale', 'top_position']),
            title='Edit FlagpoleLabel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FlagpoleLabel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

