# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_processing_pass import ImageProcessingPass


class ToneMappingPass(ImageProcessingPass):
    """
    ToneMappingPass - Implement a post-processing Tone Mapping.
    
    Superclass: ImageProcessingPass
    
    Tone mapping is the process of mapping HDR colors to [0;1] range.
    This render pass supports four different modes:
    - Clamp: clamps the color to [0;1] range
    - Reinhard: maps the color using formula: x/(x+1)
    - Exponential: maps the colors using a coefficient and the formula:
      1-exp(-a*x)
    - generic_filmic: maps the color using five parameters that allow to
      shape the tonemapping curve : Contrast adjust the toe (left part)
      of the curve; Shoulder adjusts the right part; mid_in and mid_out
      adjusts the middle gray level in percent of the curve for input and
    output (ie. the halfway point between white and black); and hdr_max is
    the maximum HDR input that is not clipped. A boolean use_aces allows
      to use the Academy Color Encoding System.
    
    Advanced tone mapping like generic_filmic, Reinhard or Exponential can
    be useful when several lights are added to the renderer.
    
    @sa
    RenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkToneMappingPass, obj, update, **traits)
    
    contrast = traits.Trait(1.677299976348877, traits.Range(9.999999747378752e-05, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Contrast adjust the toe of the curve. Typically in [1-2]. Default
        is 1.6773
        """
    )

    def _contrast_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContrast,
                        self.contrast)

    exposure = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set Exposure coefficient used for exponential and Generic
        Filmic tone mapping. Default is 1.0
        """
    )

    def _exposure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExposure,
                        self.exposure)

    hdr_max = traits.Trait(11.078499794006348, traits.Range(1.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Maximum HDR input that is not clipped. Defalut is 11.0785
        """
    )

    def _hdr_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHdrMax,
                        self.hdr_max)

    mid_in = traits.Trait(0.18000000715255737, traits.Range(9.999999747378752e-05, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Mid level anchor input. Default is 0.18 (in percent gray)
        """
    )

    def _mid_in_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMidIn,
                        self.mid_in)

    mid_out = traits.Trait(0.18000000715255737, traits.Range(9.999999747378752e-05, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Mid level anchor output. Default is 0.18 (in percent gray)
        """
    )

    def _mid_out_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMidOut,
                        self.mid_out)

    shoulder = traits.Trait(0.9714000225067139, traits.Range(9.999999747378752e-05, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Shoulder limit the output in the shoulder region of the curve.
        Typically in [0.9-1]. Default is 0.9714
        """
    )

    def _shoulder_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShoulder,
                        self.shoulder)

    tone_mapping_type = traits.Trait(3, traits.Range(0, 3, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the tone mapping type. Default is generic_filmic
        """
    )

    def _tone_mapping_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToneMappingType,
                        self.tone_mapping_type)

    use_aces = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Apply or not the Academy Color Encoding System (ACES). Default is
        true
        """
    )

    def _use_aces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseACES,
                        self.use_aces)

    def set_generic_filmic_default_presets(self):
        """
        V.set_generic_filmic_default_presets()
        C++: void SetGenericFilmicDefaultPresets()
        Set function to set uncharted 2 presets, and default presets
        """
        ret = self._vtk_obj.SetGenericFilmicDefaultPresets()
        return ret
        

    def set_generic_filmic_uncharted2_presets(self):
        """
        V.set_generic_filmic_uncharted2_presets()
        C++: void SetGenericFilmicUncharted2Presets()
        Set function to set uncharted 2 presets, and default presets
        """
        ret = self._vtk_obj.SetGenericFilmicUncharted2Presets()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('contrast', 'GetContrast'), ('exposure',
    'GetExposure'), ('hdr_max', 'GetHdrMax'), ('mid_in', 'GetMidIn'),
    ('mid_out', 'GetMidOut'), ('shoulder', 'GetShoulder'),
    ('tone_mapping_type', 'GetToneMappingType'), ('use_aces',
    'GetUseACES'), ('active_draw_buffers', 'GetActiveDrawBuffers'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'active_draw_buffers',
    'contrast', 'exposure', 'hdr_max', 'mid_in', 'mid_out', 'shoulder',
    'tone_mapping_type', 'use_aces'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ToneMappingPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_draw_buffers', 'contrast', 'exposure',
            'hdr_max', 'mid_in', 'mid_out', 'shoulder', 'tone_mapping_type',
            'use_aces']),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

