# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_texture import OpenGLTexture


class PBRLUTTexture(OpenGLTexture):
    """
    PBRLUTTexture - precompute BRDF look-up table texture used in
    physically based rendering
    
    Superclass: OpenGLTexture
    
    This texture is a 2d texture which precompute Fresnel response scale
    (red) and bias (green) based on roughness (x) and angle between light
    and normal (y).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPBRLUTTexture, obj, update, **traits)
    
    lut_samples = traits.Int(1024, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the number of samples used during Monte-Carlo
        integration. Default is 512.
        """
    )

    def _lut_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLUTSamples,
                        self.lut_samples)

    lut_size = traits.Int(512, enter_set=True, auto_set=False, desc=\
        """
        Set/Get size of texture. Default is 1024.
        """
    )

    def _lut_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLUTSize,
                        self.lut_size)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input as a ImageData object.  This method is for
        backwards compatibility.
        """
    )

    _updateable_traits_ = \
    (('cube_map', 'GetCubeMap'), ('edge_clamp', 'GetEdgeClamp'),
    ('interpolate', 'GetInterpolate'), ('mipmap', 'GetMipmap'),
    ('premultiplied_alpha', 'GetPremultipliedAlpha'), ('repeat',
    'GetRepeat'), ('restrict_power_of2_image_smaller',
    'GetRestrictPowerOf2ImageSmaller'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('quality', 'GetQuality'), ('lut_samples',
    'GetLUTSamples'), ('lut_size', 'GetLUTSize'), ('is_depth_texture',
    'GetIsDepthTexture'), ('texture_type', 'GetTextureType'),
    ('blending_mode', 'GetBlendingMode'),
    ('maximum_anisotropic_filtering', 'GetMaximumAnisotropicFiltering'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cube_map', 'debug', 'edge_clamp',
    'global_warning_display', 'interpolate', 'mipmap',
    'premultiplied_alpha', 'release_data_flag', 'repeat',
    'restrict_power_of2_image_smaller', 'use_srgb_color_space',
    'color_mode', 'quality', 'blending_mode', 'is_depth_texture',
    'lut_samples', 'lut_size', 'maximum_anisotropic_filtering',
    'progress_text', 'texture_type'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PBRLUTTexture, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PBRLUTTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cube_map', 'edge_clamp', 'interpolate', 'mipmap',
            'premultiplied_alpha', 'repeat', 'restrict_power_of2_image_smaller',
            'use_srgb_color_space'], ['color_mode', 'quality'], ['blending_mode',
            'is_depth_texture', 'lut_samples', 'lut_size',
            'maximum_anisotropic_filtering', 'texture_type']),
            title='Edit PBRLUTTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PBRLUTTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

