# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class CellArray(Object):
    """
    CellArray - object to represent cell connectivity
    
    Superclass: Object
    
    CellArray stores dataset topologies as an explicit connectivity
    table listing the point ids that make up each cell.
    
    Internally, the connectivity table is represented as two arrays:
    Offsets and Connectivity.
    
    Offsets is an array of [num_cells+_1] values indicating the index in
    the Connectivity array where each cell's points start. The last value
    is always the length of the Connectivity array.
    
    The Connectivity array stores the lists of point ids for each cell.
    
    Thus, for a dataset consisting of 2 triangles, a quad, and a line,
    the internal arrays will appear as follows:
    
    ``` Topology:
    --------- Cell 0: Triangle | point ids: {0, 1, 2} Cell 1: Triangle |
        point ids: {5, 7, 2} Cell 2: Quad     | point ids: {3, 4, 6, 7}
        Cell 4: Line     | point ids: {5, 8}
    
    CellArray (current):
    ----------------------- Offsets:      {0, 3, 6, 10, 12} Connectivity:
    {0, 1, 2, 5, 7, 2, 3, 4, 6, 7, 5, 8} ```
    
    While this class provides traversal methods (the legacy
    init_traversal(), get_next_cell() methods, and the newer method
    get_cell_at_id()) these are in general not thread-safe. Whenever
    possible it is preferrable to use a local thread-safe,
    CellArrayIterator object, which can be obtained via:
    
    ``` auto iter = vtk::TakeSmartPointer(cellArray->NewIterator()); for
    (iter->_go_to_first_cell(); !iter->_is_done_with_traversal();
    iter->_go_to_next_cell()) {
      // do work with iter } ``` (Note however that depending on the type
    and structure of internal storage, a cell array iterator may be
    significantly slower than direct traversal over the cell array due to
    extra data copying. Factors of 3-_4x are not uncommon. See
    CellArrayIterator for more information. Also note that an iterator
    may become invalid if the internal CellArray storage is modified.)
    
    Other methods are also available for allocation and memory-related
    management; insertion of new cells into the CellArray; and limited
    editing operations such as replacing one cell with a new cell of the
    same size.
    
    The internal arrays may store either 32- or 64-bit values, though
    most of the API will prefer to use IdType to refer to items in
    these arrays. This enables significant memory savings when IdType
    is 64-bit, but 32 bits are sufficient to store all of the values in
    the connectivity table. Using 64-bit storage with a 32-bit IdType
    is permitted, but values too large to fit in a 32-bit signed integer
    will be truncated when accessed through the API. (The particular
    internal storage type has implications on performance depending on
    IdType. If the internal storage is equivalent to IdType, then
    methods that return pointers to arrays of point ids can share the
    internal storage; otherwise a copy of internal memory must be
    performed.)
    
    Methods for managing the storage type are:
    
    - `bool is_storage64_bit()`
    - `bool is_storage_shareable() // Can pointers to internal storage be
      shared`
    - `void use32_bit_storage()`
    - `void use64_bit_storage()`
    - `void use_default_storage() // Depends on IdType`
    - `bool can_convert_to32_bit_storage()`
    - `bool can_convert_to64_bit_storage()`
    - `bool can_convert_to_default_storage() // Depends on IdType`
    - `bool convert_to32_bit_storage()`
    - `bool convert_to64_bit_storage()`
    - `bool convert_to_default_storage() // Depends on IdType`
    - `bool convert_to_smallest_storage() // Depends on current values in
      arrays`
    
    Note that some legacy methods are still available that reflect the
    previous storage format of this data, which embedded the cell sizes
    into the Connectivity array:
    
    ``` CellArray (legacy):
    ---------------------- Connectivity: {3, 0, 1, 2, 3, 5, 7, 2, 4, 3,
        4, 6, 7, 2, 5, 8} |--Cell 0--||--Cell 1--||----Cell 2---||--C3-|
        ```
    
    The methods require an external lookup table to allow random access,
    which was historically stored in the CellTypes object. The
    following methods in CellArray still support this style of
    indexing for compatibility purposes, but these are slow as they must
    perform some complex computations to convert the old "location" into
    the new "offset" and should be avoided. These methods (and their
    modern equivalents) are:
    
    - get_cell (Prefer get_cell_at_id)
    - get_insert_location (Prefer get_number_of_cells)
    - get_traversal_location (Prefer get_traversal_cell_id, or better,
      new_iterator)
    - set_traversal_location (Prefer set_traversal_location, or better,
      new_iterator)
    - reverse_cell (Prefer reverse_cell_at_id)
    - replace_cell (Prefer replace_cell_at_id)
    - set_cells (Use import_legacy_format, or set_data)
    - get_data (Use export_legacy_format, or
      Get[Offsets|Connectivity]Array[|32|64])
    
    Some other legacy methods were completely removed, such as
    get_pointer() / write_pointer(), since they are cannot be effectively
    emulated under the current design. If external code needs to support
    both the old and new version of the CellArray API, the
    VTK_CELL_ARRAY_V2 preprocessor definition may be used to detect which
    API is being compiled against.
    
    @sa CellTypes CellLinks
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellArray, obj, update, **traits)
    
    def get_data(self):
        """
        V.get_data() -> IdTypeArray
        C++: IdTypeArray *GetData()
        Return the underlying data as a data array.
        
        @warning The returned array is not the actual internal
            representation used
        by CellArray. Modifications to the returned array will not
        change the CellArray's topology.
        
        ote Use export_legacy_format, or
        get_offsets_array/_get_connectivity_array instead.
        """
        ret = wrap_vtk(self._vtk_obj.GetData())
        return ret
        

    def set_data(self, *args):
        """
        V.set_data(DataArray, DataArray) -> bool
        C++: bool SetData(DataArray *offsets,
            DataArray *connectivity)
        Sets the internal arrays to the supplied offsets and connectivity
        arrays.
        
        This is a convenience method, and may fail if the following
        conditions are not met:
        
        - Both arrays must be of the same type.
        - The array type must be one of the types in input_array_list.
        
        If invalid arrays are passed in, an error is logged and the
        function will return false.
        """
        my_args = deref_array(args, [('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.SetData, *my_args)
        return ret

    number_of_cells = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the number of cells in the array. DO NOT do any kind of
        allocation, advanced use only.
        
        ote This call has no effect.
        """
    )

    def _number_of_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfCells,
                        self.number_of_cells)

    traversal_cell_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _traversal_cell_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTraversalCellId,
                        self.traversal_cell_id)

    traversal_location = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _traversal_location_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTraversalLocation,
                        self.traversal_location)

    def _get_actual_memory_size(self):
        return self._vtk_obj.GetActualMemorySize()
    actual_memory_size = traits.Property(_get_actual_memory_size, desc=\
        """
        Return the memory in kibibytes (1024 bytes) consumed by this cell
        array. Used to support streaming and reading/writing data. The
        value returned is guaranteed to be greater than or equal to the
        memory required to actually represent the data represented by
        this object. The information returned is valid only after the
        pipeline has been updated.
        """
    )

    def get_cell(self, *args):
        """
        V.get_cell(int, int, (int, ...))
        C++: void GetCell(IdType loc, IdType &npts,
            const IdType *&pts)
        V.get_cell(int, IdList)
        C++: void GetCell(IdType loc, IdList *pts)
        Internal method used to retrieve a cell given a legacy offset
        location.
        
        @warning Subsequent calls to this method may invalidate previous
            call
        results.
        
        ote The location-based API is now a super-slow compatibility
        layer. Prefer get_cell_at_id.
        """
        my_args = deref_array(args, [('int', 'int', ('int', Ellipsis)), ('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCell, *my_args)
        return ret

    def get_cell_at_id(self, *args):
        """
        V.get_cell_at_id(int, int, (int, ...))
        C++: void GetCellAtId(IdType cellId, IdType &cellSize,
            IdType const *&cellPoints)
        V.get_cell_at_id(int, IdList)
        C++: void GetCellAtId(IdType cellId, IdList *pts)
        Return the point ids for the cell at cell_id.
        
        @warning Subsequent calls to this method may invalidate previous
            call
        results if the internal storage type is not the same as IdType
        and cannot be shared through the cell_points pointer. In other
        words, the method may not be thread safe. Check if shareable
        (using is_storage_shareable()), or use a CellArrayIterator to
        guarantee thread safety.
        """
        my_args = deref_array(args, [('int', 'int', ('int', Ellipsis)), ('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCellAtId, *my_args)
        return ret

    def get_cell_size(self, *args):
        """
        V.get_cell_size(int) -> int
        C++: IdType GetCellSize(const IdType cellId)
        Return the size of the cell at cell_id.
        """
        ret = self._wrap_call(self._vtk_obj.GetCellSize, *args)
        return ret

    def _get_connectivity_array(self):
        return wrap_vtk(self._vtk_obj.GetConnectivityArray())
    connectivity_array = traits.Property(_get_connectivity_array, desc=\
        """
        
        """
    )

    def _get_connectivity_array32(self):
        return wrap_vtk(self._vtk_obj.GetConnectivityArray32())
    connectivity_array32 = traits.Property(_get_connectivity_array32, desc=\
        """
        
        """
    )

    def _get_connectivity_array64(self):
        return wrap_vtk(self._vtk_obj.GetConnectivityArray64())
    connectivity_array64 = traits.Property(_get_connectivity_array64, desc=\
        """
        
        """
    )

    def get_insert_location(self, *args):
        """
        V.get_insert_location(int) -> int
        C++: IdType GetInsertLocation(int npts)
        Computes the current legacy insertion location within the
        internal array. Used in conjunction with get_cell(int loc,...).
        
        ote The location-based API is now a super-slow compatibility
        layer.
        """
        ret = self._wrap_call(self._vtk_obj.GetInsertLocation, *args)
        return ret

    def _get_max_cell_size(self):
        return self._vtk_obj.GetMaxCellSize()
    max_cell_size = traits.Property(_get_max_cell_size, desc=\
        """
        Returns the size of the largest cell. The size is the number of
        points defining the cell.
        """
    )

    def get_next_cell(self, *args):
        """
        V.get_next_cell(int, (int, ...)) -> int
        C++: int GetNextCell(IdType &npts, IdType const *&pts)
        V.get_next_cell(IdList) -> int
        C++: int GetNextCell(IdList *pts)
        @warning This method is not thread-safe. Consider using the
            new_iterator()
        iterator instead.
        
        get_next_cell() gets the next cell in the list. If end of list is
        encountered, 0 is returned. A value of 1 is returned whenever
        npts and pts have been updated without error.
        
        Do not modify the returned pts pointer, as it may point to shared
        memory.
        
        ote This method is not thread-safe and has tricky syntax to use
        correctly. Prefer the use of CellArrayIterator (see
        new_iterator()).
        """
        my_args = deref_array(args, [('int', ('int', Ellipsis)), ['vtkIdList']])
        ret = self._wrap_call(self._vtk_obj.GetNextCell, *my_args)
        return ret

    def _get_number_of_connectivity_entries(self):
        return self._vtk_obj.GetNumberOfConnectivityEntries()
    number_of_connectivity_entries = traits.Property(_get_number_of_connectivity_entries, desc=\
        """
        Return the size of the array that would be returned from
        export_legacy_format().
        
        ote Method incompatible with current internal storage.
        """
    )

    def _get_number_of_connectivity_ids(self):
        return self._vtk_obj.GetNumberOfConnectivityIds()
    number_of_connectivity_ids = traits.Property(_get_number_of_connectivity_ids, desc=\
        """
        Get the size of the connectivity array that stores the point ids.
        
        ote Do not confuse this with the deprecated
        get_number_of_connectivity_entries(), which refers to the legacy
        memory layout.
        """
    )

    def _get_number_of_offsets(self):
        return self._vtk_obj.GetNumberOfOffsets()
    number_of_offsets = traits.Property(_get_number_of_offsets, desc=\
        """
        Get the number of elements in the offsets array. This will be the
        number of cells + 1.
        """
    )

    def _get_offsets_array(self):
        return wrap_vtk(self._vtk_obj.GetOffsetsArray())
    offsets_array = traits.Property(_get_offsets_array, desc=\
        """
        
        """
    )

    def _get_offsets_array32(self):
        return wrap_vtk(self._vtk_obj.GetOffsetsArray32())
    offsets_array32 = traits.Property(_get_offsets_array32, desc=\
        """
        
        """
    )

    def _get_offsets_array64(self):
        return wrap_vtk(self._vtk_obj.GetOffsetsArray64())
    offsets_array64 = traits.Property(_get_offsets_array64, desc=\
        """
        
        """
    )

    def _get_size(self):
        return self._vtk_obj.GetSize()
    size = traits.Property(_get_size, desc=\
        """
        Get the size of the allocated connectivity array.
        
        @warning This returns the allocated capacity of the internal
            arrays as a
        number of elements, NOT the number of elements in use.
        
        ote Method incompatible with current internal storage.
        """
    )

    def allocate(self, *args):
        """
        V.allocate(int, int) -> int
        C++: TypeBool Allocate(IdType sz, IdType ext=1000)
        Allocate memory.
        
        This currently allocates both the offsets and connectivity arrays
        to sz.
        
        ote It is preferrable to use allocate_estimate(num_cells,
        max_cell_size) or allocate_exact(num_cells, connectivity_size)
        instead.
        """
        ret = self._wrap_call(self._vtk_obj.Allocate, *args)
        return ret

    def allocate_copy(self, *args):
        """
        V.allocate_copy(CellArray) -> bool
        C++: bool AllocateCopy(CellArray *other)
        Pre-allocate memory in internal data structures to match the used
        size of the input CellArray. Does not change the number of
        cells, only the array capacities. Existing data is NOT preserved.
        @param other The CellArray to use as a reference.
        @return True if allocation succeeds.
        @sa Squeeze allocate_estimate allocate_exact
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.AllocateCopy, *my_args)
        return ret

    def allocate_estimate(self, *args):
        """
        V.allocate_estimate(int, int) -> bool
        C++: bool AllocateEstimate(IdType numCells,
            IdType maxCellSize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param num_cells The number of expected cells in the dataset.
        @param max_cell_size The number of points per cell to allocate
            memory for.
        @return True if allocation succeeds.
        @sa Squeeze allocate_exact allocate_copy
        """
        ret = self._wrap_call(self._vtk_obj.AllocateEstimate, *args)
        return ret

    def allocate_exact(self, *args):
        """
        V.allocate_exact(int, int) -> bool
        C++: bool AllocateExact(IdType numCells,
            IdType connectivitySize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param num_cells The number of expected cells in the dataset.
        @param connectivity_size The total number of point_ids stored for
            all cells.
        @return True if allocation succeeds.
        @sa Squeeze allocate_estimate allocate_copy
        """
        ret = self._wrap_call(self._vtk_obj.AllocateExact, *args)
        return ret

    def append(self, *args):
        """
        V.append(CellArray, int)
        C++: void Append(CellArray *src, IdType pointOffset=0)
        Append cells from src into this. Point ids are offset by
        point_offset.
        """
        my_args = deref_array(args, [('vtkCellArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.Append, *my_args)
        return ret

    def append_legacy_format(self, *args):
        """
        V.append_legacy_format(IdTypeArray, int)
        C++: void AppendLegacyFormat(IdTypeArray *data,
            IdType ptOffset=0)
        V.append_legacy_format((int, ...), int, int)
        C++: void AppendLegacyFormat(const IdType *data, IdType len,
             IdType ptOffset=0)"""
        my_args = deref_array(args, [('vtkIdTypeArray', 'int'), (('int', Ellipsis), 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.AppendLegacyFormat, *my_args)
        return ret

    def can_convert_to32_bit_storage(self):
        """
        V.can_convert_to32_bit_storage() -> bool
        C++: bool CanConvertTo32BitStorage()"""
        ret = self._vtk_obj.CanConvertTo32BitStorage()
        return ret
        

    def can_convert_to64_bit_storage(self):
        """
        V.can_convert_to64_bit_storage() -> bool
        C++: bool CanConvertTo64BitStorage()"""
        ret = self._vtk_obj.CanConvertTo64BitStorage()
        return ret
        

    def can_convert_to_default_storage(self):
        """
        V.can_convert_to_default_storage() -> bool
        C++: bool CanConvertToDefaultStorage()"""
        ret = self._vtk_obj.CanConvertToDefaultStorage()
        return ret
        

    def convert_to32_bit_storage(self):
        """
        V.convert_to32_bit_storage() -> bool
        C++: bool ConvertTo32BitStorage()"""
        ret = self._vtk_obj.ConvertTo32BitStorage()
        return ret
        

    def convert_to64_bit_storage(self):
        """
        V.convert_to64_bit_storage() -> bool
        C++: bool ConvertTo64BitStorage()"""
        ret = self._vtk_obj.ConvertTo64BitStorage()
        return ret
        

    def convert_to_default_storage(self):
        """
        V.convert_to_default_storage() -> bool
        C++: bool ConvertToDefaultStorage()"""
        ret = self._vtk_obj.ConvertToDefaultStorage()
        return ret
        

    def convert_to_smallest_storage(self):
        """
        V.convert_to_smallest_storage() -> bool
        C++: bool ConvertToSmallestStorage()"""
        ret = self._vtk_obj.ConvertToSmallestStorage()
        return ret
        

    def deep_copy(self, *args):
        """
        V.deep_copy(CellArray)
        C++: void DeepCopy(CellArray *ca)
        Perform a deep copy (no reference counting) of the given cell
        array.
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def estimate_size(self, *args):
        """
        V.estimate_size(int, int) -> int
        C++: IdType EstimateSize(IdType numCells, int maxPtsPerCell)
        Utility routines help manage memory of cell array. estimate_size()
        returns a value used to initialize and allocate memory for array
        based on number of cells and maximum number of points making up
        cell.  If every cell is the same size (in terms of number of
        points), then the memory estimate is guaranteed exact. (If not
        exact, use Squeeze() to reclaim any extra memory.)
        
        ote This method was often misused (e.g. called alone and then
        discarding the result). Use allocate_estimate directly instead.
        """
        ret = self._wrap_call(self._vtk_obj.EstimateSize, *args)
        return ret

    def export_legacy_format(self, *args):
        """
        V.export_legacy_format(IdTypeArray)
        C++: void ExportLegacyFormat(IdTypeArray *data)
        Fill data with the old-style CellArray data layout, e.g.
        
        ``` { n0, p0_0, p0_1, ..., p0_n, n1, p1_0, p1_1, ..., p1_n, ... }
        ```
        
        where `n0` is the number of points in cell 0, and `p_x__y` is the
        Y'th point in cell X.
        """
        my_args = deref_array(args, [['vtkIdTypeArray']])
        ret = self._wrap_call(self._vtk_obj.ExportLegacyFormat, *my_args)
        return ret

    def import_legacy_format(self, *args):
        """
        V.import_legacy_format(IdTypeArray)
        C++: void ImportLegacyFormat(IdTypeArray *data)
        V.import_legacy_format((int, ...), int)
        C++: void ImportLegacyFormat(const IdType *data, IdType len)"""
        my_args = deref_array(args, [['vtkIdTypeArray'], (('int', Ellipsis), 'int')])
        ret = self._wrap_call(self._vtk_obj.ImportLegacyFormat, *my_args)
        return ret

    def init_traversal(self):
        """
        V.init_traversal()
        C++: void InitTraversal()
        @warning This method is not thread-safe. Consider using the
            new_iterator()
        iterator instead.
        
        init_traversal() initializes the traversal of the list of cells.
        
        ote This method is not thread-safe and has tricky syntax to use
        correctly. Prefer the use of CellArrayIterator (see
        new_iterator()).
        """
        ret = self._vtk_obj.InitTraversal()
        return ret
        

    def initialize(self):
        """
        V.initialize()
        C++: void Initialize()
        Free any memory and reset to an empty state.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def insert_cell_point(self, *args):
        """
        V.insert_cell_point(int)
        C++: void InsertCellPoint(IdType id)
        Used in conjunction with insert_next_cell(npts) to add another
        point to the list of cells.
        """
        ret = self._wrap_call(self._vtk_obj.InsertCellPoint, *args)
        return ret

    def insert_next_cell(self, *args):
        """
        V.insert_next_cell(Cell) -> int
        C++: IdType InsertNextCell(Cell *cell)
        V.insert_next_cell(int, (int, ...)) -> int
        C++: IdType InsertNextCell(IdType npts,
            const IdType *pts)
        V.insert_next_cell(IdList) -> int
        C++: IdType InsertNextCell(IdList *pts)
        V.insert_next_cell(int) -> int
        C++: IdType InsertNextCell(int npts)
        Insert a cell object. Return the cell id of the cell.
        """
        my_args = deref_array(args, [['vtkCell'], ('int', ('int', Ellipsis)), ['vtkIdList'], ['int']])
        ret = self._wrap_call(self._vtk_obj.InsertNextCell, *my_args)
        self.update_traits()
        return ret

    def is_homogeneous(self):
        """
        V.is_homogeneous() -> int
        C++: IdType IsHomogeneous()
        Check if all cells have the same number of vertices.
        
        The return value is coded as:
        * -1 = heterogeneous
        * 0 = Cell array empty
        * n (positive integer) = homogeneous array of cell size n
        """
        ret = self._vtk_obj.IsHomogeneous()
        return ret
        

    def is_storage64_bit(self):
        """
        V.is_storage64_bit() -> bool
        C++: bool IsStorage64Bit()
        @return True if the internal storage is using 64 bit arrays. If
            false,
        the storage is using 32 bit arrays.
        """
        ret = self._vtk_obj.IsStorage64Bit()
        return ret
        

    def is_storage_shareable(self):
        """
        V.is_storage_shareable() -> bool
        C++: bool IsStorageShareable()
        @return True if the internal storage can be shared as a
        pointer to IdType, i.e., the type and organization of internal
        storage is such that copying of data can be avoided, and instead
        a pointer to IdType can be used.
        """
        ret = self._vtk_obj.IsStorageShareable()
        return ret
        

    def is_valid(self):
        """
        V.is_valid() -> bool
        C++: bool IsValid()
        Check that internal storage is consistent and in a valid state.
        
        Specifically, this function returns true if and only if:
        - The offset and connectivity arrays have exactly one component.
        - The offset array has at least one value and starts at 0.
        - The offset array values never decrease.
        - The connectivity array has as many entries as the last value in
        the offset array.
        """
        ret = self._vtk_obj.IsValid()
        return ret
        

    def new_iterator(self):
        """
        V.new_iterator() -> CellArrayIterator
        C++: CellArrayIterator *NewIterator()
        new_iterator returns a new instance of CellArrayIterator that
        is initialized to point at the first cell's data. The caller is
        responsible for Delete()'ing the object.
        """
        ret = wrap_vtk(self._vtk_obj.NewIterator())
        return ret
        

    def replace_cell(self, *args):
        """
        V.replace_cell(int, int, (int, ...))
        C++: void ReplaceCell(IdType loc, int npts,
            const IdType pts[])
        Replace the point ids of the cell at the legacy location with a
        different list of point ids. Calling this method does not mark
        the CellArray as modified. This is the responsibility of the
        caller and may be done after multiple calls to replace_cell. This
        call does not support changing the number of points in the cell
        -- the caller must ensure that the target cell has npts points.
        
        ote The location-based API is now a super-slow compatibility
        layer. Prefer replace_cell_at_id.
        """
        ret = self._wrap_call(self._vtk_obj.ReplaceCell, *args)
        return ret

    def replace_cell_at_id(self, *args):
        """
        V.replace_cell_at_id(int, IdList)
        C++: void ReplaceCellAtId(IdType cellId, IdList *list)
        V.replace_cell_at_id(int, int, (int, ...))
        C++: void ReplaceCellAtId(IdType cellId, IdType cellSize,
            const IdType *cellPoints)"""
        my_args = deref_array(args, [('int', 'vtkIdList'), ('int', 'int', ('int', Ellipsis))])
        ret = self._wrap_call(self._vtk_obj.ReplaceCellAtId, *my_args)
        return ret

    def reset(self):
        """
        V.reset()
        C++: void Reset()
        Reuse list. Reset to initial state without freeing memory.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def resize_exact(self, *args):
        """
        V.resize_exact(int, int) -> bool
        C++: bool ResizeExact(IdType numCells,
            IdType connectivitySize)
        resize_exact() resizes the internal structures to hold num_cells
        total cell offsets and connectivity_size total point_ids. Old data
        is preserved, and newly-available memory is not initialized.
        
        @warning For advanced use only. You probably want an Allocate
            method.
        
        @return True if allocation succeeds.
        """
        ret = self._wrap_call(self._vtk_obj.ResizeExact, *args)
        return ret

    def reverse_cell(self, *args):
        """
        V.reverse_cell(int)
        C++: void ReverseCell(IdType loc)
        Special method inverts ordering of cell at the specified legacy
        location. Must be called carefully or the cell topology may be
        corrupted.
        
        ote The location-based API is now a super-slow compatibility
        layer. Prefer reverse_cell_at_id;
        """
        ret = self._wrap_call(self._vtk_obj.ReverseCell, *args)
        return ret

    def reverse_cell_at_id(self, *args):
        """
        V.reverse_cell_at_id(int)
        C++: void ReverseCellAtId(IdType cellId)
        Reverses the order of the point ids for the specified cell.
        """
        ret = self._wrap_call(self._vtk_obj.ReverseCellAtId, *args)
        return ret

    def set_cells(self, *args):
        """
        V.set_cells(int, IdTypeArray)
        C++: void SetCells(IdType ncells, IdTypeArray *cells)
        Define multiple cells by providing a connectivity list. The list
        is in the form (npts,p0,p1,...p(npts-1), repeated for each cell).
        Be careful using this method because it discards the old cells,
        and anything referring these cells becomes invalid (for example,
        if build_cells() has been called see PolyData).  The traversal
        location is reset to the beginning of the list; the insertion
        location is set to the end of the list.
        
        @warning The CellArray will not hold a reference to `cells`.
            This
        function merely calls import_legacy_format.
        
        ote Use import_legacy_format or set_data instead.
        """
        my_args = deref_array(args, [('int', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.SetCells, *my_args)
        return ret

    def shallow_copy(self, *args):
        """
        V.shallow_copy(CellArray)
        C++: void ShallowCopy(CellArray *ca)
        Shallow copy ca into this cell array.
        """
        my_args = deref_array(args, [['vtkCellArray']])
        ret = self._wrap_call(self._vtk_obj.ShallowCopy, *my_args)
        return ret

    def squeeze(self):
        """
        V.squeeze()
        C++: void Squeeze()
        Reclaim any extra memory while preserving data.
        
        @sa convert_to_smallest_storage
        """
        ret = self._vtk_obj.Squeeze()
        return ret
        

    def update_cell_count(self, *args):
        """
        V.update_cell_count(int)
        C++: void UpdateCellCount(int npts)
        Used in conjunction with insert_next_cell(int npts) and
        insert_cell_point() to update the number of points defining the
        cell.
        """
        ret = self._wrap_call(self._vtk_obj.UpdateCellCount, *args)
        return ret

    def use32_bit_storage(self):
        """
        V.use32_bit_storage()
        C++: void Use32BitStorage()"""
        ret = self._vtk_obj.Use32BitStorage()
        return ret
        

    def use64_bit_storage(self):
        """
        V.use64_bit_storage()
        C++: void Use64BitStorage()"""
        ret = self._vtk_obj.Use64BitStorage()
        return ret
        

    def use_default_storage(self):
        """
        V.use_default_storage()
        C++: void UseDefaultStorage()"""
        ret = self._vtk_obj.UseDefaultStorage()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_cells', 'GetNumberOfCells'),
    ('traversal_cell_id', 'GetTraversalCellId'), ('traversal_location',
    'GetTraversalLocation'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_cells',
    'traversal_cell_id', 'traversal_location'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_cells', 'traversal_cell_id',
            'traversal_location']),
            title='Edit CellArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def from_array(self, arr):
        '''Set the value of the data array using the passed
        Numeric array or Python list.  This is implemented
        efficiently.
        '''
        array_handler.array2vtkCellArray(arr, self._vtk_obj)
        self.update_traits()
    
    def to_array(self):
        '''Return the object as a Numeric array.'''
        return array_handler.vtk2array(self._vtk_obj.GetData())

