# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class PassSelectedArrays(PassInputTypeAlgorithm):
    """
    PassSelectedArrays - pass through chosen arrays
    
    Superclass: PassInputTypeAlgorithm
    
    PassSelectedArrays can be used to pass through chosen arrays. It
    is intended as a replacement for PassArrays filter with a more
    standard API that uses `vtk_data_array_selection` to choose arrays to
    pass through.
    
    To enable/disable arrays to pass, get the appropriate
    `vtk_data_array_selection` instance using `_get_array_selection` or the
    association specific get methods such as
    `_get_point_data_array_selection`, `_get_cell_data_array_selection` etc. and
    then enable/disable arrays using `vtk_data_array_selection` API. Using
    DataArraySelection::SetUnknownArraySetting` one also dictate how
    arrays not explicitly listed are to be handled.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPassSelectedArrays, obj, update, **traits)
    
    enabled = tvtk_base.true_bool_trait(desc=\
        """
        Enable/disable this filter. When disabled, this filter passes all
        input arrays irrespective of the array selections. Default is
        `true`.
        """
    )

    def _enabled_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnabled,
                        self.enabled_)

    def get_array_selection(self, *args):
        """
        V.get_array_selection(int) -> DataArraySelection
        C++: DataArraySelection *GetArraySelection(int association)
        Returns the DataArraySelection instance associated with a
        particular array association type
        (vtk_data_object::_field_associations). Returns nullptr if the
        association type is invalid others the corresponding
        DataArraySelection instance is returned.
        """
        ret = self._wrap_call(self._vtk_obj.GetArraySelection, *args)
        return wrap_vtk(ret)

    def _get_cell_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetCellDataArraySelection())
    cell_data_array_selection = traits.Property(_get_cell_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    def _get_edge_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetEdgeDataArraySelection())
    edge_data_array_selection = traits.Property(_get_edge_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    def _get_field_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetFieldDataArraySelection())
    field_data_array_selection = traits.Property(_get_field_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_point_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetPointDataArraySelection())
    point_data_array_selection = traits.Property(_get_point_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    def _get_row_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetRowDataArraySelection())
    row_data_array_selection = traits.Property(_get_row_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    def _get_vertex_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetVertexDataArraySelection())
    vertex_data_array_selection = traits.Property(_get_vertex_data_array_selection, desc=\
        """
        Convenience methods that call `_get_array_selection` with
        corresponding association type.
        """
    )

    _updateable_traits_ = \
    (('enabled', 'GetEnabled'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'enabled', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PassSelectedArrays, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PassSelectedArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled'], [], []),
            title='Edit PassSelectedArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PassSelectedArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

