# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLState(Object):
    """
    OpenGLState - open_gl state storage
    
    Superclass: Object
    
    OpenGLState is a class designed to keep track of the state of an
    open_gl context. Applications using VTK have so much control over the
    rendering process that is can be difficult in VTK code to know if the
    open_gl state is correct for your code. The two traditional solutions
    have been to set everything yourself and to save and restore open_gl
    state that you change. The former makes your code work, the latter
    helps prevent your code from breaking something else. The problem is
    that the former results in tons of redundant open_gl calls and the
    later is done by querying the open_gl state which can cause a pipeline
    sync/stall which is very slow.
    
    To address these issues this class stores open_gl state for commonly
    used functions. Requests made to change state to the current state
    become no-ops. Queries of state can be done by querying the state
    stored in this class without impacting the open_gl driver.
    
    This class is designed to hold all context related values and could
    just as well be considered a representation of the open_gl context.
    
    To facilitate saving state and restoring it this class contains a
    number of nested classes named Scopedthat store the state of that
    gl_function and when they go out of scope they restore it. This is
    useful when you want to change the open_gl state and then
    automatically restore it when done. They can be used as follows
    
    {
      OpenGLState *ostate = ren_win->_get_state();
      OpenGLState::ScopedglDepthMask dmsaved(ostate);
      // the prior state is now saved
      ...
      ostate->gl_depth_mask(_gl__true);  // maybe change the state
      ... etc } // prior state will be restored here as it goes out of
    scope
    
    You must use this class to make state changing open_gl class otherwise
    the results will be undefined.
    
    For convenience some open_gl calls that do not impact state are also
    provided.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLState, obj, update, **traits)
    
    def get_enum_state(self, *args):
        """
        V.get_enum_state(int) -> bool
        C++: bool GetEnumState(unsigned int name)"""
        ret = self._wrap_call(self._vtk_obj.GetEnumState, *args)
        return ret

    def set_enum_state(self, *args):
        """
        V.set_enum_state(int, bool)
        C++: void SetEnumState(unsigned int name, bool value)"""
        ret = self._wrap_call(self._vtk_obj.SetEnumState, *args)
        return ret

    def _get_texture_unit_manager(self):
        return wrap_vtk(self._vtk_obj.GetTextureUnitManager())
    def _set_texture_unit_manager(self, arg):
        old_val = self._get_texture_unit_manager()
        self._wrap_call(self._vtk_obj.SetTextureUnitManager,
                        deref_vtk(arg))
        self.trait_property_changed('texture_unit_manager', old_val, arg)
    texture_unit_manager = traits.Property(_get_texture_unit_manager, _set_texture_unit_manager, desc=\
        """
        Returns its texture unit manager object. A new one will be
        created if one hasn't already been set up.
        """
    )

    def _get_vbo_cache(self):
        return wrap_vtk(self._vtk_obj.GetVBOCache())
    def _set_vbo_cache(self, arg):
        old_val = self._get_vbo_cache()
        self._wrap_call(self._vtk_obj.SetVBOCache,
                        deref_vtk(arg))
        self.trait_property_changed('vbo_cache', old_val, arg)
    vbo_cache = traits.Property(_get_vbo_cache, _set_vbo_cache, desc=\
        """
        
        """
    )

    def get_blend_func_state(self, *args):
        """
        V.get_blend_func_state([int, ...])
        C++: void GetBlendFuncState(int *)"""
        ret = self._wrap_call(self._vtk_obj.GetBlendFuncState, *args)
        return ret

    def get_default_texture_internal_format(self, *args):
        """
        V.get_default_texture_internal_format(int, int, bool, bool, bool)
            -> int
        C++: int GetDefaultTextureInternalFormat(int vtktype,
            int numComponents, bool needInteger, bool needFloat,
            bool needSRGB)
        Get a mapping of vtk data types to native texture formats for
        this window we put this on the render_window so that every texture
        does not have to build these structures themselves
        """
        ret = self._wrap_call(self._vtk_obj.GetDefaultTextureInternalFormat, *args)
        return ret

    def _get_shader_cache(self):
        return wrap_vtk(self._vtk_obj.GetShaderCache())
    shader_cache = traits.Property(_get_shader_cache, desc=\
        """
        
        """
    )

    def get_texture_unit_for_texture(self, *args):
        """
        V.get_texture_unit_for_texture(TextureObject) -> int
        C++: int GetTextureUnitForTexture(TextureObject *)
        Get the texture unit for a given texture object
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTextureUnitForTexture, *my_args)
        return ret

    def activate_texture(self, *args):
        """
        V.activate_texture(TextureObject)
        C++: void ActivateTexture(TextureObject *)
        Activate a texture unit for this texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ActivateTexture, *my_args)
        return ret

    def deactivate_texture(self, *args):
        """
        V.deactivate_texture(TextureObject)
        C++: void DeactivateTexture(TextureObject *)
        Deactivate a previously activated texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeactivateTexture, *my_args)
        return ret

    def initialize(self, *args):
        """
        V.initialize(OpenGLRenderWindow)
        C++: void Initialize(OpenGLRenderWindow *)
        Initialize open_gl context using current state
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def pop_draw_framebuffer_binding(self):
        """
        V.pop_draw_framebuffer_binding()
        C++: void PopDrawFramebufferBinding()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PopDrawFramebufferBinding()
        return ret
        

    def pop_framebuffer_bindings(self):
        """
        V.pop_framebuffer_bindings()
        C++: void PopFramebufferBindings()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PopFramebufferBindings()
        return ret
        

    def pop_read_framebuffer_binding(self):
        """
        V.pop_read_framebuffer_binding()
        C++: void PopReadFramebufferBinding()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PopReadFramebufferBinding()
        return ret
        

    def push_draw_framebuffer_binding(self):
        """
        V.push_draw_framebuffer_binding()
        C++: void PushDrawFramebufferBinding()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PushDrawFramebufferBinding()
        return ret
        

    def push_framebuffer_bindings(self):
        """
        V.push_framebuffer_bindings()
        C++: void PushFramebufferBindings()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PushFramebufferBindings()
        return ret
        

    def push_read_framebuffer_binding(self):
        """
        V.push_read_framebuffer_binding()
        C++: void PushReadFramebufferBinding()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.PushReadFramebufferBinding()
        return ret
        

    def reset_enum_state(self, *args):
        """
        V.reset_enum_state(int)
        C++: void ResetEnumState(unsigned int name)
        convenience method to reset an enum state from current open_gl
        context
        """
        ret = self._wrap_call(self._vtk_obj.ResetEnumState, *args)
        return ret

    def reset_framebuffer_bindings(self):
        """
        V.reset_framebuffer_bindings()
        C++: void ResetFramebufferBindings()
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._vtk_obj.ResetFramebufferBindings()
        return ret
        

    def reset_gl_active_texture(self):
        """
        V.reset_gl_active_texture()
        C++: void ResetGLActiveTexture()"""
        ret = self._vtk_obj.ResetGLActiveTexture()
        return ret
        

    def reset_gl_blend_equation_state(self):
        """
        V.reset_gl_blend_equation_state()
        C++: void ResetGLBlendEquationState()"""
        ret = self._vtk_obj.ResetGLBlendEquationState()
        return ret
        

    def reset_gl_blend_func_state(self):
        """
        V.reset_gl_blend_func_state()
        C++: void ResetGLBlendFuncState()"""
        ret = self._vtk_obj.ResetGLBlendFuncState()
        return ret
        

    def reset_gl_clear_color_state(self):
        """
        V.reset_gl_clear_color_state()
        C++: void ResetGLClearColorState()"""
        ret = self._vtk_obj.ResetGLClearColorState()
        return ret
        

    def reset_gl_clear_depth_state(self):
        """
        V.reset_gl_clear_depth_state()
        C++: void ResetGLClearDepthState()"""
        ret = self._vtk_obj.ResetGLClearDepthState()
        return ret
        

    def reset_gl_color_mask_state(self):
        """
        V.reset_gl_color_mask_state()
        C++: void ResetGLColorMaskState()"""
        ret = self._vtk_obj.ResetGLColorMaskState()
        return ret
        

    def reset_gl_cull_face_state(self):
        """
        V.reset_gl_cull_face_state()
        C++: void ResetGLCullFaceState()"""
        ret = self._vtk_obj.ResetGLCullFaceState()
        return ret
        

    def reset_gl_depth_func_state(self):
        """
        V.reset_gl_depth_func_state()
        C++: void ResetGLDepthFuncState()"""
        ret = self._vtk_obj.ResetGLDepthFuncState()
        return ret
        

    def reset_gl_depth_mask_state(self):
        """
        V.reset_gl_depth_mask_state()
        C++: void ResetGLDepthMaskState()"""
        ret = self._vtk_obj.ResetGLDepthMaskState()
        return ret
        

    def reset_gl_scissor_state(self):
        """
        V.reset_gl_scissor_state()
        C++: void ResetGLScissorState()"""
        ret = self._vtk_obj.ResetGLScissorState()
        return ret
        

    def reset_gl_viewport_state(self):
        """
        V.reset_gl_viewport_state()
        C++: void ResetGLViewportState()"""
        ret = self._vtk_obj.ResetGLViewportState()
        return ret
        

    def verify_no_active_textures(self):
        """
        V.verify_no_active_textures()
        C++: void VerifyNoActiveTextures()
        Check to make sure no textures have been left active
        """
        ret = self._vtk_obj.VerifyNoActiveTextures()
        return ret
        

    def vtk_bind_framebuffer(self, *args):
        """
        V.BindFramebuffer(int, OpenGLFramebufferObject)
        C++: void BindFramebuffer(unsigned int target,
            OpenGLFramebufferObject *fo)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkBindFramebuffer, *my_args)
        return ret

    def vtk_draw_buffers(self, *args):
        """
        V.DrawBuffers(int, [int, ...], OpenGLFramebufferObject)
        C++: void DrawBuffers(unsigned int n, unsigned int *,
            OpenGLFramebufferObject *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkDrawBuffers, *my_args)
        return ret

    def vtk_read_buffer(self, *args):
        """
        V.ReadBuffer(int, OpenGLFramebufferObject)
        C++: void ReadBuffer(unsigned int,
            OpenGLFramebufferObject *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.vtkReadBuffer, *my_args)
        return ret

    def vtkgl_active_texture(self, *args):
        """
        V.vtkgl_active_texture(int)
        C++: void vtkglActiveTexture(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglActiveTexture, *args)
        return ret

    def vtkgl_bind_framebuffer(self, *args):
        """
        V.vtkgl_bind_framebuffer(int, int)
        C++: void vtkglBindFramebuffer(unsigned int target,
            unsigned int fb)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBindFramebuffer, *args)
        return ret

    def vtkgl_blend_equation(self, *args):
        """
        V.vtkgl_blend_equation(int)
        C++: void vtkglBlendEquation(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendEquation, *args)
        return ret

    def vtkgl_blend_equation_separate(self, *args):
        """
        V.vtkgl_blend_equation_separate(int, int)
        C++: void vtkglBlendEquationSeparate(unsigned int col,
            unsigned int alpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendEquationSeparate, *args)
        return ret

    def vtkgl_blend_func(self, *args):
        """
        V.vtkgl_blend_func(int, int)
        C++: void vtkglBlendFunc(unsigned int sfactor,
            unsigned int dfactor)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendFunc, *args)
        return ret

    def vtkgl_blend_func_separate(self, *args):
        """
        V.vtkgl_blend_func_separate(int, int, int, int)
        C++: void vtkglBlendFuncSeparate(unsigned int sfactorRGB,
            unsigned int dfactorRGB, unsigned int sfactorAlpha,
            unsigned int dfactorAlpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglBlendFuncSeparate, *args)
        return ret

    def vtkgl_clear(self, *args):
        """
        V.vtkgl_clear(int)
        C++: void vtkglClear(unsigned int mask)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClear, *args)
        return ret

    def vtkgl_clear_color(self, *args):
        """
        V.vtkgl_clear_color(float, float, float, float)
        C++: void vtkglClearColor(float red, float green, float blue,
            float alpha)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClearColor, *args)
        return ret

    def vtkgl_clear_depth(self, *args):
        """
        V.vtkgl_clear_depth(float)
        C++: void vtkglClearDepth(double depth)"""
        ret = self._wrap_call(self._vtk_obj.vtkglClearDepth, *args)
        return ret

    def vtkgl_color_mask(self, *args):
        """
        V.vtkgl_color_mask(int, int, int, int)
        C++: void vtkglColorMask(unsigned char r, unsigned char g,
            unsigned char b, unsigned char a)"""
        ret = self._wrap_call(self._vtk_obj.vtkglColorMask, *args)
        return ret

    def vtkgl_cull_face(self, *args):
        """
        V.vtkgl_cull_face(int)
        C++: void vtkglCullFace(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglCullFace, *args)
        return ret

    def vtkgl_depth_func(self, *args):
        """
        V.vtkgl_depth_func(int)
        C++: void vtkglDepthFunc(unsigned int val)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDepthFunc, *args)
        return ret

    def vtkgl_depth_mask(self, *args):
        """
        V.vtkgl_depth_mask(int)
        C++: void vtkglDepthMask(unsigned char flag)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDepthMask, *args)
        return ret

    def vtkgl_disable(self, *args):
        """
        V.vtkgl_disable(int)
        C++: void vtkglDisable(unsigned int cap)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDisable, *args)
        return ret

    def vtkgl_draw_buffer(self, *args):
        """
        V.vtkgl_draw_buffer(int)
        C++: void vtkglDrawBuffer(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDrawBuffer, *args)
        return ret

    def vtkgl_draw_buffers(self, *args):
        """
        V.vtkgl_draw_buffers(int, [int, ...])
        C++: void vtkglDrawBuffers(unsigned int n, unsigned int *)"""
        ret = self._wrap_call(self._vtk_obj.vtkglDrawBuffers, *args)
        return ret

    def vtkgl_enable(self, *args):
        """
        V.vtkgl_enable(int)
        C++: void vtkglEnable(unsigned int cap)"""
        ret = self._wrap_call(self._vtk_obj.vtkglEnable, *args)
        return ret

    def vtkgl_get_booleanv(self, *args):
        """
        V.vtkgl_get_booleanv(int, [int, ...])
        C++: void vtkglGetBooleanv(unsigned int pname,
            unsigned char *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetBooleanv, *args)
        return ret

    def vtkgl_get_doublev(self, *args):
        """
        V.vtkgl_get_doublev(int, [float, ...])
        C++: void vtkglGetDoublev(unsigned int pname, double *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetDoublev, *args)
        return ret

    def vtkgl_get_floatv(self, *args):
        """
        V.vtkgl_get_floatv(int, [float, ...])
        C++: void vtkglGetFloatv(unsigned int pname, float *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetFloatv, *args)
        return ret

    def vtkgl_get_integerv(self, *args):
        """
        V.vtkgl_get_integerv(int, [int, ...])
        C++: void vtkglGetIntegerv(unsigned int pname, int *params)"""
        ret = self._wrap_call(self._vtk_obj.vtkglGetIntegerv, *args)
        return ret

    def vtkgl_read_buffer(self, *args):
        """
        V.vtkgl_read_buffer(int)
        C++: void vtkglReadBuffer(unsigned int)"""
        ret = self._wrap_call(self._vtk_obj.vtkglReadBuffer, *args)
        return ret

    def vtkgl_scissor(self, *args):
        """
        V.vtkgl_scissor(int, int, int, int)
        C++: void vtkglScissor(int x, int y, int width, int height)"""
        ret = self._wrap_call(self._vtk_obj.vtkglScissor, *args)
        return ret

    def vtkgl_viewport(self, *args):
        """
        V.vtkgl_viewport(int, int, int, int)
        C++: void vtkglViewport(int x, int y, int width, int height)"""
        ret = self._wrap_call(self._vtk_obj.vtkglViewport, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLState, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLState properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

