# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class HyperTree(Object):
    """
    HyperTree - A data object structured as a tree.
    
    Superclass: Object
    
    An hypertree grid is a dataobject containing a rectilinear grid of
    elements that can be either null or a hypertree. An hypertree is a
    dataobject describing a decomposition tree. A VERTICE is an element
    of this tree. A NODE, also called COARSE cell, is a specific vertice
    which is refined and than has either exactly f^d children, where f in
    {2,3} is the branching factor, the same value for all trees in this
    hypertree grid, and d in {1,2,3} is the spatial dimension. It is
    called coarse because there are smaller child cells. A LEAF, also
    called FINE cell, is a vertice without children, not refined. It is
    called fine because in the same space there are no finer cells. In a
    tree, we can find coarse cells smaller than fine cell but not in the
    same space.
    
    Such trees have particular names for f=2:
    - bintree (d=1),
    - quadtree (d=2),
    - octree (d=3).
    
    The original octree class name came from the following paper:
     @ARTICLE{yau-srihari-1983,
      author={Mann-May Yau and Sargur N. Srihari},
      title={A Hierarchical Data Structure for Multidimensional Digital Images},
      journal={Communications of the ACM},
      month={July},
      year={1983},
      volume={26},
      number={7},
      pages={504--515}
      }
     
    
    Attributes are associated with (all) cells, not with points. The
    attributes that are associated with coarses, it's used for lo_d
    (Level-of-Detail). The attributes on coarse cells can be given by the
    code or/and computed by the use of a specifc filter exploiting the
    values from its children (which can be leaves or not).
    
    The geometry is implicitly given by the size of the root node on each
    axis and position of the origin. In fact, in 3d, the geometry is then
    not limited to a cube but can have a rectangular shape.
    
    By construction, an hypertree is efficient in memory usage. The lo_d
    feature allows for quick culling of part of the dataobject.
    
    This is an abstract class used as a superclass by a custom templated
    compact class. Other versions of this code could be made available to
    meet other needs without questioning cursors and filters. All methods
    are pure virtual. This is done to hide templates.
    
    @par Case octree with f=2, d=3: For each node (coarse cell), 8
    children are encoded in a child index (from 0 to 7) in the following
    orientation described in hypertree grid. It is easy to access each
    child as a cell of a grid. Note also that the binary representation
    is relevant, each bit codes a side: bit 0 encodes -x side (0) or +x
    side (1) bit 1 encodes -y side (0) or +y side (1) bit 2 encodes -z
    side (0) or +z side (1)
    -z side is first, in counter-clockwise order: 0: -y -x sides 1: -y +x
    sides 2: +y -x sides 3: +y +x sides +z side is last, in
       counter-clockwise order: 4: -y -x sides 5: -y +x sides 6: +y -x
       sides 7: +y +x sides
                  +y
     +-+-+        ^
     |2|3|        |
     +-+-+  O +z  +-> +x
     |0|1|
     +-+-+
                  +y
     +-+-+        ^
     |6|7|        |
     +-+-+  1 +z  +-> +x
     |4|5|
     +-+-+
     
    
    @par Case quadtree with f=2, d=2: Just use 2 bits.
                  +y
     +-+-+        ^
     |2|3|        |
     +-+-+        +-> +x
     |0|1|
     +-+-+
     
    
    @par Case bintree with f=2, d=1: Just use 1 bits.
                 O+-> +x
     
    
    It's more difficult with f=3.
    
    @par Thanks: This class was written by Philippe Pebay, Joachim
    Pouderoux, and Charles Law, Kitware 2013 This class was modified by
    Guenole Harel and Jacques-Bernard Lekien 2014 This class was modified
    by Philippe Pebay, 2016 Among others, this class was simplified,
    optimized (memory), documented and completed for to improve IO XML by
    Jacques-Bernard Lekien 2018-19 This work was supported by
    Commissariat a l'Energie Atomique CEA, DAM, DIF, F-91297 Arpajon,
    France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTree, obj, update, **traits)
    
    def get_global_index_from_local(self, *args):
        """
        V.get_global_index_from_local(int) -> int
        C++: virtual IdType GetGlobalIndexFromLocal(IdType index)
        Get the global id of a local node identified by index. Use the
        explicit mapping function if available or the implicit mapping
        build with start global index.
        \pre not_valid_index
        \pre not_positive_start_index (case implicit global index
            mapping)
        \pre not_positive_global_index (case explicit global index
            mapping)
        """
        ret = self._wrap_call(self._vtk_obj.GetGlobalIndexFromLocal, *args)
        return ret

    def set_global_index_from_local(self, *args):
        """
        V.set_global_index_from_local(int, int)
        C++: virtual void SetGlobalIndexFromLocal(IdType index,
            IdType global)
        Set the mapping between a node index in tree and a explicit
        global index mapping. This global index mapping permits to access
        a value of field for a cell, in explicit, the index depend of
        order values. For this tree, in debug, assert is calling if tried
        call set_global_index_start.
        \pre not_global_index_from_local_if_use_global_index_start
        """
        ret = self._wrap_call(self._vtk_obj.SetGlobalIndexFromLocal, *args)
        return ret

    global_index_start = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the start implicit global index mapping for the first cell in
        the current tree. The implicit global index mapping of a node
        will be computed by this start index + the node index (local
        offset in tree). The node index begin by 0, the origin cell in
        tree. The follow values are organizing by fatrie as i to
        i+_number_of_children, for all children of one coarse cell, i is
        1+8*s with s in integer. The order of fatrie depend of order to
        call subdivide_leaf. This global index mapping permits to access a
        value of field for a cell, in implicit, the order values depends
        of implicit order linking with the order build of this tree.
        WARNING: See of hypertree grid, for to use a implicit global
        index mapping, you have to build hypertree by hypertree without
        to recome in hypertree also build. For this tree, in debug,
        assert is calling if tried call set_global_index_from_local.
        \pre not_global_index_start_if_use_global_index_from_local
        """
    )

    def _global_index_start_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlobalIndexStart,
                        self.global_index_start)

    tree_index = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get tree index in hypertree grid. Services for internal use
        between hypertree grid and hypertree.
        """
    )

    def _tree_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTreeIndex,
                        self.tree_index)

    def _get_actual_memory_size(self):
        return self._vtk_obj.GetActualMemorySize()
    actual_memory_size = traits.Property(_get_actual_memory_size, desc=\
        """
        Return memory used in kibibytes (1024 bytes). NB: Ignore the
        attribute array because its size is added by the data set.
        """
    )

    def _get_actual_memory_size_bytes(self):
        return self._vtk_obj.GetActualMemorySizeBytes()
    actual_memory_size_bytes = traits.Property(_get_actual_memory_size_bytes, desc=\
        """
        Return memory used in bytes. NB: Ignore the attribute array
        because its size is added by the data set.
        """
    )

    def _get_branch_factor(self):
        return self._vtk_obj.GetBranchFactor()
    branch_factor = traits.Property(_get_branch_factor, desc=\
        """
        Return the branch factor of the tree.
        """
    )

    def get_by_level_for_writer(self, *args):
        """
        V.get_by_level_for_writer(BitArray, UnsignedLongArray,
            BitArray, BitArray, IdList)
        C++: virtual void GetByLevelForWriter(BitArray *inIsMasked,
            UnsignedLongArray *nbVerticesbyLevel,
            BitArray *isParent, BitArray *isMasked, IdList *ids)
        Initialize a state from write data. Call after create the
        hypertree grid.
        
        @param in_is_masked: the mask of hypertree grid including
        this hypertree which is a BitArray.
        @param nb_verticesby_level: the number of vertices in tree
        (coarse and leaves) by each level.
        @param is_parent: modify the BitArray, a binary decomposition
        tree by level with constraint all describe children. It is
        useless to declare all the lastest values to False, especially
        the last level may not be defined.
        @param is_masked: modify the BitArray, a binary mask
        corresponding. It is useless to declare all the latest values to
        False.
        """
        my_args = deref_array(args, [('vtkBitArray', 'vtkUnsignedLongArray', 'vtkBitArray', 'vtkBitArray', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetByLevelForWriter, *my_args)
        return ret

    def _get_dimension(self):
        return self._vtk_obj.GetDimension()
    dimension = traits.Property(_get_dimension, desc=\
        """
        Return the spatial dimension of the tree.
        """
    )

    def get_elder_child_index(self, *args):
        """
        V.get_elder_child_index(int) -> int
        C++: virtual IdType GetElderChildIndex(
            unsigned int index_parent)
        Return the elder child index, local index node of first child, of
        node, coarse cell, identified by index_parent.
        \pre not_valid_index_parent
        Public only for entry: HyperTreeGridEntry,
        HyperTreeGridGeometryEntry, HyperTreeGridGeometryLevelEntry
        """
        ret = self._wrap_call(self._vtk_obj.GetElderChildIndex, *args)
        return ret

    def _get_global_node_index_max(self):
        return self._vtk_obj.GetGlobalNodeIndexMax()
    global_node_index_max = traits.Property(_get_global_node_index_max, desc=\
        """
        Return the maximum value reached by global index mapping
        (implicit or explicit).
        """
    )

    def _get_number_of_children(self):
        return self._vtk_obj.GetNumberOfChildren()
    number_of_children = traits.Property(_get_number_of_children, desc=\
        """
        Return the number of children per node of the tree. This value is
        branchfactoring scale spatial dimenion (f^d).
        """
    )

    def _get_number_of_leaves(self):
        return self._vtk_obj.GetNumberOfLeaves()
    number_of_leaves = traits.Property(_get_number_of_leaves, desc=\
        """
        Return the number of leaf (fine) in the tree.
        """
    )

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, desc=\
        """
        Return the number of levels.
        """
    )

    def _get_number_of_nodes(self):
        return self._vtk_obj.GetNumberOfNodes()
    number_of_nodes = traits.Property(_get_number_of_nodes, desc=\
        """
        Return the number of nodes (coarse) in the tree.
        """
    )

    def _get_number_of_vertices(self):
        return self._vtk_obj.GetNumberOfVertices()
    number_of_vertices = traits.Property(_get_number_of_vertices, desc=\
        """
        Return the number of all vertices (coarse and fine) in the tree.
        """
    )

    def get_scale(self, *args):
        """
        V.get_scale([float, float, float])
        C++: void GetScale(double s[3])
        V.get_scale(int) -> float
        C++: double GetScale(unsigned int d)
        Set/Get scale of the tree in each direction for the ground level
        (0).
        """
        ret = self._wrap_call(self._vtk_obj.GetScale, *args)
        return ret

    def copy_structure(self, *args):
        """
        V.copy_structure(HyperTree)
        C++: void CopyStructure(HyperTree *ht)
        Copy the structure by sharing the decomposition description of
        the tree.
        \pre ht_exist: ht!=nullptr
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyStructure, *my_args)
        return ret

    def create_instance(self, *args):
        """
        V.create_instance(int, int) -> HyperTree
        C++: static HyperTree *CreateInstance(
            unsigned char branchFactor, unsigned char dimension)
        Return an instance of an implementation of a hypertree for given
        branch factor and dimension. Other versions of this code could be
        made available to meet other needs without questioning cursors
        and filters. Since an instance, an other instance can be creating
        by call the method Freeze (by default, nothing more, instance
        currently is returning).
        """
        ret = self._wrap_call(self._vtk_obj.CreateInstance, *args)
        return wrap_vtk(ret)

    def freeze(self, *args):
        """
        V.freeze(string) -> HyperTree
        C++: virtual HyperTree *Freeze(const char *mode)
        Return a freeze instance (a priori compact but potentially
        unmodifiable). This method is calling by the Squeeze method of
        hypertree grid. The mode parameter will allow to propose
        different instances. Today, there is none, the freeze call does
        not do anything.
        """
        ret = self._wrap_call(self._vtk_obj.Freeze, *args)
        return wrap_vtk(ret)

    def has_scales(self):
        """
        V.has_scales() -> bool
        C++: bool HasScales()
        Return the existence scales.
        """
        ret = self._vtk_obj.HasScales()
        return ret
        

    def initialize(self, *args):
        """
        V.initialize(int, int, int)
        C++: void Initialize(unsigned char, unsigned char, unsigned char)
        Restore the initial state: only one vertice is then a leaf: the
        root cell for the hypertree.
        @param branch_factor
        @param dimension
        @param number_of_children
        """
        ret = self._wrap_call(self._vtk_obj.Initialize, *args)
        return ret

    def initialize_for_reader(self, *args):
        """
        V.initialize_for_reader(int, int, int, BitArray, BitArray,
            BitArray)
        C++: virtual void InitializeForReader(IdType numberOfLevels,
            IdType nbVertices, IdType nbVerticesOfLastLevel,
            BitArray *isParent, BitArray *isMasked,
            BitArray *outIsMasked)
        Restore a state from read data, without using a cursor Call after
        create hypertree with initialize.
        
        @param number_of_levels: the maximum number of levels.
        @param nb_vertices: the number of vertices of the future tree
        (coarse and leaves), fixed either the information loading (for
        load reduction) or defined by the fixed level of reader.
        @param nb_vertices_of_last_level: the number of vertices of last
        valid level.
        @param is_parent: a binary decomposition tree by level with
        constraint all describe children. It is useless to declare all
        the lastest values to False, especially the last level may not be
        defined.
        @param is_masked: a binary mask corresponding. It is useless
        to declare all the latest values to False.
        @param out_is_masked: the mask of hypertree grid including
        this hypertree which is a BitArray.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'vtkBitArray', 'vtkBitArray', 'vtkBitArray')])
        ret = self._wrap_call(self._vtk_obj.InitializeForReader, *my_args)
        return ret

    def is_global_index_implicit(self):
        """
        V.is_global_index_implicit() -> bool
        C++: virtual bool IsGlobalIndexImplicit()
        Return if implicit global index maping has been used. If true,
        the initialize has been done by set_global_index_start (one call by
        hypertree). If false, the initialize has been done by
        set_global_index_from_local (one call by cell of hypertree).
        get_global_index_from_locel get the good value of global index
        mapping for one cell what ever the initialize metho used.
        """
        ret = self._vtk_obj.IsGlobalIndexImplicit()
        return ret
        

    def is_leaf(self, *args):
        """
        V.is_leaf(int) -> bool
        C++: virtual bool IsLeaf(IdType index)
        Return if a vertice identified by index in tree as being leaf.
        \pre not_valid_index
        """
        ret = self._wrap_call(self._vtk_obj.IsLeaf, *args)
        return ret

    def is_terminal_node(self, *args):
        """
        V.is_terminal_node(int) -> bool
        C++: virtual bool IsTerminalNode(IdType index)
        Return if a vertice identified by index in tree as a terminal
        node. For this, all childrens mus be all leaves.
        \pre not_valid_index
        \pre not_valid_child_index
        """
        ret = self._wrap_call(self._vtk_obj.IsTerminalNode, *args)
        return ret

    def subdivide_leaf(self, *args):
        """
        V.subdivide_leaf(int, int)
        C++: virtual void SubdivideLeaf(IdType index,
            unsigned int level)
        Subdivide a vertice, only if its a leaf.
        \pre not_valide_index
        \pre not_leaf
        """
        ret = self._wrap_call(self._vtk_obj.SubdivideLeaf, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('global_index_from_local',
    'GetGlobalIndexFromLocal'), ('global_index_start',
    'GetGlobalIndexStart'), ('tree_index', 'GetTreeIndex'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'global_index_from_local',
    'global_index_start', 'tree_index'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTree, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['global_index_from_local', 'global_index_start',
            'tree_index']),
            title='Edit HyperTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

