# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exporter import Exporter


class GLTFExporter(Exporter):
    """
    GLTFExporter - export a scene into GLTF 2.0 format.
    
    Superclass: Exporter
    
    GLTFExporter is a concrete subclass of Exporter that writes
    GLTF 2.0 files. It currently only supports a very small subset of
    what VTK can do including polygonal meshes with optional vertex
    colors. Over time the class can be expanded to support more and more
    of what VTK renders.
    
    It should be noted that gltf is a format for rendering data. As such
    it stores what the VTK scene renders as, not the underlying data. For
    example it currently does not support quads or higher sided polygons
    although VTK does. As such taking an exported gltf file and then
    selecting wireframe in a viewer will give all triangles where VTK's
    rendering would correctly draw the original polygons. etc.
    
    @sa
    Exporter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFExporter, obj, update, **traits)
    
    inline_data = tvtk_base.false_bool_trait(desc=\
        """
        Should the binary data be included in the json file as a base64
        string.
        """
    )

    def _inline_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInlineData,
                        self.inline_data_)

    save_batch_id = tvtk_base.false_bool_trait(desc=\
        """
        It looks for point arrays called _BATCHID in the data and it
        saves it in the GLTF file if found. _BATCHID is an index used in
        3d Tiles b3dm format. This format stores a binary gltf with a
        mesh that has several objects (buildings). Objects are indexed
        from 0 to number of objects - 1, all points of an objects have
        the same index. These index values are stored in _BATCHID
        """
    )

    def _save_batch_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveBatchId,
                        self.save_batch_id_)

    save_normal = tvtk_base.false_bool_trait(desc=\
        """
        It looks for a point array called NORMAL in the data and it saves
        it in the GLTF file if found. NORMAL is the vertex normal. Cesium
        needs this to render buildings correctly if there is no texture.
        """
    )

    def _save_normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveNormal,
                        self.save_normal_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Specify the name of the GLTF file to write.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        """
        These methods are provided for backward compatibility. Will
        disappear soon.
        """
    )

    def write_to_string(self):
        """
        V.write_to_string() -> string
        C++: std::string WriteToString()
        Write the result to a string instead of a file
        """
        ret = self._vtk_obj.WriteToString()
        return ret
        

    _updateable_traits_ = \
    (('inline_data', 'GetInlineData'), ('save_batch_id',
    'GetSaveBatchId'), ('save_normal', 'GetSaveNormal'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('file_name', 'GetFileName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'inline_data', 'save_batch_id',
    'save_normal', 'file_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['inline_data', 'save_batch_id', 'save_normal'], [],
            ['file_name']),
            title='Edit GLTFExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

