# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class EvenlySpacedStreamlines2D(PolyDataAlgorithm):
    """
    EvenlySpacedStreamlines2D - Evenly spaced streamline generator for
    2d.
    
    Superclass: PolyDataAlgorithm
    
    EvenlySpacedStreamlines2D is a filter that integrates a 2d vector
    field to generate evenly-spaced streamlines.
    
    We implement the algorithm described in: Jobard, Bruno, and Wilfrid
    Lefer. "Creating evenly-spaced streamlines of arbitrary density."
    Visualization in Scientific Computing '97. Springer Vienna, 1997.
    43-55. The loop detection is described in: Liu, Zhanping, Robert
    Moorhead, and Joe Groner. "An advanced evenly-spaced streamline placement
    algorithm." IEEE Transactions on Visualization and Computer Graphics
    12.5 (2006): 965-972.
    
    The integration is performed using a specified integrator, by default
    Runge-Kutta2.
    
    EvenlySpacedStreamlines2D produces polylines as the output, with
    each cell (i.e., polyline) representing a streamline. The attribute
    values associated with each streamline are stored in the cell data,
    whereas those associated with streamline-points are stored in the
    point data.
    
    EvenlySpacedStreamlines2D integrates streamlines both forward and
    backward. The integration for a streamline terminates upon exiting
    the flow field domain, or if the particle speed is reduced to a value
    less than a specified terminal speed, if the current streamline gets
    too close to other streamlines
    (vtk_stream_tracer::_fixed__reasons__for__termination__count + 1) or if the
    streamline forms a loop
    (vtk_stream_tracer::_fixed__reasons__for__termination__count). The specific
    reason for the termination is stored in a cell array named
    reason_for_termination.
    
    Note that normalized vectors are adopted in streamline integration,
    which achieves high numerical accuracy/smoothness of flow lines that
    is particularly guaranteed for Runge-Kutta45 with adaptive step size
    and error control). In support of this feature, the underlying step
    size is ALWAYS in arc length unit (LENGTH_UNIT) while the 'real' time
    interval (virtual for steady flows) that a particle actually takes to
    trave in a single step is obtained by dividing the arc length by the
    LOCAL speed. The overall elapsed time (i.e., the life span) of the
    particle is the sum of those individual step-wise time intervals.
    
    The quality of streamline integration can be controlled by setting
    the initial integration step (_initial_integration_step), particularly
    for Runge-Kutta2 and Runge-Kutta4 (with a fixed step size). We do not
    support Runge-Kutta45 (with an adaptive step size and error control)
    because a requirement of the algorithm is that sample points along a
    streamline be evenly spaced. These steps are in either LENGTH_UNIT or
    CELL_LENGTH_UNIT.
    
    The integration time, vorticity, rotation and angular velocity are
    stored in point data arrays named "_integration_time", "Vorticity",
    "Rotation" and "_angular_velocity", respectively (vorticity, rotation
    and angular velocity are computed only when compute_vorticity is on).
    All point data attributes in the source dataset are interpolated on
    the new streamline points.
    
    EvenlySpacedStreamlines2D supports integration through any type of
    2d dataset.
    
    The starting point, or the so-called 'seed', of the first streamline
    is set by setting start_position
    
    @sa
    StreamTracer RibbonFilter RuledSurfaceFilter
    InitialValueProblemSolver RungeKutta2 RungeKutta4
    RungeKutta45 ParticleTracerBase ParticleTracer
    ParticlePathFilter StreaklineFilter
    AbstractInterpolatedVelocityField InterpolatedVelocityField
    CellLocatorInterpolatedVelocityField
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkEvenlySpacedStreamlines2D, obj, update, **traits)
    
    integrator_type = tvtk_base.RevPrefixMap({'runge_kutta2': 0, 'runge_kutta4': 1}, default_value='runge_kutta2', desc=\
        """
        Set/get the integrator type to be used for streamline generation.
        The object passed is not actually used but is cloned with
        new_instance in the process of integration  (prototype pattern).
        The default is Runge-Kutta2. The integrator can also be changed
        using set_integrator_type. The recognized solvers are: RUNGE_KUTTA2
         = 0 RUNGE_KUTTA4  = 1
        """
    )

    def _integrator_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegratorType,
                        self.integrator_type_)

    closed_loop_maximum_distance = traits.Float(1e-06, enter_set=True, auto_set=False, desc=\
        """
        Loops are considered closed if the have two points at distance
        less than this. This is expressed in integration_step_unit.
        """
    )

    def _closed_loop_maximum_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClosedLoopMaximumDistance,
                        self.closed_loop_maximum_distance)

    compute_vorticity = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Turn on/off vorticity computation at streamline points (necessary
        for generating proper stream-ribbons using the RibbonFilter.
        """
    )

    def _compute_vorticity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeVorticity,
                        self.compute_vorticity)

    initial_integration_step = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        """
        Specify the Initial step size used for line integration,
        expressed in integration_step_unit
        
        This is the constant / fixed size for non-adaptive integration
        methods, i.e., RK2 and RK4
        """
    )

    def _initial_integration_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInitialIntegrationStep,
                        self.initial_integration_step)

    integration_step_unit = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Specify a uniform integration step unit for
        initial_integration_step, and separating_distance. Valid units are
        LENGTH_UNIT (1) (value is in global coordinates) and
        CELL_LENGTH_UNIT (2) (the value is in number of cell lengths)
        """
    )

    def _integration_step_unit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegrationStepUnit,
                        self.integration_step_unit)

    def _get_integrator(self):
        return wrap_vtk(self._vtk_obj.GetIntegrator())
    def _set_integrator(self, arg):
        old_val = self._get_integrator()
        self._wrap_call(self._vtk_obj.SetIntegrator,
                        deref_vtk(arg))
        self.trait_property_changed('integrator', old_val, arg)
    integrator = traits.Property(_get_integrator, _set_integrator, desc=\
        """
        Set/get the integrator type to be used for streamline generation.
        The object passed is not actually used but is cloned with
        new_instance in the process of integration  (prototype pattern).
        The default is Runge-Kutta2. The integrator can also be changed
        using set_integrator_type. The recognized solvers are: RUNGE_KUTTA2
         = 0 RUNGE_KUTTA4  = 1
        """
    )

    loop_angle = traits.Float(0.349066, enter_set=True, auto_set=False, desc=\
        """
        The angle (in radians) between the vector created by p0p1 and the
        velocity in the point closing the loop. p0 is the current point
        and p1 is the point before that.  Default value is 20 degrees in
        radians.
        """
    )

    def _loop_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoopAngle,
                        self.loop_angle)

    maximum_number_of_steps = traits.Int(2000, enter_set=True, auto_set=False, desc=\
        """
        Specify the maximum number of steps for integrating a streamline.
        """
    )

    def _maximum_number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfSteps,
                        self.maximum_number_of_steps)

    minimum_number_of_loop_points = traits.Int(4, enter_set=True, auto_set=False, desc=\
        """
        We don't try to eliminate loops with fewer points than this.
        Default value is 4.
        """
    )

    def _minimum_number_of_loop_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumNumberOfLoopPoints,
                        self.minimum_number_of_loop_points)

    separating_distance = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Specify the separation distance between streamlines expressed in
        integration_step_unit.
        """
    )

    def _separating_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSeparatingDistance,
                        self.separating_distance)

    separating_distance_ratio = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        """
        Streamline integration is stopped if streamlines are closer than
        separating_distance*_separating_distance_ratio to other streamlines.
        """
    )

    def _separating_distance_ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSeparatingDistanceRatio,
                        self.separating_distance_ratio)

    start_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Specify the starting point (seed) of the first streamline in the
        global coordinate system. Search must be performed to find the
        initial cell from which to start integration. If the seed is not
        specified a random position in the input data is chosen.
        """
    )

    def _start_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStartPosition,
                        self.start_position)

    terminal_speed = traits.Float(1e-12, enter_set=True, auto_set=False, desc=\
        """
        Specify the terminal speed value, below which integration is
        terminated.
        """
    )

    def _terminal_speed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTerminalSpeed,
                        self.terminal_speed)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_interpolator_prototype(self, *args):
        """
        V.set_interpolator_prototype(AbstractInterpolatedVelocityField)
        C++: void SetInterpolatorPrototype(
            AbstractInterpolatedVelocityField *ivf)
        The object used to interpolate the velocity field during
        integration is of the same class as this prototype.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInterpolatorPrototype, *my_args)
        return ret

    def set_interpolator_type(self, *args):
        """
        V.set_interpolator_type(int)
        C++: void SetInterpolatorType(int interpType)
        Set the type of the velocity field interpolator to determine
        whether InterpolatedVelocityField
        (INTERPOLATOR_WITH_DATASET_POINT_LOCATOR) or
        CellLocatorInterpolatedVelocityField
        (INTERPOLATOR_WITH_CELL_LOCATOR) is employed for locating cells
        during streamline integration. The latter (adopting
        AbstractCellLocator sub-classes such as CellLocator and
        ModifiedBSPTree) is more robust then the former (through
        DataSet / PointSet::FindCell() coupled with
        PointLocator).
        """
        ret = self._wrap_call(self._vtk_obj.SetInterpolatorType, *args)
        return ret

    def set_interpolator_type_to_cell_locator(self):
        """
        V.set_interpolator_type_to_cell_locator()
        C++: void SetInterpolatorTypeToCellLocator()
        Set the velocity field interpolator type to the one involving a
        cell locator.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToCellLocator()
        return ret
        

    def set_interpolator_type_to_data_set_point_locator(self):
        """
        V.set_interpolator_type_to_data_set_point_locator()
        C++: void SetInterpolatorTypeToDataSetPointLocator()
        Set the velocity field interpolator type to the one involving a
        dataset point locator.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToDataSetPointLocator()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('integrator_type', 'GetIntegratorType'),
    ('closed_loop_maximum_distance', 'GetClosedLoopMaximumDistance'),
    ('compute_vorticity', 'GetComputeVorticity'),
    ('initial_integration_step', 'GetInitialIntegrationStep'),
    ('integration_step_unit', 'GetIntegrationStepUnit'), ('loop_angle',
    'GetLoopAngle'), ('maximum_number_of_steps',
    'GetMaximumNumberOfSteps'), ('minimum_number_of_loop_points',
    'GetMinimumNumberOfLoopPoints'), ('separating_distance',
    'GetSeparatingDistance'), ('separating_distance_ratio',
    'GetSeparatingDistanceRatio'), ('start_position', 'GetStartPosition'),
    ('terminal_speed', 'GetTerminalSpeed'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'integrator_type',
    'closed_loop_maximum_distance', 'compute_vorticity',
    'initial_integration_step', 'integration_step_unit', 'loop_angle',
    'maximum_number_of_steps', 'minimum_number_of_loop_points',
    'progress_text', 'separating_distance', 'separating_distance_ratio',
    'start_position', 'terminal_speed'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(EvenlySpacedStreamlines2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit EvenlySpacedStreamlines2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['integrator_type'], ['closed_loop_maximum_distance',
            'compute_vorticity', 'initial_integration_step',
            'integration_step_unit', 'loop_angle', 'maximum_number_of_steps',
            'minimum_number_of_loop_points', 'separating_distance',
            'separating_distance_ratio', 'start_position', 'terminal_speed']),
            title='Edit EvenlySpacedStreamlines2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit EvenlySpacedStreamlines2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

