# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class CityGMLReader(MultiBlockDataSetAlgorithm):
    """
    CityGMLReader - reads city_gml files
    
    Superclass: MultiBlockDataSetAlgorithm
    
    CityGMLReader is a reader for city_gml .gml files. The output is a
    multiblock dataset. We read objects at level of detail (LOD)
    specified (default is 3).
    
    * The leafs of the multiblock dataset (which are polygonal datasets)
    * have a field array with one element called "gml_id" which
    * corresponds to the gml:id for gml:_triangulated_surface,
    * gml:_multi_surface or gml:_composite_surface in the city_gml file. If
    * the poly dataset has a texture, we specify this with a point array
    * called "tcoords" and a field array with one element called
    * "texture_uri" containing the path to the texture file. If the poly
    * dataset has a app::_x3d_material we store two fields arrays with 3
    * components and 1 tuple: "diffuse_color" and "specular_color" and
    * one field array with 1 component and 1 tuple: "transparency".
    
    * Top level children of the multiblock dataset have a field array
    * with one element called "element" which contains the city_gml
    * element name for example: dem:_relief_feature, wtr:_water_body,
    * grp::_city_object_group (forest), veg:_solitary_vegetation_object,
    * brid:Bridge, run:Tunel, tran:Railway, tran:Road, bldg:Building,
    * gen:_generic_city_object, luse:_land_use. These nodes also have a gml_id
    field array.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCityGMLReader, obj, update, **traits)
    
    use_transparency_as_opacity = tvtk_base.false_bool_trait(desc=\
        """
        Certain input files use app:transparency as opacity. Set this
        field true to show that correctly. The default is false.
        """
    )

    def _use_transparency_as_opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseTransparencyAsOpacity,
                        self.use_transparency_as_opacity_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Specify file name of the city_gml data file to read.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    lod = traits.Trait(3, traits.Range(0, 4, enter_set=True, auto_set=False), desc=\
        """
        Specify the level of detail (LOD) to read. Valid values are from
        0 (least detailed) through 4 (most detailed), default value is 3.
        """
    )

    def _lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLOD,
                        self.lod)

    number_of_buildings = traits.Int(2147483647, enter_set=True, auto_set=False, desc=\
        """
        Number of buildings read from the file. Default is
        numeric_limits::max().
        """
    )

    def _number_of_buildings_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBuildings,
                        self.number_of_buildings)

    _updateable_traits_ = \
    (('use_transparency_as_opacity', 'GetUseTransparencyAsOpacity'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('lod', 'GetLOD'), ('number_of_buildings',
    'GetNumberOfBuildings'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_transparency_as_opacity', 'file_name',
    'lod', 'number_of_buildings', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CityGMLReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CityGMLReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_transparency_as_opacity'], [], ['file_name', 'lod',
            'number_of_buildings']),
            title='Edit CityGMLReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CityGMLReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

