# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Uniforms(Object):
    """
    Uniforms - helper class to set custom uniform variables in GPU
    shaders.
    
    Superclass: Object
    
    This class implements a generic mechanism to declare and set the
    value of custom uniform variables to be used in GPU shader programs
    used by mappers. It allows users who specify custom shader code for
    mappers to change the value of the variable they define without
    triggering a costly rebuild of the shader. This class is used mostly
    as an interface and the implementation is found in graphics api
    specific derived classes (e.g.: OpenGLUniforms).
    
    @sa
    OpenGLUniforms ShaderProperty
    
    @par Thanks: Developed by Simon Drouin (sdrouin2@bwh.harvard.edu) at
    Brigham and Women's Hospital.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUniforms, obj, update, **traits)
    
    def _get_uniform(self):
        return self._vtk_obj.GetUniform()
    def _set_uniform(self, arg):
        old_val = self._get_uniform()
        self._wrap_call(self._vtk_obj.SetUniform,
                        arg)
        self.trait_property_changed('uniform', old_val, arg)
    uniform = traits.Property(_get_uniform, _set_uniform, desc=\
        """
        Generic setters and getter. Set and Get the value of uniform
        variable name, with tuple_type tt, number of components
        nb_components and values stored invalue. These functions simplify
        io of uniforms
        """
    )

    def get_uniform1fv(self, *args):
        """
        V.get_uniform1fv(string, Stvector_IfE) -> bool
        C++: virtual bool GetUniform1fv(const char *name,
            std::vector<float> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform1fv, *args)
        return ret

    def set_uniform1fv(self, *args):
        """
        V.set_uniform1fv(string, int, (float, ...))
        C++: virtual void SetUniform1fv(const char *name, const int count,
             const float *f)
        Set the name uniform array to f with count elements
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform1fv, *args)
        return ret

    def get_uniform1iv(self, *args):
        """
        V.get_uniform1iv(string, Stvector_IiE) -> bool
        C++: virtual bool GetUniform1iv(const char *name,
            std::vector<int> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform1iv, *args)
        return ret

    def set_uniform1iv(self, *args):
        """
        V.set_uniform1iv(string, int, (int, ...))
        C++: virtual void SetUniform1iv(const char *name, const int count,
             const int *f)
        Set the name uniform array to f with count elements
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform1iv, *args)
        return ret

    def get_uniform2f(self, *args):
        """
        V.get_uniform2f(string, [float, float]) -> bool
        C++: virtual bool GetUniform2f(const char *name, float v[2])
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform2f, *args)
        return ret

    def set_uniform2f(self, *args):
        """
        V.set_uniform2f(string, (float, float))
        C++: virtual void SetUniform2f(const char *name, const float v[2])
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform2f, *args)
        return ret

    def get_uniform2i(self, *args):
        """
        V.get_uniform2i(string, [int, int]) -> bool
        C++: virtual bool GetUniform2i(const char *name, int v[2])
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform2i, *args)
        return ret

    def set_uniform2i(self, *args):
        """
        V.set_uniform2i(string, (int, int))
        C++: virtual void SetUniform2i(const char *name, const int v[2])
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform2i, *args)
        return ret

    def get_uniform3f(self, *args):
        """
        V.get_uniform3f(string, [float, float, float]) -> bool
        C++: virtual bool GetUniform3f(const char *name, double v[3])
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform3f, *args)
        return ret

    def set_uniform3f(self, *args):
        """
        V.set_uniform3f(string, (float, float, float))
        C++: virtual void SetUniform3f(const char *name,
            const double v[3])
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform3f, *args)
        return ret

    def get_uniform3uc(self, *args):
        """
        V.get_uniform3uc(string, [int, int, int]) -> bool
        C++: virtual bool GetUniform3uc(const char *name,
            unsigned char v[3])
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform3uc, *args)
        return ret

    def set_uniform3uc(self, *args):
        """
        V.set_uniform3uc(string, (int, int, int))
        C++: virtual void SetUniform3uc(const char *name,
            const unsigned char v[3])
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform3uc, *args)
        return ret

    def get_uniform4f(self, *args):
        """
        V.get_uniform4f(string, [float, float, float, float]) -> bool
        C++: virtual bool GetUniform4f(const char *name, float v[4])
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform4f, *args)
        return ret

    def set_uniform4f(self, *args):
        """
        V.set_uniform4f(string, (float, float, float, float))
        C++: virtual void SetUniform4f(const char *name, const float v[4])
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform4f, *args)
        return ret

    def get_uniform4uc(self, *args):
        """
        V.get_uniform4uc(string, [int, int, int, int]) -> bool
        C++: virtual bool GetUniform4uc(const char *name,
            unsigned char v[4])
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform4uc, *args)
        return ret

    def set_uniform4uc(self, *args):
        """
        V.set_uniform4uc(string, (int, int, int, int))
        C++: virtual void SetUniform4uc(const char *name,
            const unsigned char v[4])
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform4uc, *args)
        return ret

    def get_uniform_matrix(self, *args):
        """
        V.get_uniform_matrix(string, Matrix3x3) -> bool
        C++: virtual bool GetUniformMatrix(const char *name,
            Matrix3x3 *v)
        V.get_uniform_matrix(string, Matrix4x4) -> bool
        C++: virtual bool GetUniformMatrix(const char *name,
            Matrix4x4 *v)
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix, *my_args)
        return ret

    def set_uniform_matrix(self, *args):
        """
        V.set_uniform_matrix(string, Matrix3x3)
        C++: virtual void SetUniformMatrix(const char *name,
            Matrix3x3 *v)
        V.set_uniform_matrix(string, Matrix4x4)
        C++: virtual void SetUniformMatrix(const char *name,
            Matrix4x4 *v)
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix, *my_args)
        return ret

    def get_uniform_matrix3x3(self, *args):
        """
        V.get_uniform_matrix3x3(string, [float, ...]) -> bool
        C++: virtual bool GetUniformMatrix3x3(const char *name, float *v)
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix3x3, *args)
        return ret

    def set_uniform_matrix3x3(self, *args):
        """
        V.set_uniform_matrix3x3(string, [float, ...])
        C++: virtual void SetUniformMatrix3x3(const char *name, float *v)
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix3x3, *args)
        return ret

    def get_uniform_matrix4x4(self, *args):
        """
        V.get_uniform_matrix4x4(string, [float, ...]) -> bool
        C++: virtual bool GetUniformMatrix4x4(const char *name, float *v)
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4, *args)
        return ret

    def set_uniform_matrix4x4(self, *args):
        """
        V.set_uniform_matrix4x4(string, [float, ...])
        C++: virtual void SetUniformMatrix4x4(const char *name, float *v)
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4, *args)
        return ret

    def get_uniform_matrix4x4v(self, *args):
        """
        V.get_uniform_matrix4x4v(string, Stvector_IfE) -> bool
        C++: virtual bool GetUniformMatrix4x4v(const char *name,
            std::vector<float> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4v, *args)
        return ret

    def set_uniform_matrix4x4v(self, *args):
        """
        V.set_uniform_matrix4x4v(string, int, [float, ...])
        C++: virtual void SetUniformMatrix4x4v(const char *name,
            const int count, float *v)
        Set the name uniform array to f with count elements
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4v, *args)
        return ret

    def get_uniformf(self, *args):
        """
        V.get_uniformf(string, float) -> bool
        C++: virtual bool GetUniformf(const char *name, float &v)
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformf, *args)
        return ret

    def set_uniformf(self, *args):
        """
        V.set_uniformf(string, float)
        C++: virtual void SetUniformf(const char *name, float v)
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformf, *args)
        return ret

    def get_uniformi(self, *args):
        """
        V.get_uniformi(string, int) -> bool
        C++: virtual bool GetUniformi(const char *name, int &v)
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformi, *args)
        return ret

    def set_uniformi(self, *args):
        """
        V.set_uniformi(string, int)
        C++: virtual void SetUniformi(const char *name, int v)
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformi, *args)
        return ret

    def get_nth_uniform_name(self, *args):
        """
        V.get_nth_uniform_name(int) -> string
        C++: virtual const char *GetNthUniformName(IdType uniformIndex)
        Get number of all uniforms stored in this class. Valid range is
        between 0 and get_number_of_uniforms() - 1.
        """
        ret = self._wrap_call(self._vtk_obj.GetNthUniformName, *args)
        return ret

    def _get_number_of_uniforms(self):
        return self._vtk_obj.GetNumberOfUniforms()
    number_of_uniforms = traits.Property(_get_number_of_uniforms, desc=\
        """
        Get number of all uniforms stored in this class
        """
    )

    def get_uniform2fv(self, *args):
        """
        V.get_uniform2fv(string, Stvector_IfE) -> bool
        C++: virtual bool GetUniform2fv(const char *name,
            std::vector<float> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform2fv, *args)
        return ret

    def get_uniform3fv(self, *args):
        """
        V.get_uniform3fv(string, Stvector_IfE) -> bool
        C++: virtual bool GetUniform3fv(const char *name,
            std::vector<float> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform3fv, *args)
        return ret

    def get_uniform4fv(self, *args):
        """
        V.get_uniform4fv(string, Stvector_IfE) -> bool
        C++: virtual bool GetUniform4fv(const char *name,
            std::vector<float> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform4fv, *args)
        return ret

    def _get_uniform_list_m_time(self):
        return self._vtk_obj.GetUniformListMTime()
    uniform_list_m_time = traits.Property(_get_uniform_list_m_time, desc=\
        """
        
        """
    )

    def get_uniform_number_of_components(self, *args):
        """
        V.get_uniform_number_of_components(string) -> int
        C++: virtual int GetUniformNumberOfComponents(const char *name)
        Get the number of components stored in each tuple of uniform
        name. for example, a uniform with tuples of matrix type and 9
        components contains 3x3 matrices
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformNumberOfComponents, *args)
        return ret

    def get_uniform_number_of_tuples(self, *args):
        """
        V.get_uniform_number_of_tuples(string) -> int
        C++: virtual int GetUniformNumberOfTuples(const char *name)
        Number of tuples of uniform name that contains a variable-size
        vector. For example, for 3 components uniforms of type vector,
        this is the number of triplets.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformNumberOfTuples, *args)
        return ret

    def get_uniform_scalar_type(self, *args):
        """
        V.get_uniform_scalar_type(string) -> int
        C++: virtual int GetUniformScalarType(const char *name)
        Get type of scalars stored in uniform name
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformScalarType, *args)
        return ret

    def get_uniform_tuple_type(self, *args):
        """
        V.get_uniform_tuple_type(string) -> TupleType
        C++: virtual TupleType GetUniformTupleType(const char *name)
        Get the tuple type stored in uniform name. This can be a scalar,
        a vector of a matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformTupleType, *args)
        return ret

    def remove_all_uniforms(self):
        """
        V.remove_all_uniforms()
        C++: virtual void RemoveAllUniforms()
        Remove all uniform variables
        """
        ret = self._vtk_obj.RemoveAllUniforms()
        return ret
        

    def remove_uniform(self, *args):
        """
        V.remove_uniform(string)
        C++: virtual void RemoveUniform(const char *name)
        Remove uniform variable named name
        """
        ret = self._wrap_call(self._vtk_obj.RemoveUniform, *args)
        return ret

    def scalar_type_to_string(self, *args):
        """
        V.scalar_type_to_string(int) -> string
        C++: static std::string ScalarTypeToString(int scalaType)
        Convert between scalar types an string
        """
        ret = self._wrap_call(self._vtk_obj.ScalarTypeToString, *args)
        return ret

    def string_to_scalar_type(self, *args):
        """
        V.string_to_scalar_type(string) -> int
        C++: static int StringToScalarType(const std::string &s)"""
        ret = self._wrap_call(self._vtk_obj.StringToScalarType, *args)
        return ret

    def string_to_tuple_type(self, *args):
        """
        V.string_to_tuple_type(string) -> TupleType
        C++: static TupleType StringToTupleType(const std::string &s)"""
        ret = self._wrap_call(self._vtk_obj.StringToTupleType, *args)
        return ret

    def tuple_type_to_string(self, *args):
        """
        V.tuple_type_to_string(TupleType) -> string
        C++: static std::string TupleTypeToString(TupleType tt)
        Convert between tuple_type and string
        """
        ret = self._wrap_call(self._vtk_obj.TupleTypeToString, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Uniforms, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

