# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class CellSizeFilter(PassInputTypeAlgorithm):
    """
    CellSizeFilter - Computes cell sizes.
    
    Superclass: PassInputTypeAlgorithm
    
    Computes the cell sizes for all types of cells in VTK. For triangles,
    quads, tets and hexes the static methods in MeshQuality are used.
    This is done through Verdict for higher accuracy. Other cell types
    are individually done analytically where possible and breaking into
    triangles or tets when not possible. When cells are broken into
    triangles or tets the accuracy may be diminished. By default all
    sizes are computed but vertex count, length, area and volumetric
    cells can each be optionally ignored. Individual arrays are used for
    each requested size (e.g. if length and volume are requested there
    will be two arrays outputted from this filter). The 4 arrays can be
    individually named with defaults of vertex_count, Length, Area and
    Volme. For dimensions of cells that do not have their size computed,
    a value of 0 will be given. For cells that should have their size
    computed but can't, the filter will return -1. The compute_sum option
    will sum the cell sizes (excluding ghost cells) and put the value
    into FieldData arrays named with the corresponding cell data array
    name. For composite datasets the total sum over all blocks will also
    be added to the top-level block's field data for the summation.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellSizeFilter, obj, update, **traits)
    
    compute_area = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether or not to compute sizes for 2d cells cells. The
        computed value is the area of the cell. This option is enabled by
        default.
        """
    )

    def _compute_area_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeArea,
                        self.compute_area_)

    compute_length = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether or not to compute sizes for 1d cells cells. The
        computed value is the length of the cell. This option is enabled
        by default.
        """
    )

    def _compute_length_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeLength,
                        self.compute_length_)

    compute_sum = tvtk_base.false_bool_trait(desc=\
        """
        Specify whether to sum the computed sizes and put the result in a
        field data array. This option is disabled by default.
        """
    )

    def _compute_sum_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeSum,
                        self.compute_sum_)

    compute_vertex_count = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether or not to compute sizes for vertex and polyvertex
        cells. The computed value is the number of points in the cell.
        This option is enabled by default.
        """
    )

    def _compute_vertex_count_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeVertexCount,
                        self.compute_vertex_count_)

    compute_volume = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether or not to compute sizes for 3d cells cells. The
        computed value is the volume of the cell. This option is enabled
        by default.
        """
    )

    def _compute_volume_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeVolume,
                        self.compute_volume_)

    area_array_name = traits.String('Area', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the name of the computed arrays. Default names are
        vertex_count, Length, Area and Volume.
        """
    )

    def _area_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAreaArrayName,
                        self.area_array_name)

    length_array_name = traits.String('Length', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the name of the computed arrays. Default names are
        vertex_count, Length, Area and Volume.
        """
    )

    def _length_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLengthArrayName,
                        self.length_array_name)

    vertex_count_array_name = traits.String('VertexCount', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the name of the computed arrays. Default names are
        vertex_count, Length, Area and Volume.
        """
    )

    def _vertex_count_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexCountArrayName,
                        self.vertex_count_array_name)

    volume_array_name = traits.String('Volume', enter_set=True, auto_set=False, desc=\
        """
        Set/Get the name of the computed arrays. Default names are
        vertex_count, Length, Area and Volume.
        """
    )

    def _volume_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVolumeArrayName,
                        self.volume_array_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('compute_area', 'GetComputeArea'), ('compute_length',
    'GetComputeLength'), ('compute_sum', 'GetComputeSum'),
    ('compute_vertex_count', 'GetComputeVertexCount'), ('compute_volume',
    'GetComputeVolume'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('area_array_name', 'GetAreaArrayName'), ('length_array_name',
    'GetLengthArrayName'), ('vertex_count_array_name',
    'GetVertexCountArrayName'), ('volume_array_name',
    'GetVolumeArrayName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_area', 'compute_length', 'compute_sum',
    'compute_vertex_count', 'compute_volume', 'debug',
    'global_warning_display', 'release_data_flag', 'area_array_name',
    'length_array_name', 'progress_text', 'vertex_count_array_name',
    'volume_array_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellSizeFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellSizeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_area', 'compute_length', 'compute_sum',
            'compute_vertex_count', 'compute_volume'], [], ['area_array_name',
            'length_array_name', 'vertex_count_array_name', 'volume_array_name']),
            title='Edit CellSizeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellSizeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

