# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Window(Object):
    """
    Window - window superclass for RenderWindow
    
    Superclass: Object
    
    Window is an abstract object to specify the behavior of a
    rendering window.  It contains Viewports.
    
    @sa
    RenderWindow Viewport
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWindow, obj, update, **traits)
    
    double_buffer = tvtk_base.true_bool_trait(desc=\
        """
        Keep track of whether double buffering is on or off
        """
    )

    def _double_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDoubleBuffer,
                        self.double_buffer_)

    erase = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off erasing the screen between images. This allows
        multiple exposure sequences if turned on. You will need to turn
        double buffering off or make use of the swap_buffers methods to
        prevent you from swapping buffers between exposures.
        """
    )

    def _erase_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetErase,
                        self.erase_)

    off_screen_rendering = tvtk_base.false_bool_trait(desc=\
        """
        Convenience to set s_how_window and use_off_screen_buffers in one call
        """
    )

    def _off_screen_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffScreenRendering,
                        self.off_screen_rendering_)

    show_window = tvtk_base.true_bool_trait(desc=\
        """
        Show or not Show the window
        """
    )

    def _show_window_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShowWindow,
                        self.show_window_)

    use_off_screen_buffers = tvtk_base.false_bool_trait(desc=\
        """
        Render to an offscreen destination such as a framebuffer. All
        four combinations of show_window and use_off_screen_buffers should
        work for most rendering backends.
        """
    )

    def _use_off_screen_buffers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseOffScreenBuffers,
                        self.use_off_screen_buffers_)

    dpi = traits.Trait(72, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Return a best estimate to the dots per inch of the display device
        being rendered (or printed).
        """
    )

    def _dpi_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDPI,
                        self.dpi)

    position = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(0, 0), cols=2, desc=\
        """
        Set the position (x and y) of the rendering window in screen
        coordinates (in pixels). This resizes the operating system's
        view/window and redraws it.
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(0, 0), cols=2, desc=\
        """
        Set the size (width and height) of the rendering window in screen
        coordinates (in pixels). This resizes the operating system's
        view/window and redraws it.
        
        If the size has changed, this method will fire
        Command::WindowResizeEvent.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    tile_scale = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(1, 1), cols=2, desc=\
        """
        These methods are used by WindowToImageFilter to tell a VTK
        window to simulate a larger window by tiling. For 3d geometry
        these methods have no impact. It is just in handling annotation
        that this information must be available to the mappers and the
        coordinate calculations.
        """
    )

    def _tile_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTileScale,
                        self.tile_scale)

    tile_viewport = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 1.0, 1.0), cols=3, desc=\
        """
        These methods are used by WindowToImageFilter to tell a VTK
        window to simulate a larger window by tiling. For 3d geometry
        these methods have no impact. It is just in handling annotation
        that this information must be available to the mappers and the
        coordinate calculations.
        """
    )

    def _tile_viewport_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTileViewport,
                        self.tile_viewport)

    window_name = traits.String('Visualization Toolkit - OpenGL', enter_set=True, auto_set=False, desc=\
        """
        Get name of rendering window
        """
    )

    def _window_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowName,
                        self.window_name)

    def _get_actual_size(self):
        return self._vtk_obj.GetActualSize()
    actual_size = traits.Property(_get_actual_size, desc=\
        """
        get_size() returns the size * this->_tile_scale, whereas this method
        returns the size without multiplying with the tile scale.
        Measured in pixels.
        """
    )

    def _get_generic_context(self):
        return self._vtk_obj.GetGenericContext()
    generic_context = traits.Property(_get_generic_context, desc=\
        """
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
    )

    def _get_generic_display_id(self):
        return self._vtk_obj.GetGenericDisplayId()
    generic_display_id = traits.Property(_get_generic_display_id, desc=\
        """
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
    )

    def _get_generic_drawable(self):
        return self._vtk_obj.GetGenericDrawable()
    generic_drawable = traits.Property(_get_generic_drawable, desc=\
        """
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
    )

    def _get_generic_parent_id(self):
        return self._vtk_obj.GetGenericParentId()
    generic_parent_id = traits.Property(_get_generic_parent_id, desc=\
        """
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
    )

    def _get_generic_window_id(self):
        return self._vtk_obj.GetGenericWindowId()
    generic_window_id = traits.Property(_get_generic_window_id, desc=\
        """
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
    )

    def _get_mapped(self):
        return self._vtk_obj.GetMapped()
    mapped = traits.Property(_get_mapped, desc=\
        """
        Keep track of whether the rendering window has been mapped to
        screen.
        """
    )

    def get_pixel_data(self, *args):
        """
        V.get_pixel_data(int, int, int, int, int, int) -> (int, ...)
        C++: virtual unsigned char *GetPixelData(int, int, int, int, int,
            int=0)
        V.get_pixel_data(int, int, int, int, int, UnsignedCharArray, int)
             -> int
        C++: virtual int GetPixelData(int, int, int, int, int,
            UnsignedCharArray *, int=0)
        Get the pixel data of an image, transmitted as RGBRGBRGB. The
        front argument indicates if the front buffer should be used or
        the back buffer. It is the caller's responsibility to delete the
        resulting array. It is very important to realize that the memory
        in this array is organized from the bottom of the window to the
        top. The origin of the screen is in the lower left corner. The y
        axis increases as you go up the screen. So the storage of pixels
        is from left to right and from bottom to top. (x,y) is any corner
        of the rectangle. (x2,y2) is its opposite corner on the diagonal.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetPixelData, *my_args)
        return ret

    def _get_screen_size(self):
        return self._vtk_obj.GetScreenSize()
    screen_size = traits.Property(_get_screen_size, desc=\
        """
        Get the current size of the screen in pixels.
        """
    )

    def detect_dpi(self):
        """
        V.detect_dpi() -> bool
        C++: virtual bool DetectDPI()
        Attempt to detect and set the DPI of the display device by
        querying the system. Note that this is not supported on most
        backends, and this method will return false if the DPI could not
        be detected. Use get_dpi() to inspect the detected value.
        """
        ret = self._vtk_obj.DetectDPI()
        return ret
        

    def make_current(self):
        """
        V.make_current()
        C++: virtual void MakeCurrent()
        Make the window current. May be overridden in subclasses to do
        for example a gl_x_make_current or a wgl_make_current.
        """
        ret = self._vtk_obj.MakeCurrent()
        return ret
        

    def release_graphics_resources(self, *args):
        """
        V.release_graphics_resources(Window)
        C++: virtual void ReleaseGraphicsResources(Window *)
        Release any graphics resources that are being consumed by this
        texture. The parameter window could be used to determine which
        graphic resources to release.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def render(self):
        """
        V.render()
        C++: virtual void Render()
        Ask each viewport owned by this Window to render its image and
        synchronize this process.
        """
        ret = self._vtk_obj.Render()
        return ret
        

    def set_display_id(self, *args):
        """
        V.set_display_id(void)
        C++: virtual void SetDisplayId(void *)
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
        ret = self._wrap_call(self._vtk_obj.SetDisplayId, *args)
        return ret

    def set_parent_id(self, *args):
        """
        V.set_parent_id(void)
        C++: virtual void SetParentId(void *)
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
        ret = self._wrap_call(self._vtk_obj.SetParentId, *args)
        return ret

    def set_parent_info(self, *args):
        """
        V.set_parent_info(string)
        C++: virtual void SetParentInfo(const char *)
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
        ret = self._wrap_call(self._vtk_obj.SetParentInfo, *args)
        return ret

    def set_window_id(self, *args):
        """
        V.set_window_id(void)
        C++: virtual void SetWindowId(void *)
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
        ret = self._wrap_call(self._vtk_obj.SetWindowId, *args)
        return ret

    def set_window_info(self, *args):
        """
        V.set_window_info(string)
        C++: virtual void SetWindowInfo(const char *)
        These are window system independent methods that are used to help
        interface Window to native windowing systems.
        """
        ret = self._wrap_call(self._vtk_obj.SetWindowInfo, *args)
        return ret

    _updateable_traits_ = \
    (('double_buffer', 'GetDoubleBuffer'), ('erase', 'GetErase'),
    ('off_screen_rendering', 'GetOffScreenRendering'), ('show_window',
    'GetShowWindow'), ('use_off_screen_buffers',
    'GetUseOffScreenBuffers'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('dpi',
    'GetDPI'), ('position', 'GetPosition'), ('size', 'GetSize'),
    ('tile_scale', 'GetTileScale'), ('tile_viewport', 'GetTileViewport'),
    ('window_name', 'GetWindowName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'double_buffer', 'erase', 'global_warning_display',
    'off_screen_rendering', 'show_window', 'use_off_screen_buffers',
    'dpi', 'position', 'size', 'tile_scale', 'tile_viewport',
    'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Window, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Window properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['double_buffer', 'erase', 'off_screen_rendering',
            'show_window', 'use_off_screen_buffers'], [], ['dpi', 'position',
            'size', 'tile_scale', 'tile_viewport', 'window_name']),
            title='Edit Window properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Window properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

