# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ViewNode(Object):
    """
    ViewNode - a node within a VTK scene graph
    
    Superclass: Object
    
    This is the superclass for all nodes within a VTK scene graph. It
    contains the API for a node. It supports the essential operations
    such as graph creation, state storage and traversal. Child classes
    adapt this to VTK's major rendering classes. Grandchild classes adapt
    those to for APIs of different rendering libraries.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkViewNode, obj, update, **traits)
    
    def _get_children(self):
        return wrap_vtk(self._vtk_obj.GetChildren())
    def _set_children(self, arg):
        old_val = self._get_children()
        self._wrap_call(self._vtk_obj.SetChildren,
                        deref_vtk(arg))
        self.trait_property_changed('children', old_val, arg)
    children = traits.Property(_get_children, _set_children, desc=\
        """
        Access nodes that this one owns.
        """
    )

    def _get_my_factory(self):
        return wrap_vtk(self._vtk_obj.GetMyFactory())
    def _set_my_factory(self, arg):
        old_val = self._get_my_factory()
        self._wrap_call(self._vtk_obj.SetMyFactory,
                        deref_vtk(arg))
        self.trait_property_changed('my_factory', old_val, arg)
    my_factory = traits.Property(_get_my_factory, _set_my_factory, desc=\
        """
        A factory that creates particular subclasses for different
        rendering back ends.
        """
    )

    def _get_parent(self):
        return wrap_vtk(self._vtk_obj.GetParent())
    def _set_parent(self, arg):
        old_val = self._get_parent()
        self._wrap_call(self._vtk_obj.SetParent,
                        deref_vtk(arg))
        self.trait_property_changed('parent', old_val, arg)
    parent = traits.Property(_get_parent, _set_parent, desc=\
        """
        Access the node that owns this one.
        """
    )

    def _get_renderable(self):
        return wrap_vtk(self._vtk_obj.GetRenderable())
    def _set_renderable(self, arg):
        old_val = self._get_renderable()
        self._wrap_call(self._vtk_obj.SetRenderable,
                        deref_vtk(arg))
        self.trait_property_changed('renderable', old_val, arg)
    renderable = traits.Property(_get_renderable, _set_renderable, desc=\
        """
        This is the VTK class that this node stands in for.
        """
    )

    def get_first_ancestor_of_type(self, *args):
        """
        V.get_first_ancestor_of_type(string) -> ViewNode
        C++: ViewNode *GetFirstAncestorOfType(const char *type)
        Find the first parent/grandparent of the desired type
        """
        ret = self._wrap_call(self._vtk_obj.GetFirstAncestorOfType, *args)
        return wrap_vtk(ret)

    def get_first_child_of_type(self, *args):
        """
        V.get_first_child_of_type(string) -> ViewNode
        C++: ViewNode *GetFirstChildOfType(const char *type)
        Find the first child of the desired type
        """
        ret = self._wrap_call(self._vtk_obj.GetFirstChildOfType, *args)
        return wrap_vtk(ret)

    def get_view_node_for(self, *args):
        """
        V.get_view_node_for(Object) -> ViewNode
        C++: ViewNode *GetViewNodeFor(Object *)
        Returns the view node that corresponding to the provided object
        Will return NULL if a match is not found in self or descendents
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetViewNodeFor, *my_args)
        return wrap_vtk(ret)

    def build(self, *args):
        """
        V.build(bool)
        C++: virtual void Build(bool)
        Builds myself.
        """
        ret = self._wrap_call(self._vtk_obj.Build, *args)
        return ret

    def invalidate(self, *args):
        """
        V.invalidate(bool)
        C++: virtual void Invalidate(bool)
        Clear any cached data.
        """
        ret = self._wrap_call(self._vtk_obj.Invalidate, *args)
        return ret

    def render(self, *args):
        """
        V.render(bool)
        C++: virtual void Render(bool)
        Makes calls to make self visible.
        """
        ret = self._wrap_call(self._vtk_obj.Render, *args)
        return ret

    def synchronize(self, *args):
        """
        V.synchronize(bool)
        C++: virtual void Synchronize(bool)
        Ensures that my state agrees with my Renderable's.
        """
        ret = self._wrap_call(self._vtk_obj.Synchronize, *args)
        return ret

    def traverse(self, *args):
        """
        V.traverse(int)
        C++: virtual void Traverse(int operation)"""
        ret = self._wrap_call(self._vtk_obj.Traverse, *args)
        return ret

    def traverse_all_passes(self):
        """
        V.traverse_all_passes()
        C++: virtual void TraverseAllPasses()"""
        ret = self._vtk_obj.TraverseAllPasses()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ViewNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ViewNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ViewNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ViewNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

