# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.function_set import FunctionSet


class LagrangianBasicIntegrationModel(FunctionSet):
    """
    LagrangianBasicIntegrationModel - FunctionSet abstract
    implementation to be used in the LagrangianParticleTracker
    integrator.
    
    Superclass: FunctionSet
    
    This FunctionSet abstract implementation is meant to be used as a
    parameter of LagrangianParticleTracker. It manages multiple
    dataset locators in order to evaluate the
    FunctionSet::FunctionValues method. The actual function_values
    implementation should be found in the class inheriting this class.
    Input Arrays to process are expected as follows: Index 0 :
    "_surface_type" array of surface input of the particle tracker
    
    Inherited classes MUST implement int function_values(vtk_data_set*
    deta_set, IdType cell_id, double* weights,
       double * x, double * f); to define how the integration works.
    
    Inherited classes could reimplement initialize_variables_particle_data
    and insert_variables_particle_data to add new user_variables to integrate
    with.
    
    Inherited classes could reimplement interact_with_surface or other
    surface interaction methods to change the way particles interact with
    surfaces.
    
    Inherited classes could reimplement intersect_with_line to use a
    specific algorithm to intersect particles and surface cells.
    
    Inherited classes could reimplement check_free_flight_termination to set
    the way particles terminate in free flight.
    
    Inherited classes could reimplement Initialize*Data and Insert*Data
    in order to customize the output of the tracker
    
    @sa
    LagrangianParticleTracker LagrangianParticle
    LagrangianMatidaIntegrationModel
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLagrangianBasicIntegrationModel, obj, update, **traits)
    
    non_planar_quad_support = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get Non Planar Quad Support
        """
    )

    def _non_planar_quad_support_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNonPlanarQuadSupport,
                        self.non_planar_quad_support_)

    use_initial_integration_time = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get the Use of initial integration input array to process
        """
    )

    def _use_initial_integration_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseInitialIntegrationTime,
                        self.use_initial_integration_time_)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        Set/Get the locator used to locate cells in the datasets. Only
        the locator class matter here, as it is used only to create
        new_instance of it. Default is a CellLocator.
        """
    )

    locators_built = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Get the state of the current locators
        """
    )

    def _locators_built_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLocatorsBuilt,
                        self.locators_built)

    number_of_tracked_user_data = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the number of tracked user data attached to the
        particles. Tracked user data are data that are related to each
        particle position but are not integrated like the user variables.
        They are not saved in the particle path. Default is 0.
        """
    )

    def _number_of_tracked_user_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTrackedUserData,
                        self.number_of_tracked_user_data)

    def get_seed_array(self, *args):
        """
        V.get_seed_array(int, PointData) -> AbstractArray
        C++: virtual AbstractArray *GetSeedArray(int idx,
            PointData *pointData)
        Get a seed array, as set in set_input_array_to_process from the
        provided seed point data
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSeedArray, *my_args)
        return wrap_vtk(ret)

    def _get_seed_array_comps(self):
        return wrap_vtk(self._vtk_obj.GetSeedArrayComps())
    seed_array_comps = traits.Property(_get_seed_array_comps, desc=\
        """
        Get the seed arrays expected number of components Used Only be
        the LagrangianSeedHelper in para_view plugins
        """
    )

    def _get_seed_array_names(self):
        return wrap_vtk(self._vtk_obj.GetSeedArrayNames())
    seed_array_names = traits.Property(_get_seed_array_names, desc=\
        """
        Get the seed arrays expected name Used Only be the
        LagrangianSeedHelper in para_view plugins
        """
    )

    def _get_seed_array_types(self):
        return wrap_vtk(self._vtk_obj.GetSeedArrayTypes())
    seed_array_types = traits.Property(_get_seed_array_types, desc=\
        """
        Get the seed arrays expected type Used Only be the
        LagrangianSeedHelper in para_view plugins
        """
    )

    def _get_surface_array_comps(self):
        return wrap_vtk(self._vtk_obj.GetSurfaceArrayComps())
    surface_array_comps = traits.Property(_get_surface_array_comps, desc=\
        """
        Get the seed array expected number of components Used Only be the
        LagrangianSurfaceHelper in para_view plugins
        """
    )

    def _get_surface_array_default_values(self):
        return wrap_vtk(self._vtk_obj.GetSurfaceArrayDefaultValues())
    surface_array_default_values = traits.Property(_get_surface_array_default_values, desc=\
        """
        Get the surface arrays default values for each leaf Used Only be
        the LagrangianSurfaceHelper in para_view plugins
        """
    )

    def _get_surface_array_enum_values(self):
        return wrap_vtk(self._vtk_obj.GetSurfaceArrayEnumValues())
    surface_array_enum_values = traits.Property(_get_surface_array_enum_values, desc=\
        """
        Get the surface arrays expected values and associated enums Used
        Only be the LagrangianSurfaceHelper in para_view plugins
        """
    )

    def _get_surface_array_names(self):
        return wrap_vtk(self._vtk_obj.GetSurfaceArrayNames())
    surface_array_names = traits.Property(_get_surface_array_names, desc=\
        """
        Get the surface arrays expected name Used Only be the
        LagrangianSurfaceHelper in para_view plugins
        """
    )

    def _get_surface_array_types(self):
        return wrap_vtk(self._vtk_obj.GetSurfaceArrayTypes())
    surface_array_types = traits.Property(_get_surface_array_types, desc=\
        """
        Get the surface arrays expected type Used Only be the
        LagrangianSurfaceHelper in para_view plugins
        """
    )

    def _get_tolerance(self):
        return self._vtk_obj.GetTolerance()
    tolerance = traits.Property(_get_tolerance, desc=\
        """
        Get the tolerance to use with this model.
        """
    )

    def _get_weights_size(self):
        return self._vtk_obj.GetWeightsSize()
    weights_size = traits.Property(_get_weights_size, desc=\
        """
        Get the maximum weights size necessary for calling find_in_locators
        with weights
        """
    )

    def add_data_set(self, *args):
        """
        V.add_data_set(DataSet, bool, int)
        C++: virtual void AddDataSet(DataSet *dataset,
            bool surface=false, unsigned int surfaceFlatIndex=0)
        Add a dataset to locate cells in This create a specific locator
        for the provided dataset using the Locator member of this class
        The surface flag allow to manage surfaces datasets for surface
        interaction instead of flow datasets surface_flat_index, used only
        with composite surface, in order to identify the flat_index of the
        surface for particle interaction
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddDataSet, *my_args)
        return ret

    def clear_data_sets(self, *args):
        """
        V.clear_data_sets(bool)
        C++: virtual void ClearDataSets(bool surface=false)
        Add a dataset to locate cells in This create a specific locator
        for the provided dataset using the Locator member of this class
        The surface flag allow to manage surfaces datasets for surface
        interaction instead of flow datasets surface_flat_index, used only
        with composite surface, in order to identify the flat_index of the
        surface for particle interaction
        """
        ret = self._wrap_call(self._vtk_obj.ClearDataSets, *args)
        return ret

    def finalize_outputs(self, *args):
        """
        V.finalize_outputs(PolyData, DataObject) -> bool
        C++: virtual bool FinalizeOutputs(
            PolyData *particlePathsOutput,
            DataObject *interractionOutput)
        Enable model post process on output Return true if successful,
        false otherwise Empty and Always return true with basic model
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FinalizeOutputs, *my_args)
        return ret

    def finalize_threaded_data(self, *args):
        """
        V.finalize_threaded_data(LagrangianThreadedData)
        C++: virtual void FinalizeThreadedData(
            LagrangianThreadedData *data)
        Let the model finalize and deallocate a user data at thread level
        This method is called serially for each thread and does not
        require to be thread safe.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FinalizeThreadedData, *my_args)
        return ret

    def initialize_interaction_data(self, *args):
        """
        V.initialize_interaction_data(FieldData)
        C++: virtual void InitializeInteractionData(FieldData *data)
        Method used by the LPT to initialize data insertion in the
        provided FieldData. It initializes Interaction. Reimplement as
        needed in acccordance with insert_interaction_data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeInteractionData, *my_args)
        return ret

    def initialize_particle_data(self, *args):
        """
        V.initialize_particle_data(FieldData, int)
        C++: virtual void InitializeParticleData(
            FieldData *particleData, int maxTuples=0)
        Method used by the LPT to initialize data insertion in the
        provided FieldData. It initializes step_number,
        particle_velocity, integration_time. Reimplement as needed in
        acccordance with insert_particle_data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeParticleData, *my_args)
        return ret

    def initialize_path_data(self, *args):
        """
        V.initialize_path_data(FieldData)
        C++: virtual void InitializePathData(FieldData *data)
        Method used by the LPT to initialize data insertion in the
        provided FieldData. It initializes Id, parent_id, seed_id and
        Termination. Reimplement as needed in acccordance with
        insert_path_data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializePathData, *my_args)
        return ret

    def initialize_threaded_data(self, *args):
        """
        V.initialize_threaded_data(LagrangianThreadedData)
        C++: virtual void InitializeThreadedData(
            LagrangianThreadedData *data)
        Let the model allocate and initialize a threaded data. This
        method is thread-safe, its reimplementation should still be
        thread-safe.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeThreadedData, *my_args)
        return ret

    def set_input_array_to_process(self, *args):
        """
        V.set_input_array_to_process(int, int, int, int, string)
        C++: virtual void SetInputArrayToProcess(int idx, int port,
            int connection, int fieldAssociation, const char *name)
        Set a input array to process at a specific index, identified by a
        port, connection, field_association and a name. Each inherited
        class can specify their own input array to process
        """
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *args)
        return ret

    def set_tracker(self, *args):
        """
        V.set_tracker(LagrangianParticleTracker)
        C++: virtual void SetTracker(
            LagrangianParticleTracker *Tracker)
        Set the parent tracker.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTracker, *my_args)
        return ret

    _updateable_traits_ = \
    (('non_planar_quad_support', 'GetNonPlanarQuadSupport'),
    ('use_initial_integration_time', 'GetUseInitialIntegrationTime'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('locators_built', 'GetLocatorsBuilt'),
    ('number_of_tracked_user_data', 'GetNumberOfTrackedUserData'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'non_planar_quad_support',
    'use_initial_integration_time', 'locators_built',
    'number_of_tracked_user_data'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LagrangianBasicIntegrationModel, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LagrangianBasicIntegrationModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['non_planar_quad_support', 'use_initial_integration_time'], [],
            ['locators_built', 'number_of_tracked_user_data']),
            title='Edit LagrangianBasicIntegrationModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LagrangianBasicIntegrationModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

