# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class CollisionDetectionFilter(PolyDataAlgorithm):
    """
    CollisionDetectionFilter - performs collision determination
    between two polyhedral surfaces
    
    Superclass: PolyDataAlgorithm
    
    CollisionDetectionFilter performs collision determination between
     two polyhedral surfaces using two instances of OBBTree. Set the
     polydata inputs, the tolerance and transforms or matrices. If
     collision_mode is set to all_contacts, the Contacts output will be
    lines
     of contact.  If collision_mode is first_contact or half_contacts then
    the
     Contacts output will be vertices.  See below for an explanation of
     these options.
    
    
     This class can be used to clip one polydata surface with another,
     using the Contacts output as a loop set in SelectPolyData
    
    @authors Goodwin Lawlor, Bill Lorensen
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCollisionDetectionFilter, obj, update, **traits)
    
    generate_scalars = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _generate_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateScalars,
                        self.generate_scalars_)

    collision_mode = tvtk_base.RevPrefixMap({'all_contacts': 0, 'first_contact': 1, 'half_contacts': 2}, default_value='all_contacts', desc=\
        """
        Set the collision mode to VTK_ALL_CONTACTS to find all the
        contacting cell pairs with two points per collision, or
        VTK_HALF_CONTACTS to find all the contacting cell pairs with one
        point per collision, or VTK_FIRST_CONTACT to quickly find the
        first contact point.
        """
    )

    def _collision_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCollisionMode,
                        self.collision_mode_)

    box_tolerance = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _box_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoxTolerance,
                        self.box_tolerance)

    cell_tolerance = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _cell_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellTolerance,
                        self.cell_tolerance)

    def get_input_data(self, *args):
        """
        V.get_input_data(int) -> PolyData
        C++: PolyData *GetInputData(int i)
        Set and Get the input vtk polydata models
        """
        ret = self._wrap_call(self._vtk_obj.GetInputData, *args)
        return wrap_vtk(ret)

    def set_input_data(self, *args):
        """
        V.set_input_data(int, PolyData)
        C++: void SetInputData(int i, PolyData *model)
        Set and Get the input vtk polydata models
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    def get_matrix(self, *args):
        """
        V.get_matrix(int) -> Matrix4x4
        C++: Matrix4x4 *GetMatrix(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetMatrix, *args)
        return wrap_vtk(ret)

    def set_matrix(self, *args):
        """
        V.set_matrix(int, Matrix4x4)
        C++: void SetMatrix(int i, Matrix4x4 *matrix)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMatrix, *my_args)
        return ret

    number_of_cells_per_node = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_cells_per_node_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfCellsPerNode,
                        self.number_of_cells_per_node)

    opacity = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOpacity,
                        self.opacity)

    def get_transform(self, *args):
        """
        V.get_transform(int) -> LinearTransform
        C++: LinearTransform *GetTransform(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetTransform, *args)
        return wrap_vtk(ret)

    def set_transform(self, *args):
        """
        V.set_transform(int, LinearTransform)
        C++: void SetTransform(int i, LinearTransform *transform)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTransform, *my_args)
        return ret

    def get_contact_cells(self, *args):
        """
        V.get_contact_cells(int) -> IdTypeArray
        C++: IdTypeArray *GetContactCells(int i)
        Get an array of the contacting cells. This is a convenience
        method to access the "_contact_cells" field array in outputs 0 and
        1. These arrays index contacting cells (eg) index 50 of array 0
        points to a cell (triangle) which contacts/intersects a cell at
        index 50 of array 1. This method is equivalent to
        get_output(i)->_get_field_data()->_get_array("_contact_cells")
        """
        ret = self._wrap_call(self._vtk_obj.GetContactCells, *args)
        return wrap_vtk(ret)

    def _get_contacts_output(self):
        return wrap_vtk(self._vtk_obj.GetContactsOutput())
    contacts_output = traits.Property(_get_contacts_output, desc=\
        """
        Get the output with the points where the contacting cells
        intersect. This method is is equivalent to
        get_output_port(_2)/_get_output(_2)
        """
    )

    def _get_contacts_output_port(self):
        return wrap_vtk(self._vtk_obj.GetContactsOutputPort())
    contacts_output_port = traits.Property(_get_contacts_output_port, desc=\
        """
        Get the output with the points where the contacting cells
        intersect. This method is is equivalent to
        get_output_port(_2)/_get_output(_2)
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_box_tests(self):
        return self._vtk_obj.GetNumberOfBoxTests()
    number_of_box_tests = traits.Property(_get_number_of_box_tests, desc=\
        """
        
        """
    )

    def _get_number_of_contacts(self):
        return self._vtk_obj.GetNumberOfContacts()
    number_of_contacts = traits.Property(_get_number_of_contacts, desc=\
        """
        
        """
    )

    def intersect_polygon_with_polygon(self, *args):
        """
        V.intersect_polygon_with_polygon(int, [float, ...], [float, float,
            float, float, float, float], int, [float, ...], [float, float,
             float, float, float, float], float, [float, float], [float,
            float, float], int) -> int
        C++: int IntersectPolygonWithPolygon(int npts, double *pts,
            double bounds[6], int npts2, double *pts2, double bounds2[6],
            double tol2, double x1[2], double x2[3], int CollisionMode)
        Description: Intersect two polygons, return x1 and x2 as the two
        points of intersection. If collision_mode = VTK_ALL_CONTACTS, both
        contact points are found. If collision_mode = VTK_FIRST_CONTACT or
        VTK_HALF_CONTACTS, only one contact point is found.
        """
        ret = self._wrap_call(self._vtk_obj.IntersectPolygonWithPolygon, *args)
        return ret

    _updateable_traits_ = \
    (('generate_scalars', 'GetGenerateScalars'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('collision_mode', 'GetCollisionMode'),
    ('box_tolerance', 'GetBoxTolerance'), ('cell_tolerance',
    'GetCellTolerance'), ('number_of_cells_per_node',
    'GetNumberOfCellsPerNode'), ('opacity', 'GetOpacity'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_scalars',
    'global_warning_display', 'release_data_flag', 'collision_mode',
    'box_tolerance', 'cell_tolerance', 'number_of_cells_per_node',
    'opacity', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CollisionDetectionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CollisionDetectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_scalars'], ['collision_mode'], ['box_tolerance',
            'cell_tolerance', 'number_of_cells_per_node', 'opacity']),
            title='Edit CollisionDetectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CollisionDetectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

