# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GLTFDocumentLoader(Object):
    """
    GLTFDocumentLoader - Deserialize a GLTF model file.
    
    Superclass: Object
    
    GLTFDocument loader is an internal utility class which defines
    data structures and functions with the purpose of deserializing a
    gl_tf model from a gl_tf file, loading its data from binary buffers and
    creating vtk objects with the extracted geometry. It contains an
    internal Model structure into which all loading is performed.
    
    The GL Transmission Format (gl_tf) is an API-neutral runtime asset
    delivery format. A gl_tf asset is represented by:
    - A JSON-formatted file (.gltf) containing a full scene description:
      node hierarchy, materials, cameras, as well as descriptor
      information for meshes, animations, and other constructs
    - Binary files (.bin) containing geometry and animation data, and
      other buffer-based data
    - Image files (.jpg, .png) for textures
    
    For the full specification, see:
    https://github.com/_khronos_group/gl_tf/tree/master/specification/_2._0
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFDocumentLoader, obj, update, **traits)
    
    def get_number_of_components_for_type(self, *args):
        """
        V.get_number_of_components_for_type(GLTFDocumentLoader.AccessorType)
             -> int
        C++: static unsigned int GetNumberOfComponentsForType(
            GLTFDocumentLoader::AccessorType type)
        Returns the number of components for a given accessor type.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfComponentsForType, *args)
        return ret

    def _get_supported_extensions(self):
        return self._vtk_obj.GetSupportedExtensions()
    supported_extensions = traits.Property(_get_supported_extensions, desc=\
        """
        Get the list of extensions that are supported by this loader
        """
    )

    def _get_used_extensions(self):
        return self._vtk_obj.GetUsedExtensions()
    used_extensions = traits.Property(_get_used_extensions, desc=\
        """
        Get the list of extensions that are used by the current model
        """
    )

    def apply_animation(self, *args):
        """
        V.apply_animation(float, int, bool) -> bool
        C++: bool ApplyAnimation(float t, int animationId,
            bool forceStep=false)
        Apply the specified animation, at the specified time, to the
        internal Model. Changes node transforms and morphing weights.
        """
        ret = self._wrap_call(self._vtk_obj.ApplyAnimation, *args)
        return ret

    def build_model_vtk_geometry(self):
        """
        V.build_model_vtk_geometry() -> bool
        C++: bool BuildModelVTKGeometry()
        Converts the internal Model's loaded data into more convenient
        vtk objects.
        """
        ret = self._vtk_obj.BuildModelVTKGeometry()
        return ret
        

    def load_model_meta_data_from_file(self, *args):
        """
        V.load_model_meta_data_from_file(string) -> bool
        C++: bool LoadModelMetaDataFromFile(std::string FileName)
        Reset internal Model struct, and serialize gl_tf metadata (all
        json information) into it. To load buffers, use load_model_data
        """
        ret = self._wrap_call(self._vtk_obj.LoadModelMetaDataFromFile, *args)
        return ret

    def reset_animation(self, *args):
        """
        V.reset_animation(int)
        C++: void ResetAnimation(int animationId)
        Restore the transforms that were modified by an animation to
        their initial state
        """
        ret = self._wrap_call(self._vtk_obj.ResetAnimation, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFDocumentLoader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFDocumentLoader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

