# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class PointOccupancyFilter(ImageAlgorithm):
    """
    PointOccupancyFilter - produce occupancy bit mask from input point
    cloud
    
    Superclass: ImageAlgorithm
    
    PointOccupancyFilter is a filter that generates an occupancy mask
    on a volume from a point cloud. The output of the filter is an
    image/volume that indicates for each pixel/voxel whether a point
    exists within the pixel/voxel.
    
    To use this filter, specify an input of type PointSet (i.e., has
    an explicit representation of points). Then define the occupancy
    volume by specifying the sample dimensions and bounds. Optionally you
    can specify unsigned char values used to indicate whether a voxel is
    empty or occupied.
    
    @warning
    During processing, if a point is found to be outside of the occupancy
    volume, then it is skipped (i.e., it does not affect the occupancy
    mask).
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    PointDensityFilter PointMaskFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPointOccupancyFilter, obj, update, **traits)
    
    empty_value = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set / get the values indicating whether a voxel is empty (i.e.,
        does not contain any points) or occupied. By default, an empty
        voxel has a zero value; an occupied voxel has a value of one.
        """
    )

    def _empty_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEmptyValue,
                        self.empty_value)

    model_bounds = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), cols=3, desc=\
        """
        
        """
    )

    def _model_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetModelBounds,
                        self.model_bounds)

    occupied_value = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set / get the values indicating whether a voxel is empty (i.e.,
        does not contain any points) or occupied. By default, an empty
        voxel has a zero value; an occupied voxel has a value of one.
        """
    )

    def _occupied_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOccupiedValue,
                        self.occupied_value)

    sample_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(100, 100, 100), cols=3, desc=\
        """
        Set / get the dimensions of the occupancy volume. Higher values
        generally produce better results but may be much slower.
        """
    )

    def _sample_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSampleDimensions,
                        self.sample_dimensions)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('empty_value',
    'GetEmptyValue'), ('model_bounds', 'GetModelBounds'),
    ('occupied_value', 'GetOccupiedValue'), ('sample_dimensions',
    'GetSampleDimensions'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'empty_value', 'model_bounds', 'occupied_value',
    'progress_text', 'sample_dimensions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PointOccupancyFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PointOccupancyFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['empty_value', 'model_bounds', 'occupied_value',
            'sample_dimensions']),
            title='Edit PointOccupancyFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PointOccupancyFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

