# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class ImageQuantizeRGBToIndex(ImageAlgorithm):
    """
    ImageQuantizeRGBToIndex - generalized histograms up to 4 dimensions
    
    Superclass: ImageAlgorithm
    
    ImageQuantizeRGBToIndex takes a 3 component RGB image as input and
    produces a one component index image as output, along with a lookup
    table that contains the color definitions for the index values. This
    filter works on the entire input extent - it does not perform
    streaming, and it does not supported threaded execution (because it
    has to process the entire image).
    
    To use this filter, you typically set the number of colors (between 2
    and 65536), execute it, and then retrieve the lookup table. The
    colors can then be using the lookup table and the image index.
    
    This filter can run faster, by initially sampling the colors at a
    coarser level. This can be specified by the sampling_rate parameter.
    
    The "index-image" viewed as a greyscale image, is usually quite
    arbitrary, accentuating contrast where none can be perceived in the
    original color image. To make the index image more meaningful (e.g.
    for image segmentation operating on scalar images), we sort the mean
    colors by luminance and re-map the indices accordingly. This option
    does not introduce any computational complexity and has no impact on
    actual colors in the lookup table (only their order).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageQuantizeRGBToIndex, obj, update, **traits)
    
    sort_index_by_luminance = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _sort_index_by_luminance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSortIndexByLuminance,
                        self.sort_index_by_luminance_)

    build_tree_execute_time = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        For internal use only - set the times for execution
        """
    )

    def _build_tree_execute_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBuildTreeExecuteTime,
                        self.build_tree_execute_time)

    initialize_execute_time = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        For internal use only - set the times for execution
        """
    )

    def _initialize_execute_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInitializeExecuteTime,
                        self.initialize_execute_time)

    lookup_index_execute_time = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        For internal use only - set the times for execution
        """
    )

    def _lookup_index_execute_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLookupIndexExecuteTime,
                        self.lookup_index_execute_time)

    number_of_colors = traits.Trait(256, traits.Range(2, 65536, enter_set=True, auto_set=False), desc=\
        """
        Set / Get the number of color index values to produce - must be a
        number between 2 and 65536.
        """
    )

    def _number_of_colors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfColors,
                        self.number_of_colors)

    sampling_rate = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(1, 1, 1), cols=3, desc=\
        """
        
        """
    )

    def _sampling_rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSamplingRate,
                        self.sampling_rate)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_input_type(self):
        return self._vtk_obj.GetInputType()
    input_type = traits.Property(_get_input_type, desc=\
        """
        For internal use only - get the type of the image
        """
    )

    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    lookup_table = traits.Property(_get_lookup_table, desc=\
        """
        Get the resulting lookup table that contains the color
        definitions corresponding to the index values in the output
        image.
        """
    )

    _updateable_traits_ = \
    (('sort_index_by_luminance', 'GetSortIndexByLuminance'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('build_tree_execute_time', 'GetBuildTreeExecuteTime'),
    ('initialize_execute_time', 'GetInitializeExecuteTime'),
    ('lookup_index_execute_time', 'GetLookupIndexExecuteTime'),
    ('number_of_colors', 'GetNumberOfColors'), ('sampling_rate',
    'GetSamplingRate'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'sort_index_by_luminance',
    'build_tree_execute_time', 'initialize_execute_time',
    'lookup_index_execute_time', 'number_of_colors', 'progress_text',
    'sampling_rate'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageQuantizeRGBToIndex, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageQuantizeRGBToIndex properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['sort_index_by_luminance'], [], ['build_tree_execute_time',
            'initialize_execute_time', 'lookup_index_execute_time',
            'number_of_colors', 'sampling_rate']),
            title='Edit ImageQuantizeRGBToIndex properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageQuantizeRGBToIndex properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

