# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_tree import DataObjectTree


class PartitionedDataSetCollection(DataObjectTree):
    """
    PartitionedDataSetCollection - Composite dataset that groups
    datasets as a collection.
    
    Superclass: DataObjectTree
    
    PartitionedDataSetCollection is a CompositeDataSet that stores
    a collection of PartitionedDataSets. These items can represent
    different concepts depending on the context. For example, they can
    represent region of different materials in a simulation or parts in
    an assembly. It is not requires that items have anything in common.
    For example, they can have completely different point or cell arrays.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionedDataSetCollection, obj, update, **traits)
    
    number_of_partitioned_data_sets = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the number of blocks. This will cause allocation if the new
        number of blocks is greater than the current size. All new blocks
        are initialized to null.
        """
    )

    def _number_of_partitioned_data_sets_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPartitionedDataSets,
                        self.number_of_partitioned_data_sets)

    def get_partitioned_data_set(self, *args):
        """
        V.get_partitioned_data_set(int) -> PartitionedDataSet
        C++: PartitionedDataSet *GetPartitionedDataSet(
            unsigned int idx)
        Returns the block at the given index. It is recommended that one
        uses the iterators to iterate over composite datasets rather than
        using this API.
        """
        ret = self._wrap_call(self._vtk_obj.GetPartitionedDataSet, *args)
        return wrap_vtk(ret)

    def set_partitioned_data_set(self, *args):
        """
        V.set_partitioned_data_set(int, PartitionedDataSet)
        C++: void SetPartitionedDataSet(unsigned int idx,
            PartitionedDataSet *dataset)
        Sets the data object as the given block. The total number of
        blocks will be resized to fit the requested block no.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPartitionedDataSet, *my_args)
        return ret

    def remove_partitioned_data_set(self, *args):
        """
        V.remove_partitioned_data_set(int)
        C++: void RemovePartitionedDataSet(unsigned int idx)
        Remove the given block from the dataset.
        """
        ret = self._wrap_call(self._vtk_obj.RemovePartitionedDataSet, *args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_partitioned_data_sets', 'GetNumberOfPartitionedDataSets'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'number_of_partitioned_data_sets'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionedDataSetCollection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [],
            ['number_of_partitioned_data_sets']),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

