# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class VolumeTexture(Object):
    """
    VolumeTexture - Creates and manages the volume texture rendered by
    OpenGLGPUVolumeRayCastMapper.
    
    Superclass: Object
    
    Wraps a TextureObject for which it selects the appropriate format
    (depending on the input DataArray type, number of components,
    etc.) and loads input data. The class maintains a set of members of
    interest to the parent mapper, such as:
    
    * Active DataArray scalar range.
    * Volume's scale and bias (pixel transfer functions).
    * handle_large_data_type flag.
    * Texture to data transformations.
    * Block extents
    * Block loaded bounds
    
    This class supports streaming the volume data in separate blocks to
    make it fit in graphics memory (sometimes referred to as bricking).
    The data is split into a user-defined number of blocks in such a way
    that a single sub-block (brick) fits completely into GPU memory.  A
    stride is passed to open_gl so that it can access the underlying
    DataArray adequately for each of the blocks to be streamed into
    GPU memory (back-to-front for correct composition).
    
    Streaming the volume as separate texture bricks certainly imposes a
    performance trade-off but acts as a graphics memory expansion scheme
    for devices that would not be able to render higher resoulution
    volumes otherwise.
    
    @warning There are certain caveats when texture streaming is enabled,
    given
    the locality constraint that rendering a single block imposes.
    
    - Quality might suffer near the block seams with shade_on() (gradient
      computation at the boundaries needs adjustment).
    
    - Not all of the features supported by the mapper currently work
      correctly. This is a list of known issues:
    -# Blending modes such as average and additive might compute a
       different value near the edges.
    
    - Future work will extend the API to be able to compute an ideal
      number of partitions and extents based on the platform
      capabilities.
    
    @warning This is an internal class of
        OpenGLGPUVolumeRayCastMapper. It
    assumes there is an active open_gl context in methods involving GL
    calls (_make_current() is expected to be called in the mapper
    beforehand).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVolumeTexture, obj, update, **traits)
    
    def _get_loaded_scalars(self):
        return wrap_vtk(self._vtk_obj.GetLoadedScalars())
    loaded_scalars = traits.Property(_get_loaded_scalars, desc=\
        """
        
        """
    )

    def get_scale_and_bias(self, *args):
        """
        V.get_scale_and_bias(int, [float, ...], float, float)
        C++: static void GetScaleAndBias(const int scalarType,
            float *scalarRange, float &scale, float &bias)
        Get the scale and bias values given a VTK scalar type and a
        finite range. The scale and bias values computed using this
        method can be useful for custom shader code. For example, when
        looking up color values through the transfer function texture,
        the scalar value must be scaled and offset.
        """
        ret = self._wrap_call(self._vtk_obj.GetScaleAndBias, *args)
        return ret

    def load_volume(self, *args):
        """
        V.load_volume(Renderer, ImageData, DataArray, int, int)
            -> bool
        C++: bool LoadVolume(Renderer *ren, ImageData *data,
            DataArray *scalars, int const isCell,
            int const interpolation)
        Loads the data array into the texture in the case only a single
        block is is defined. Does not load when the input data is divided
        in multiple blocks (in which case they will be loaded into GPU
        memory by get_next_block()). Requires an active open_gl context.
        """
        my_args = deref_array(args, [('vtkRenderer', 'vtkImageData', 'vtkDataArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.LoadVolume, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        V.release_graphics_resources(Window)
        C++: void ReleaseGraphicsResources(Window *win)
        Clean-up acquired graphics resources.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def sort_blocks_back_to_front(self, *args):
        """
        V.sort_blocks_back_to_front(Renderer, Matrix4x4)
        C++: void SortBlocksBackToFront(Renderer *ren,
            Matrix4x4 *volumeMat)
        If streaming the data array as separate blocks, sort them back to
        front. This method does nothing if there is a single block.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SortBlocksBackToFront, *my_args)
        return ret

    def update_volume(self, *args):
        """
        V.update_volume(VolumeProperty)
        C++: void UpdateVolume(VolumeProperty *property)
        It currently only calls set_interpolation internally. Requires an
        active open_gl context.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateVolume, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VolumeTexture, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VolumeTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit VolumeTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VolumeTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

