# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ScalarsToTextureFilter(PolyDataAlgorithm):
    """
    ScalarsToTextureFilter - generate texture coordinates and a
    texture image based on a scalar field
    
    Superclass: PolyDataAlgorithm
    
    This filter computes texture coordinates and a 2d texture image based
    on a polydata, a color transfer function and an array. The output
    port 0 will contain the input polydata with computed texture
    coordinates. The output port 1 will contain the texture. The computed
    texture coordinates is based on TextureMapToPlane which computes
    them using 3d positions projected on the best fitting plane.
    @sa TextureMapToPlane ResampleToImage
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkScalarsToTextureFilter, obj, update, **traits)
    
    use_transfer_function = tvtk_base.true_bool_trait(desc=\
        """
        Specify if a new point array containing RGBA values have to be
        computed by the specified color transfer function.
        """
    )

    def _use_transfer_function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseTransferFunction,
                        self.use_transfer_function_)

    texture_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int64", value=(128, 128), cols=2, desc=\
        """
        
        """
    )

    def _texture_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureDimensions,
                        self.texture_dimensions)

    def _get_transfer_function(self):
        return wrap_vtk(self._vtk_obj.GetTransferFunction())
    def _set_transfer_function(self, arg):
        old_val = self._get_transfer_function()
        self._wrap_call(self._vtk_obj.SetTransferFunction,
                        deref_vtk(arg))
        self.trait_property_changed('transfer_function', old_val, arg)
    transfer_function = traits.Property(_get_transfer_function, _set_transfer_function, desc=\
        """
        Set/Get a color transfer function. This transfer function will be
        used to determine the pixel colors of the texture. If not
        specified, the filter use a default one (blue/white/red) based on
        the range of the input array.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('use_transfer_function', 'GetUseTransferFunction'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('texture_dimensions', 'GetTextureDimensions'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_transfer_function', 'progress_text',
    'texture_dimensions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ScalarsToTextureFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ScalarsToTextureFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_transfer_function'], [], ['texture_dimensions']),
            title='Edit ScalarsToTextureFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ScalarsToTextureFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

