# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class LagrangeTetra(NonLinearCell):
    """
    LagrangeTetra - A 3d cell that represents an arbitrary order
    Lagrange tetrahedron
    
    Superclass: NonLinearCell
    
    LagrangeTetra is a concrete implementation of Cell to represent
    a 3d tetrahedron using Lagrange shape functions of user specified
    order.
    
    The number of points in a Lagrange cell determines the order over
    which they are iterated relative to the parametric coordinate system
    of the cell. The first points that are reported are vertices. They
    appear in the same order in which they would appear in linear cells.
    Mid-edge points are reported next. They are reported in sequence. For
    two- and three-dimensional (_3d) cells, the following set of points to
    be reported are face points. Finally, 3d cells report points interior
    to their volume.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLagrangeTetra, obj, update, **traits)
    
    def _get_order(self):
        return self._vtk_obj.GetOrder()
    order = traits.Property(_get_order, desc=\
        """
        
        """
    )

    def barycentric_index(self, *args):
        """
        V.barycentric_index(int, [int, ...], int)
        C++: static void BarycentricIndex(IdType index,
            IdType *bindex, IdType order)"""
        ret = self._wrap_call(self._vtk_obj.BarycentricIndex, *args)
        return ret

    def compute_order(self):
        """
        V.compute_order() -> int
        C++: IdType ComputeOrder()"""
        ret = self._vtk_obj.ComputeOrder()
        return ret
        

    def index(self, *args):
        """
        V.index((int, ...), int) -> int
        C++: static IdType Index(const IdType *bindex,
            IdType order)"""
        ret = self._wrap_call(self._vtk_obj.Index, *args)
        return ret

    def maximum_number_of_points(self):
        """
        V.maximum_number_of_points() -> int
        C++: static int MaximumNumberOfPoints()"""
        ret = self._vtk_obj.MaximumNumberOfPoints()
        return ret
        

    def maximum_order(self):
        """
        V.maximum_order() -> int
        C++: static int MaximumOrder()"""
        ret = self._vtk_obj.MaximumOrder()
        return ret
        

    def to_barycentric_index(self, *args):
        """
        V.to_barycentric_index(int, [int, ...])
        C++: void ToBarycentricIndex(IdType index, IdType *bindex)"""
        ret = self._wrap_call(self._vtk_obj.ToBarycentricIndex, *args)
        return ret

    def to_index(self, *args):
        """
        V.to_index((int, ...)) -> int
        C++: IdType ToIndex(const IdType *bindex)"""
        ret = self._wrap_call(self._vtk_obj.ToIndex, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LagrangeTetra, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LagrangeTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit LagrangeTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LagrangeTetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

