# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLGL2PSHelper(Object):
    """
    OpenGLGL2PSHelper - Access gl2ps functionality.
    
    Superclass: Object
    
    This class provides convenience functions that can be used to draw
    into a gl2ps context. Link to RenderingGL2PSOpenGL2 to bring in
    the OpenGLGL2PSHelperImpl class, the object factory override that
    implements this interface.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLGL2PSHelper, obj, update, **traits)
    
    def _get_instance(self):
        return wrap_vtk(self._vtk_obj.GetInstance())
    def _set_instance(self, arg):
        old_val = self._get_instance()
        self._wrap_call(self._vtk_obj.SetInstance,
                        deref_vtk(arg))
        self.trait_property_changed('instance', old_val, arg)
    instance = traits.Property(_get_instance, _set_instance, desc=\
        """
        The global instance. Only set during export.
        """
    )

    line_stipple = traits.Int(65535, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the current line stipple pattern per open_gl convention.
        Default is 0xffff.
        """
    )

    def _line_stipple_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineStipple,
                        self.line_stipple)

    line_width = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the current line width.
        """
    )

    def _line_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineWidth,
                        self.line_width)

    point_size = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the current point size.
        """
    )

    def _point_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointSize,
                        self.point_size)

    def _get_active_state(self):
        return self._vtk_obj.GetActiveState()
    active_state = traits.Property(_get_active_state, desc=\
        """
        Get the current export state. Vector images are rendered in two
        passes: First, all non-vectorizable props are rendered, and the
        resulting image is inserted as a raster image into the background
        of the exported file (_active_state == Background). Next, all
        vectorizable props are drawn and captured into gl2ps, where they
        are drawn over the background image. Vectorizable props should
        not draw themselves during the background pass, and use the
        OpenGLGL2PSHelper API to draw themselves during the capture
        pass.
        """
    )

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    render_window = traits.Property(_get_render_window, desc=\
        """
        Get the renderwindow that's being exported.
        """
    )

    def draw3d_path(self, *args):
        """
        V.draw3d_path(Path, Matrix4x4, [float, float, float], [int,
            int, int, int], Renderer, string)
        C++: virtual void Draw3DPath(Path *path,
            Matrix4x4 *actorMatrix, double rasterPos[3],
            unsigned char actorColor[4], Renderer *ren,
            const char *label=nullptr)
        Transform the path using the actor's matrix and current GL state,
        then draw it to gl2ps. The label string is inserted into the
        gl2ps output at the beginning of the path specification as a
        comment on supported backends.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Draw3DPath, *my_args)
        return ret

    def draw_image(self, *args):
        """
        V.draw_image(ImageData, [float, float, float])
        C++: virtual void DrawImage(ImageData *image, double pos[3])
        Draw the image at pos. Image must be RGB or RGBA with float
        scalars.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawImage, *my_args)
        return ret

    def draw_path(self, *args):
        """
        V.draw_path(Path, [float, float, float], [float, float], [int,
            int, int, int], [float, float], float, float, string)
        C++: virtual void DrawPath(Path *path, double rasterPos[3],
            double windowPos[2], unsigned char rgba[4],
            double scale[2]=nullptr, double rotateAngle=0.0,
            float strokeWidth=-1, const char *label=nullptr)
        Generate PS, EPS, or SVG markup from a Path object, and then
        inject it into the output using the gl_2ps_special command. The
        path is translated uniformly in the scene by window_pos. It is
        scaled by scale and rotated counter-clockwise by rotate_angle. The
        raster_pos is in world coordinates and determines clipping and
        depth. If scale is NULL, no scaling is done. If stroke_width is
        positive, the path will be stroked with the indicated width. If
        zero or negative, the path will be filled (default). The label
        string is inserted into the gl2ps output at the beginning of the
        path specification as a comment on supported backends.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawPath, *my_args)
        return ret

    def draw_string(self, *args):
        """
        V.draw_string(string, TextProperty, [float, float, float],
            float, Renderer)
        C++: virtual void DrawString(const std::string &str,
            TextProperty *tprop, double pos[3], double backgroundDepth,
             Renderer *ren)
        Format the text in str according to tprop and instruct gl2ps to
        draw it at pixel coordinate pos. Background depth is the z value
        for the background quad, and should be in NDC space. The drawing
        is always done in the overlay plane.
        @sa text_as_path
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawString, *my_args)
        return ret

    def process_transform_feedback(self, *args):
        """
        V.process_transform_feedback(TransformFeedback, Renderer,
            Actor)
        C++: virtual void ProcessTransformFeedback(
            TransformFeedback *tfc, Renderer *ren, Actor *act)
        V.process_transform_feedback(TransformFeedback, Renderer,
            [int, int, int, int])
        C++: virtual void ProcessTransformFeedback(
            TransformFeedback *tfc, Renderer *ren,
            unsigned char col[4])
        V.process_transform_feedback(TransformFeedback, Renderer,
            [float, float, float, float])
        C++: virtual void ProcessTransformFeedback(
            TransformFeedback *tfc, Renderer *ren, float col[4])
        Parse the vertex information in tfc and inject primitives into
        gl2ps. ren is used to obtain viewport information to complete the
        vertex transformation into pixel coordinates, and act/col are
        used to color the vertices when tfc does not contain color
        information.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ProcessTransformFeedback, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('line_stipple', 'GetLineStipple'),
    ('line_width', 'GetLineWidth'), ('point_size', 'GetPointSize'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'line_stipple', 'line_width',
    'point_size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLGL2PSHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLGL2PSHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['line_stipple', 'line_width', 'point_size']),
            title='Edit OpenGLGL2PSHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLGL2PSHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

