# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set import DataSet


class HyperTreeGrid(DataSet):
    """
    HyperTreeGrid - A dataset containing a grid of HyperTree
    instances arranged as a rectilinear grid.
    
    Superclass: DataSet
    
    A hypertree grid is a dataset containing a rectilinear grid of root
    nodes, each of which can be refined as a HyperTree grid. Each root
    node corresponds to a cell of the rectilinear grid. This organization
    of the root nodes allows for the definition of tree-based AMR grids
    that do not have uniform geometry. Some filters can be applied on
    this dataset: contour, outline, geometry.
    
    @warning
    It is not a spatial search object. If you are looking for this kind
    of octree see CellLocator instead. Extent support is not finished
    yet.
    
    @sa
    HyperTree RectilinearGrid
    
    @par Thanks: This class was written by Philippe Pebay, Joachim
    Pouderoux, and Charles Law, Kitware 2013 This class was modified by
    Guenole Harel and Jacques-Bernard Lekien 2014 This class was
    rewritten by Philippe Pebay, 2016 This work was supported by
    Commissariat a l'Energie Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGrid, obj, update, **traits)
    
    has_interface = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get presence or absence of interface
        """
    )

    def _has_interface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHasInterface,
                        self.has_interface_)

    branch_factor = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the subdivision factor in the grid refinement scheme
        """
    )

    def _branch_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBranchFactor,
                        self.branch_factor)

    dimension = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the dimensionality of the grid.
        """
    )

    def _dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimension,
                        self.dimension)

    grid_size = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(0, 0, 0), cols=3, desc=\
        """
        Set/Get the number of local cells in each direction for the
        underlying rectilinear grid dataset.
        """
    )

    def _grid_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGridSize,
                        self.grid_size)

    interface_intercepts_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get names of interface intercepts arrays
        """
    )

    def _interface_intercepts_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterfaceInterceptsName,
                        self.interface_intercepts_name)

    interface_normals_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get names of interface normal vectors arrays
        """
    )

    def _interface_normals_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterfaceNormalsName,
                        self.interface_normals_name)

    def _get_material_mask(self):
        return wrap_vtk(self._vtk_obj.GetMaterialMask())
    def _set_material_mask(self, arg):
        old_val = self._get_material_mask()
        my_arg = deref_array([arg], [['vtkBitArray']])
        self._wrap_call(self._vtk_obj.SetMaterialMask,
                        my_arg[0])
        self.trait_property_changed('material_mask', old_val, arg)
    material_mask = traits.Property(_get_material_mask, _set_material_mask, desc=\
        """
        Set/Get the blanking mask of primal leaf cells
        """
    )

    def _get_material_mask_index(self):
        return wrap_vtk(self._vtk_obj.GetMaterialMaskIndex())
    def _set_material_mask_index(self, arg):
        old_val = self._get_material_mask_index()
        my_arg = deref_array([arg], [['vtkIdTypeArray']])
        self._wrap_call(self._vtk_obj.SetMaterialMaskIndex,
                        my_arg[0])
        self.trait_property_changed('material_mask_index', old_val, arg)
    material_mask_index = traits.Property(_get_material_mask_index, _set_material_mask_index, desc=\
        """
        Set/Get the visibility mask of primal leaf cells
        """
    )

    orientation = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the orientation of 1d or 2d grids: . in 1d: 0, 1, 2 =
        aligned along X, Y, Z axis . in 2d: 0, 1, 2 = normal to X, Y, Z
        axis NB: Not used in 3d
        """
    )

    def _orientation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrientation,
                        self.orientation)

    transposed_root_indexing = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
    )

    def _transposed_root_indexing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransposedRootIndexing,
                        self.transposed_root_indexing)

    def get_tree(self, *args):
        """
        V.get_tree(int) -> HyperTree
        C++: HyperTree *GetTree(IdType)
        Return tree located at given index of hyper tree grid NB: This
        will return nullptr if grid slot is empty.
        """
        ret = self._wrap_call(self._vtk_obj.GetTree, *args)
        return wrap_vtk(ret)

    def set_tree(self, *args):
        """
        V.set_tree(int, HyperTree)
        C++: void SetTree(IdType, HyperTree *)
        Assign given tree to given index of hyper tree grid NB: This will
        create a new slot in the grid if needed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTree, *my_args)
        return ret

    def _get_x_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetXCoordinates())
    def _set_x_coordinates(self, arg):
        old_val = self._get_x_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetXCoordinates,
                        my_arg[0])
        self.trait_property_changed('x_coordinates', old_val, arg)
    x_coordinates = traits.Property(_get_x_coordinates, _set_x_coordinates, desc=\
        """
        Set/Get the grid coordinates in the x-direction.
        """
    )

    def _get_y_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetYCoordinates())
    def _set_y_coordinates(self, arg):
        old_val = self._get_y_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetYCoordinates,
                        my_arg[0])
        self.trait_property_changed('y_coordinates', old_val, arg)
    y_coordinates = traits.Property(_get_y_coordinates, _set_y_coordinates, desc=\
        """
        Set/Get the grid coordinates in the y-direction.
        """
    )

    def _get_z_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetZCoordinates())
    def _set_z_coordinates(self, arg):
        old_val = self._get_z_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetZCoordinates,
                        my_arg[0])
        self.trait_property_changed('z_coordinates', old_val, arg)
    z_coordinates = traits.Property(_get_z_coordinates, _set_z_coordinates, desc=\
        """
        Set/Get the grid coordinates in the z-direction.
        """
    )

    def get_child_mask(self, *args):
        """
        V.get_child_mask(int) -> int
        C++: unsigned int GetChildMask(unsigned int)
        Return hard-coded bitcode correspondng to child mask Dimension 1:
        Factor 2: 0: 100, 1: 001 Factor 3: 0: 100, 1: 010, 2: 001
        Dimension 2: Factor 2: 0: 1101 0000 0, 1: 0110 0100 0 2: 0001
        0011 0, 3: 0000 0101 1 Factor 3: 0: 1101 0000 0, 1: 0100 0000 0,
        2: 0110 0100 0 3: 0001 0000 0, 4: 0000 1000 0, 5: 0000 0100 0 6:
        0001 0011 0, 7: 0000 0001 0, 8: 0000 0101 1 Dimension 3: Factor
        2: 0: 1101 1000 0110 1000 0000 0000 000, 1: 0110 1100 0011 0010
        0000 0000 000 2: 0001 1011 0000 1001 1000 0000 000, 3: 0000 1101
        1000 0010 1100 0000 000 4: 0000 0000 0110 1000 0011 0110 000, 5:
        0000 0000 0011 0010 0001 1011 000 6: 0000 0000 0000 1001 1000
        0110 110, 7: 0000 0000 0000 0010 1100 0011 011 Factor 3: 0: 1101
        1000 0110 1000 0000 0000 000 1: 0100 1000 0010 0000 0000 0000 000
        2: 0110 1100 0011 0010 0000 0000 000 3: 0001 1000 0000 1000 0000
        0000 000 4: 0000 1000 0000 0000 0000 0000 000 5: 0000 1100 0000
        0010 0000 0000 000 6: 0001 1011 0000 1001 1000 0000 000 7: 0000
        1001 0000 0000 1000 0000 000 8: 0000 1101 1000 0010 1100 0000 000
        9: 0000 0000 0110 1000 0000 0000 000 10: 0000 0000 0010 0000 0000
        0000 000 11: 0000 0000 0011 0010 0000 0000 000 12: 0000 0000 0000
        1000 0000 0000 000 13: 0000 0000 0000 0100 0000 0000 000 14: 0000
        0000 0000 0010 0000 0000 000 15: 0000 0000 0000 1001 1000 0000
        000 16: 0000 0000 0000 0000 1000 0000 000 17: 0000 0000 0000 0010
        1100 0000 000 18: 0000 0000 0110 1000 0011 0110 000 19: 0000 0000
        0010 0000 0001 0010 000 20: 0000 0000 0011 0010 0001 1011 000 21:
        0000 0000 0000 1000 0000 0110 000 22: 0000 0000 0000 0000 0000
        0010 000 23: 0000 0000 0000 0010 0000 0011 000 24: 0000 0000 0000
        1001 1000 0110 110 25: 0000 0000 0000 0000 1000 0010 010 26: 0000
        0000 0000 0010 1100 0011 011
        """
        ret = self._wrap_call(self._vtk_obj.GetChildMask, *args)
        return ret

    def get_index_from_level_zero_coordinates(self, *args):
        """
        V.get_index_from_level_zero_coordinates(int, int, int, int)
        C++: void GetIndexFromLevelZeroCoordinates(IdType &,
            unsigned int, unsigned int, unsigned int)
        Convert the Cartesian coordinates of a root in the grid to its
        global index.
        """
        ret = self._wrap_call(self._vtk_obj.GetIndexFromLevelZeroCoordinates, *args)
        return ret

    def get_level_zero_coordinates_from_index(self, *args):
        """
        V.get_level_zero_coordinates_from_index(int, int, int, int)
        C++: void GetLevelZeroCoordinatesFromIndex(IdType,
            unsigned int &, unsigned int &, unsigned int &)
        Convert the global index of a root to its Cartesian coordinates
        in the grid.
        """
        ret = self._wrap_call(self._vtk_obj.GetLevelZeroCoordinatesFromIndex, *args)
        return ret

    def _get_number_of_children(self):
        return self._vtk_obj.GetNumberOfChildren()
    number_of_children = traits.Property(_get_number_of_children, desc=\
        """
        The number of children each node can have.
        """
    )

    def _get_number_of_leaves(self):
        return self._vtk_obj.GetNumberOfLeaves()
    number_of_leaves = traits.Property(_get_number_of_leaves, desc=\
        """
        Get the number of leaves in the primal tree grid.
        """
    )

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, desc=\
        """
        Return the number of levels in an individual (primal) tree.
        """
    )

    def get_number_of_levels(self, *args):
        """
        V.get_number_of_levels(int) -> int
        C++: IdType GetNumberOfLevels(IdType)
        V.get_number_of_levels() -> int
        C++: IdType GetNumberOfLevels()
        Return the number of levels in an individual (primal) tree.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfLevels, *args)
        return ret

    def _get_number_of_trees(self):
        return self._vtk_obj.GetNumberOfTrees()
    number_of_trees = traits.Property(_get_number_of_trees, desc=\
        """
        Return the number of trees in the level 0 grid.
        """
    )

    def _get_number_of_vertices(self):
        return self._vtk_obj.GetNumberOfVertices()
    number_of_vertices = traits.Property(_get_number_of_vertices, desc=\
        """
        Get the number of vertices in the primal tree grid.
        """
    )

    def _get_pure_material_mask(self):
        return wrap_vtk(self._vtk_obj.GetPureMaterialMask())
    pure_material_mask = traits.Property(_get_pure_material_mask, desc=\
        """
        Get or create pure material mask
        """
    )

    def get_shifted_level_zero_index(self, *args):
        """
        V.get_shifted_level_zero_index(int, int, int, int) -> int
        C++: unsigned int GetShiftedLevelZeroIndex(IdType, int, int,
            int)
        Return the root index of a root cell with given index displaced.
        by a Cartesian vector in the grid. NB: No boundary checks are
        performed.
        """
        ret = self._wrap_call(self._vtk_obj.GetShiftedLevelZeroIndex, *args)
        return ret

    def DIMENSION(self):
        """
        V.dimension() -> InformationIntegerKey
        C++: static InformationIntegerKey *DIMENSION()"""
        ret = wrap_vtk(self._vtk_obj.DIMENSION())
        return ret
        

    def generate_trees(self):
        """
        V.generate_trees()
        C++: virtual void GenerateTrees()
        This method must be called once the tree settings change.
        """
        ret = self._vtk_obj.GenerateTrees()
        return ret
        

    def has_material_mask(self):
        """
        V.has_material_mask() -> bool
        C++: bool HasMaterialMask()
        Determine whether blanking mask is empty or not
        """
        ret = self._vtk_obj.HasMaterialMask()
        return ret
        

    def LEVELS(self):
        """
        V.levels() -> InformationIntegerKey
        C++: static InformationIntegerKey *LEVELS()"""
        ret = wrap_vtk(self._vtk_obj.LEVELS())
        return ret
        

    def new_cursor(self, *args):
        """
        V.new_cursor(int, bool) -> HyperTreeCursor
        C++: HyperTreeCursor *NewCursor(IdType, bool create=false)
        Create a new hyper tree cursor: an object that can traverse the
        cells of an individual hyper tree at given index. If no hyper
        tree is present at given location, then one will be created only
        if 'create' flag is true.
        """
        ret = self._wrap_call(self._vtk_obj.NewCursor, *args)
        return wrap_vtk(ret)

    def new_geometric_cursor(self, *args):
        """
        V.new_geometric_cursor(int, bool) -> HyperTreeGridCursor
        C++: HyperTreeGridCursor *NewGeometricCursor(IdType,
            bool create=false)
        Create a new hyper tree grid geometric cursor: an object that can
        traverse the cells of a hyper tree grid, starting at given tree
        root index, managing the geometric properties. If no hyper tree
        is present at given location, then one will be created only if
        'create' flag is true.
        """
        ret = self._wrap_call(self._vtk_obj.NewGeometricCursor, *args)
        return wrap_vtk(ret)

    def new_grid_cursor(self, *args):
        """
        V.new_grid_cursor(int, bool) -> HyperTreeGridCursor
        C++: HyperTreeGridCursor *NewGridCursor(IdType,
            bool create=false)
        Create a new hyper tree grid cursor: an object that can traverse
        the cells of a hyper tree grid, starting at given tree root
        index. If no hyper tree is present at given location, then one
        will be created only if 'create' flag is true.
        """
        ret = self._wrap_call(self._vtk_obj.NewGridCursor, *args)
        return wrap_vtk(ret)

    def new_moore_super_cursor(self, *args):
        """
        V.new_moore_super_cursor(int, bool) -> HyperTreeGridCursor
        C++: HyperTreeGridCursor *NewMooreSuperCursor(IdType,
            bool create=false)
        Create a new hyper tree grid Moore super cursor: an object that
        can traverse the cells of a hyper tree grid, starting at given
        tree root index, managing geometric properties and Moore
        neighborhood with basic hyper tree grid cursors. If no hyper tree
        is present at given location, then one will be created only if
        'create' flag is true.
        """
        ret = self._wrap_call(self._vtk_obj.NewMooreSuperCursor, *args)
        return wrap_vtk(ret)

    def new_von_neumann_super_cursor(self, *args):
        """
        V.new_von_neumann_super_cursor(int, bool) -> HyperTreeGridCursor
        C++: HyperTreeGridCursor *NewVonNeumannSuperCursor(IdType,
            bool create=false)
        Create a new hyper tree grid Von Neumann super cursor: an object
        that can traverse the cells of a hyper tree grid, starting at
        given tree root index, managing geometric properties and von
        Neumann neighborhood with basic hyper tree grid cursors. If no
        hyper tree is present at given location, then one will be created
        only if 'create' flag is true.
        """
        ret = self._wrap_call(self._vtk_obj.NewVonNeumannSuperCursor, *args)
        return wrap_vtk(ret)

    def ORIENTATION(self):
        """
        V.orientation() -> InformationIntegerKey
        C++: static InformationIntegerKey *ORIENTATION()"""
        ret = wrap_vtk(self._vtk_obj.ORIENTATION())
        return ret
        

    def recursively_initialize_pure_material_mask(self, *args):
        """
        V.recursively_initialize_pure_material_mask(HyperTreeGridCursor)
            -> bool
        C++: bool RecursivelyInitializePureMaterialMask(
            HyperTreeGridCursor *cursor)
        Recursively initialize pure material mask
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RecursivelyInitializePureMaterialMask, *my_args)
        return ret

    def SIZES(self):
        """
        V.sizes() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *SIZES()"""
        ret = wrap_vtk(self._vtk_obj.SIZES())
        return ret
        

    def set_grid_extent(self, *args):
        """
        V.set_grid_extent([int, int, int, int, int, int])
        C++: void SetGridExtent(int extent[6])
        V.set_grid_extent(int, int, int, int, int, int)
        C++: void SetGridExtent(int, int, int, int, int, int)
        Set/Get extent of the underlying rectilinear grid dataset. This
        is the local extent and is with respect to the points.
        """
        ret = self._wrap_call(self._vtk_obj.SetGridExtent, *args)
        return ret

    def set_indexing_mode_to_ijk(self):
        """
        V.set_indexing_mode_to_ijk()
        C++: void SetIndexingModeToIJK()
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
        ret = self._vtk_obj.SetIndexingModeToIJK()
        return ret
        

    def set_indexing_mode_to_kji(self):
        """
        V.set_indexing_mode_to_kji()
        C++: void SetIndexingModeToKJI()
        Specify whether indexing mode of grid root cells must be
        transposed to x-axis first, z-axis last, instead of the default
        z-axis first, k-axis last
        """
        ret = self._vtk_obj.SetIndexingModeToKJI()
        return ret
        

    def subdivide_leaf(self, *args):
        """
        V.subdivide_leaf(HyperTreeCursor, int)
        C++: void SubdivideLeaf(HyperTreeCursor *, IdType)
        Subdivide node pointed by cursor, only if its a leaf. At the end,
        cursor points on the node that used to be leaf.
        \pre leaf_exists: leaf!=0
        \pre is_a_leaf: leaf->_current_is_leaf()
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SubdivideLeaf, *my_args)
        return ret

    _updateable_traits_ = \
    (('has_interface', 'GetHasInterface'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('branch_factor', 'GetBranchFactor'), ('dimension', 'GetDimension'),
    ('grid_size', 'GetGridSize'), ('interface_intercepts_name',
    'GetInterfaceInterceptsName'), ('interface_normals_name',
    'GetInterfaceNormalsName'), ('orientation', 'GetOrientation'),
    ('transposed_root_indexing', 'GetTransposedRootIndexing'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'has_interface', 'branch_factor', 'dimension', 'grid_size',
    'interface_intercepts_name', 'interface_normals_name', 'orientation',
    'transposed_root_indexing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag', 'has_interface'], [],
            ['branch_factor', 'dimension', 'grid_size',
            'interface_intercepts_name', 'interface_normals_name', 'orientation',
            'transposed_root_indexing']),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

