# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class Contour3DLinearGrid(PolyDataAlgorithm):
    """
    Contour3DLinearGrid - fast generation of isosurface from 3d linear
    cells
    
    Superclass: PolyDataAlgorithm
    
    Contour3DLinearGrid is a specialized filter that generates
    isocontours from an input UnstructuredGrid consisting of 3d linear
    cells: tetrahedra, hexahedra, voxels, pyramids, and/or wedges. (The
    cells are linear in the sense that each cell edge is a straight
    line.) The filter is designed for high-speed, specialized operation.
    All other cell types are skipped and produce no output.
    
    To use this filter you must specify an input unstructured grid, and
    one or more contour values.  You can either use the method set_value()
    to specify each contour value, or use generate_values() to generate a
    series of evenly spaced contours.
    
    The filter performance varies depending on optional output
    information. Basically if point merging is required (when
    point_merging, interpolate_attributes, and/or compute_normals is
    enabled), a sorting process is required to eliminate duplicate output
    points in the isosurface. Otherwise when point merging is not
    required, a fast path process produces independent triangles
    representing the isosurface. In many situations the results of the
    fast path are quite good and do not require additional processing.
    
    @warning The fast path simply produces output points and triangles
        (the
    fast path executes when merge_points if off; interpolate_attributes is
    off; and compute_normals is off). Since the fast path does not merge
    points, it produces many more output points, typically on the order
    of 5-6x more than when merge_points is enabled. Adding in the other
    options point merging, field interpolation, and normal generation
    results in additional performance impacts. By default the fast path
    is enabled.
    
    @warning
    Internal to this filter, a caching iterator is used to traverse the
    cells that compose the UnstructuredGrid. Maximum performance is
    obtained if the cells are all of one type (i.e., input grid of
    homogeneous cell types); repeated switching from different types may
    have detrimental effects on performance.
    
    @warning
    For unstructured data, gradients are not computed. Normals are
    computed if requested; they are "pseudo-normals" in that the normals
    of output triangles that use a common point are averaged at the
    point. Alternatively use PolyDataNormals to compute the surface
    normals.
    
    @warning
    The output of this filter is subtly different than the more general
    filter ContourGrid. ContourGrid eliminates small, degenerate
    triangles with concident points which are consequently not sent to
    the output. In practice this makes little impact on visual appearance
    but may have repercussions if the output is used for modelling and/or
    analysis.
    
    @warning
    Input cells that are not of 3d linear type (tetrahedron, hexahedron,
    wedge, pyramid, and voxel) are simply skipped and not processed.
    
    @warning
    The filter is templated on types of input and output points, and
    input scalar type. To reduce object file bloat, only real points
    (float,double) are processed, and a limited subset of scalar types.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    ContourGrid ContourFilter FlyingEdges3D MarchingCubes
    PolyDataNormals StaticEdgeLocatorTemplate.h
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContour3DLinearGrid, obj, update, **traits)
    
    compute_normals = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to compute output point normals. An averaging
        method is used to average shared triangle normals. By default
        this if off. This is a relatively expensive option so use
        judiciously.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    interpolate_attributes = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to interpolate input attributes onto the
        isosurface. By default this option is off.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    merge_points = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to merge coincident points. This takes extra
        time and produces fewer output points, creating a "watertight"
        contour surface. By default this is off.
        """
    )

    def _merge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePoints,
                        self.merge_points_)

    sequential_processing = tvtk_base.false_bool_trait(desc=\
        """
        Force sequential processing (i.e. single thread) of the
        contouring process. By default, sequential processing is off.
        Note this flag only applies if the class has been compiled with
        VTK_SMP_IMPLEMENTATION_TYPE set to something other than
        Sequential. (If set to Sequential, then the filter always runs in
        serial mode.) This flag is typically used for benchmarking
        purposes.
        """
    )

    def _sequential_processing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSequentialProcessing,
                        self.sequential_processing_)

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Methods to set / get contour values.
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def get_value(self, *args):
        """
        V.get_value(int) -> float
        C++: double GetValue(int i)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        V.set_value(int, float)
        C++: void SetValue(int i, double value)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        """
        Inform the user as to whether large ids were used during filter
        execution. This flag only has meaning after the filter has
        executed. Large ids are used when the id of the larges cell or
        point is greater than signed 32-bit precision. (Smaller ids
        reduce memory usage and speed computation. Note that large_ids are
        only available on 64-bit architectures.)
        """
    )

    def _get_number_of_threads_used(self):
        return self._vtk_obj.GetNumberOfThreadsUsed()
    number_of_threads_used = traits.Property(_get_number_of_threads_used, desc=\
        """
        Return the number of threads actually used during execution. This
        is valid only after algorithm execution.
        """
    )

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        """
        Methods to set / get contour values.
        """
    )

    def get_values(self, *args):
        """
        V.get_values() -> (float, ...)
        C++: double *GetValues()
        V.get_values([float, ...])
        C++: void GetValues(double *contourValues)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def generate_values(self, *args):
        """
        V.generate_values(int, [float, float])
        C++: void GenerateValues(int numContours, double range[2])
        V.generate_values(int, float, float)
        C++: void GenerateValues(int numContours, double rangeStart,
            double rangeEnd)
        Methods to set / get contour values.
        """
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_normals', 'GetComputeNormals'), ('interpolate_attributes',
    'GetInterpolateAttributes'), ('merge_points', 'GetMergePoints'),
    ('sequential_processing', 'GetSequentialProcessing'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_contours', 'GetNumberOfContours'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normals', 'debug',
    'global_warning_display', 'interpolate_attributes', 'merge_points',
    'release_data_flag', 'sequential_processing', 'number_of_contours',
    'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Contour3DLinearGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normals', 'interpolate_attributes', 'merge_points',
            'sequential_processing'], [], ['number_of_contours',
            'output_points_precision']),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Contour3DLinearGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

