# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class SplitByCellScalarFilter(MultiBlockDataSetAlgorithm):
    """
    SplitByCellScalarFilter - splits input dataset according an
    integer cell scalar array.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    SplitByCellScalarFilter is a filter that splits any dataset type
    according an integer cell scalar value (typically a material
    identifier) to a multiblock. Each block of the output contains cells
    that have the same scalar value. Output blocks will be of type
    UnstructuredGrid except if input is of type PolyData. In that
    case output blocks are of type PolyData.
    
    @sa
    Threshold
    
    @par Thanks: This class was written by Joachim Pouderoux, Kitware
    2016.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSplitByCellScalarFilter, obj, update, **traits)
    
    pass_all_points = tvtk_base.true_bool_trait(desc=\
        """
        Specify if input points array must be passed to output blocks. If
        so, filter processing is faster but outblocks will contains more
        points than what is needed by the cells it owns. If not, a new
        points array is created for every block and it will only contains
        points for copied cells. Note that this function is only possible
        for point_set datasets. The default is true.
        """
    )

    def _pass_all_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassAllPoints,
                        self.pass_all_points_)

    _updateable_traits_ = \
    (('pass_all_points', 'GetPassAllPoints'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'pass_all_points', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SplitByCellScalarFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SplitByCellScalarFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pass_all_points'], [], []),
            title='Edit SplitByCellScalarFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SplitByCellScalarFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

