# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.frame_buffer_object_base import FrameBufferObjectBase


class OpenGLFramebufferObject(FrameBufferObjectBase):
    """
    OpenGLFramebufferObject - Internal class which encapsulates open_gl
    framebuffer_object
    
    Superclass: FrameBufferObjectBase
    
    Before delving into this class it is best to have some background in
    some open_gl terms. open_gl has a notion of a currently bound
    Framebuffers for drawing and reading. It can be the default
    framebuffer such as created with a standard window/context or it can
    be a user created Framebuffer objects. When draw and read commands
    are invoked, they apply to the current draw and/or read frambuffers.
    
    A framebuffer consists of color buffers and an optional depth buffer.
    The framebuffer_object does not hold the memory for these buffers, it
    just keeps track of what buffers are attached to it. The buffers
    themselves hold the storage for the pixels/depths.
    
    In the context of this discussion a buffer can be either a
    TextureObject (both 2d or a slice of a 3d texture) or a
    Renderbuffer. In some cases a renderbuffer may be faster or more
    lightweight but you cannot pass a renderbuffer into a shader for
    sampling in a later pass like you can a texture.
    
    You attach these buffers to the Framebuffer using methods such as
    add_color_attachment or add_depth_attachment In normal usage a buffer is
    Attached to a framebuffer_object and then some or all of the attached
    buffers are activated for drawing or reading.
    
    When you have a framebuffer bound along with some buffers attached to
    it you can then activate specific buffers for drawing or reading. So
    you have draw and read framebuffer objects (bindings) and then for
    the currently bound framebuffer_objects you have active draw and read
    buffers.
    
    A single framebuffer_object can be bound to both Draw and Read.
    Likewise a single buffer can be activated for both draw and read
    operations. You cannot assign and activate a texture_object for
    drawing on the FO and at the same time pass it in as a Texture to the
    shader program. That type of operation is very common and must be
    done in two steps.
    - Render to the FO with the Texture attached as an active buffer
    - deactivate the texture obj and then render with the texture obj as
      a texture passed into the shader
    
    Typical use cases: The simplest example{.cpp}
    fbo->_set_context(ren_win);
    fbo->_save_current_bindings_and_buffers();
    fbo->_populate_framebuffer(width, height);
    fbo->Start();
    
    ...
    
    fbo->_restore_previous_bindings_and_buffers();
    
    If you wish to use a texture you created
    
    {.cpp}
    fbo->_set_context(ren_win);
    fbo->_save_current_bindings_and_buffers();
    fbo->Bind();
    fbo->_add_color_attachment(_0, TextureObj);
    fbo->_add_depth_attachment(); // auto create depth buffer
    fbo->_activate_buffer(_0);
    fbo->Start();
    
    ...
    
    fbo->_restore_previous_bindings_and_buffers();
    
    If you will be using a FO repeatedly then it is best to create it
    attach the buffers and then use as needed for example
    
    Typical use case:{.cpp}
    // setup the FBO once
    fbo->_set_context(ren_win);
    fbo->_save_current_bindings_and_buffers();
    fbo->Bind();
    fbo->_add_color_attachment(_0, TextureObj);
    fbo->_add_depth_attachment(); // auto create depth buffer
    fbo->_restore_previous_bindings_and_buffers();
    
    // use it many times fbo->_save_current_bindings_and_buffers();
    fbo->Bind(); fbo->_activate_buffer(_0); fbo->Start(); ... // render here
    etc fbo->_restore_previous_bindings_and_buffers();
    
    If you with to only bind/attach the draw buffers or read buffers
    there are mode specific versions of most methods that only apply to
    the mode specified Draw/Read/Both. The mode argument uses open_gl
    constants so this class provides convenience methods to return them
    named get_draw_mode() get_read_mode() and get_both_mode() so that your code
    does not need to be polluted with open_gl headers/constants.
    
    This class replaces both FrameBufferObject and
    FrameBufferObject2 and contins methods from both of them. Most
    methods from FO2 should work with this class. Just rename FBO2 to FBO
    and make sure to Save and Restore the bindings and buffers. If you
    have been using the old FO class, which had comments in the header
    saying not to use it. Then you are in for a bit more of a conversion
    but generally it should still be easy. Use the code samples above (or
    any of the classes in open_gl2 that currently use FBOs) to guide you.
    They have all been converted to this class. Where previously a
    depth_buffer was automatically created for you, you now need to do it
    explicitly using add_depth_attachment().
    
    This class should be named OpenGLFramebufferObject (FO) Note the
    capitalization of framebuffer_object
    
    @sa
    TextureObject, RenderbufferObject
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLFramebufferObject, obj, update, **traits)
    
    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        """
        Get/Set the context. Context must be a OpenGLRenderWindow.
        This does not increase the reference count of the context to
        avoid reference loops. set_context() may raise an error is the
        open_gl context does not support the required open_gl extensions.
        """
    )

    def _get_both_mode(self):
        return self._vtk_obj.GetBothMode()
    both_mode = traits.Property(_get_both_mode, desc=\
        """
        
        """
    )

    def _get_draw_mode(self):
        return self._vtk_obj.GetDrawMode()
    draw_mode = traits.Property(_get_draw_mode, desc=\
        """
        
        """
    )

    def _get_maximum_number_of_active_targets(self):
        return self._vtk_obj.GetMaximumNumberOfActiveTargets()
    maximum_number_of_active_targets = traits.Property(_get_maximum_number_of_active_targets, desc=\
        """
        Returns the maximum number of targets that can be rendered to at
        one time. This limits the active targets set by
        set_active_targets(). The return value is valid only if get_context
        is non-null.
        """
    )

    def _get_maximum_number_of_render_targets(self):
        return self._vtk_obj.GetMaximumNumberOfRenderTargets()
    maximum_number_of_render_targets = traits.Property(_get_maximum_number_of_render_targets, desc=\
        """
        Returns the maximum number of render targets available. This
        limits the available attachment points for set_color_attachment().
        The return value is valid only if get_context is non-null.
        """
    )

    def get_number_of_color_attachments(self, *args):
        """
        V.get_number_of_color_attachments(int) -> int
        C++: int GetNumberOfColorAttachments(unsigned int mode)
        Return the number of color attachments for the given mode
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfColorAttachments, *args)
        return ret

    def _get_read_mode(self):
        return self._vtk_obj.GetReadMode()
    read_mode = traits.Property(_get_read_mode, desc=\
        """
        
        """
    )

    def activate_buffer(self, *args):
        """
        V.activate_buffer(int)
        C++: void ActivateBuffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateBuffer, *args)
        return ret

    def activate_draw_buffer(self, *args):
        """
        V.activate_draw_buffer(int)
        C++: void ActivateDrawBuffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateDrawBuffer, *args)
        return ret

    def activate_draw_buffers(self, *args):
        """
        V.activate_draw_buffers(int)
        C++: void ActivateDrawBuffers(unsigned int n)
        V.activate_draw_buffers([int, ...], int)
        C++: void ActivateDrawBuffers(unsigned int *ids, int n)"""
        ret = self._wrap_call(self._vtk_obj.ActivateDrawBuffers, *args)
        return ret

    def activate_read_buffer(self, *args):
        """
        V.activate_read_buffer(int)
        C++: void ActivateReadBuffer(unsigned int id)"""
        ret = self._wrap_call(self._vtk_obj.ActivateReadBuffer, *args)
        return ret

    def add_color_attachment(self, *args):
        """
        V.add_color_attachment(int, int, TextureObject, int, int, int)
        C++: void AddColorAttachment(unsigned int mode,
            unsigned int attId, TextureObject *tex,
            unsigned int zslice=0, unsigned int format=0,
            unsigned int mipmapLevel=0)
        V.add_color_attachment(int, int, Renderbuffer)
        C++: void AddColorAttachment(unsigned int mode,
            unsigned int attId, Renderbuffer *tex)
        Directly assign/remove a texture to color attachments. Same as
        the Set methods but also does an attach call so the FO has to be
        bound when called.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddColorAttachment, *my_args)
        return ret

    def add_depth_attachment(self, *args):
        """
        V.add_depth_attachment()
        C++: void AddDepthAttachment()
        V.add_depth_attachment(int)
        C++: void AddDepthAttachment(unsigned int mode)
        V.add_depth_attachment(int, TextureObject)
        C++: void AddDepthAttachment(unsigned int mode,
            TextureObject *tex)
        V.add_depth_attachment(int, Renderbuffer)
        C++: void AddDepthAttachment(unsigned int mode,
            Renderbuffer *tex)
        Directly assign/remove a texture/renderbuffer to depth
        attachments.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddDepthAttachment, *my_args)
        return ret

    def bind(self, *args):
        """
        V.bind()
        C++: void Bind()
        V.bind(int)
        C++: void Bind(unsigned int mode)
        Make the draw frame buffer active.
        """
        ret = self._wrap_call(self._vtk_obj.Bind, *args)
        return ret

    def blit(self, *args):
        """
        V.blit((int, int, int, int), (int, int, int, int), int, int)
            -> int
        C++: static int Blit(const int srcExt[4], const int destExt[4],
            unsigned int bits, unsigned int mapping)
        Copy from the currently bound READ FBO to the currently bound
        DRAW FBO. The method is static so that one doesn't need to
        ccreate an instance when transferring between attachments in the
        default FBO.
        """
        ret = self._wrap_call(self._vtk_obj.Blit, *args)
        return ret

    def check_frame_buffer_status(self, *args):
        """
        V.check_frame_buffer_status(int) -> int
        C++: int CheckFrameBufferStatus(unsigned int mode)
        Validate the current FBO configuration (attachments, formats,
        etc) prints detected errors to ErrorMacro.
        """
        ret = self._wrap_call(self._vtk_obj.CheckFrameBufferStatus, *args)
        return ret

    def deactivate_draw_buffers(self):
        """
        V.deactivate_draw_buffers()
        C++: void DeactivateDrawBuffers()"""
        ret = self._vtk_obj.DeactivateDrawBuffers()
        return ret
        

    def deactivate_read_buffer(self):
        """
        V.deactivate_read_buffer()
        C++: void DeactivateReadBuffer()"""
        ret = self._vtk_obj.DeactivateReadBuffer()
        return ret
        

    def download(self, *args):
        """
        V.download([int, int, int, int], int, int, int, int)
            -> PixelBufferObject
        C++: PixelBufferObject *Download(int extent[4], int Type,
            int nComps, int oglType, int oglFormat)
        V.download([int, int, int, int], int, int, int, int,
            PixelBufferObject)
        C++: static void Download(int extent[4], int Type, int nComps,
            int oglType, int oglFormat, PixelBufferObject *pbo)
        Download data from the read buffer of the current FBO. These are
        low level meothds. In the static variant a PBO must be passed in
        since we don't have access to a context. The static method is
        provided so that one may download from the default FBO.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Download, *my_args)
        return wrap_vtk(ret)

    def download_color1(self, *args):
        """
        V.download_color1([int, int, int, int], int, int)
            -> PixelBufferObject
        C++: PixelBufferObject *DownloadColor1(int extent[4],
            int Type, int channel)
        Download data from the read color attachment of the currently
        bound FBO into the returned PBO. The PBO must be free'd when you
        are finished with it. The number of components in the PBO is the
        same as in the name of the specific download function. When
        downloading a single color channel, the channel must be
        identified by index, 1->red, 2->green, 3-> blue.
        """
        ret = self._wrap_call(self._vtk_obj.DownloadColor1, *args)
        return wrap_vtk(ret)

    def download_color3(self, *args):
        """
        V.download_color3([int, int, int, int], int)
            -> PixelBufferObject
        C++: PixelBufferObject *DownloadColor3(int extent[4],
            int Type)"""
        ret = self._wrap_call(self._vtk_obj.DownloadColor3, *args)
        return wrap_vtk(ret)

    def download_color4(self, *args):
        """
        V.download_color4([int, int, int, int], int)
            -> PixelBufferObject
        C++: PixelBufferObject *DownloadColor4(int extent[4],
            int Type)"""
        ret = self._wrap_call(self._vtk_obj.DownloadColor4, *args)
        return wrap_vtk(ret)

    def download_depth(self, *args):
        """
        V.download_depth([int, int, int, int], int) -> PixelBufferObject
        C++: PixelBufferObject *DownloadDepth(int extent[4],
            int Type)
        Download data from the depth attachment of the currently bound
        FBO. The returned PBO must be Delete'd by the caller. The
        returned PBO has one component.
        """
        ret = self._wrap_call(self._vtk_obj.DownloadDepth, *args)
        return wrap_vtk(ret)

    def initialize_viewport(self, *args):
        """
        V.initialize_viewport(int, int)
        C++: void InitializeViewport(int width, int height)
        Set up ortho viewport with scissor, lighting, blend, and depth
        disabled. The method affects the current bound FBO.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeViewport, *args)
        return ret

    def is_supported(self, *args):
        """
        V.is_supported(OpenGLRenderWindow) -> bool
        C++: static bool IsSupported(OpenGLRenderWindow *)
        Returns if the context supports the required extensions.
        Extension will be loaded when the context is set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def populate_framebuffer(self, *args):
        """
        V.populate_framebuffer(int, int) -> bool
        C++: bool PopulateFramebuffer(int width, int height)
        V.populate_framebuffer(int, int, bool, int, int, bool, int, int)
            -> bool
        C++: bool PopulateFramebuffer(int width, int height,
            bool useTextures, int numberOfColorAttachments,
            int colorDataType, bool wantDepthAttachment,
            int depthBitplanes, int multisamples)
        Convenience method to populate a framebuffer with attachments
        created as well. Returns true if a complete valid Framebuffer was
        created
        """
        ret = self._wrap_call(self._vtk_obj.PopulateFramebuffer, *args)
        return ret

    def release_graphics_resources(self, *args):
        """
        V.release_graphics_resources(Window)
        C++: virtual void ReleaseGraphicsResources(Window *win)
        Deactivate and un_bind
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_color_attachment(self, *args):
        """
        V.remove_color_attachment(int, int)
        C++: void RemoveColorAttachment(unsigned int mode,
            unsigned int index)
        Directly assign/remove a texture to color attachments. Same as
        the Set methods but also does an attach call so the FO has to be
        bound when called.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveColorAttachment, *args)
        return ret

    def remove_color_attachments(self, *args):
        """
        V.remove_color_attachments(int, int)
        C++: void RemoveColorAttachments(unsigned int mode,
            unsigned int num)
        Directly assign/remove a texture to color attachments. Same as
        the Set methods but also does an attach call so the FO has to be
        bound when called.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveColorAttachments, *args)
        return ret

    def remove_depth_attachment(self, *args):
        """
        V.remove_depth_attachment(int)
        C++: void RemoveDepthAttachment(unsigned int mode)
        Directly assign/remove a texture/renderbuffer to depth
        attachments.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveDepthAttachment, *args)
        return ret

    def remove_ren_depth_attachment(self, *args):
        """
        V.remove_ren_depth_attachment(int)
        C++: void RemoveRenDepthAttachment(unsigned int mode)"""
        ret = self._wrap_call(self._vtk_obj.RemoveRenDepthAttachment, *args)
        return ret

    def remove_tex_color_attachment(self, *args):
        """
        V.remove_tex_color_attachment(int, int)
        C++: void RemoveTexColorAttachment(unsigned int mode,
            unsigned int attId)"""
        ret = self._wrap_call(self._vtk_obj.RemoveTexColorAttachment, *args)
        return ret

    def remove_tex_color_attachments(self, *args):
        """
        V.remove_tex_color_attachments(int, int)
        C++: void RemoveTexColorAttachments(unsigned int mode,
            unsigned int num)"""
        ret = self._wrap_call(self._vtk_obj.RemoveTexColorAttachments, *args)
        return ret

    def remove_tex_depth_attachment(self, *args):
        """
        V.remove_tex_depth_attachment(int)
        C++: void RemoveTexDepthAttachment(unsigned int mode)"""
        ret = self._wrap_call(self._vtk_obj.RemoveTexDepthAttachment, *args)
        return ret

    def render_quad(self, *args):
        """
        V.render_quad(int, int, int, int, ShaderProgram,
            OpenGLVertexArrayObject)
        C++: void RenderQuad(int minX, int maxX, int minY, int maxY,
            ShaderProgram *program, OpenGLVertexArrayObject *vao)
        Renders a quad at the given location with pixel coordinates. This
        method is provided as a convenience, since we often render quads
        in a FBO.
        \pre positive_min_x: min_x>=_0
        \pre increasing_x: min_x<=max_x
        \pre valid_max_x: max_x<_last_size[_0]
        \pre positive_min_y: min_y>=_0
        \pre increasing_y: min_y<=max_y
        \pre valid_max_y: max_y<_last_size[_1]
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'vtkShaderProgram', 'vtkOpenGLVertexArrayObject')])
        ret = self._wrap_call(self._vtk_obj.RenderQuad, *my_args)
        return ret

    def resize(self, *args):
        """
        V.resize(int, int)
        C++: void Resize(int width, int height)
        Resize all FO attachments
        """
        ret = self._wrap_call(self._vtk_obj.Resize, *args)
        return ret

    def restore_previous_bindings(self, *args):
        """
        V.restore_previous_bindings()
        C++: void RestorePreviousBindings()
        V.restore_previous_bindings(int)
        C++: void RestorePreviousBindings(unsigned int mode)
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._wrap_call(self._vtk_obj.RestorePreviousBindings, *args)
        return ret

    def restore_previous_bindings_and_buffers(self, *args):
        """
        V.restore_previous_bindings_and_buffers()
        C++: void RestorePreviousBindingsAndBuffers()
        V.restore_previous_bindings_and_buffers(int)
        C++: void RestorePreviousBindingsAndBuffers(unsigned int mode)
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._wrap_call(self._vtk_obj.RestorePreviousBindingsAndBuffers, *args)
        return ret

    def restore_previous_buffers(self, *args):
        """
        V.restore_previous_buffers()
        C++: void RestorePreviousBuffers()
        V.restore_previous_buffers(int)
        C++: void RestorePreviousBuffers(unsigned int mode)
        Store the current draw and read buffers. When restored only the
        buffers matching mode are modified. get_draw_mode() -> gl_draw_buffer
        get_read_mode() -> gl_read_buffer get_both_mode() -> both
        """
        ret = self._wrap_call(self._vtk_obj.RestorePreviousBuffers, *args)
        return ret

    def save_current_bindings(self, *args):
        """
        V.save_current_bindings()
        C++: void SaveCurrentBindings()
        V.save_current_bindings(int)
        C++: void SaveCurrentBindings(unsigned int mode)
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._wrap_call(self._vtk_obj.SaveCurrentBindings, *args)
        return ret

    def save_current_bindings_and_buffers(self, *args):
        """
        V.save_current_bindings_and_buffers()
        C++: void SaveCurrentBindingsAndBuffers()
        V.save_current_bindings_and_buffers(int)
        C++: void SaveCurrentBindingsAndBuffers(unsigned int mode)
        Store/Restore the current framebuffer bindings and buffers.
        """
        ret = self._wrap_call(self._vtk_obj.SaveCurrentBindingsAndBuffers, *args)
        return ret

    def save_current_buffers(self, *args):
        """
        V.save_current_buffers()
        C++: void SaveCurrentBuffers()
        V.save_current_buffers(int)
        C++: void SaveCurrentBuffers(unsigned int mode)
        Store the current draw and read buffers. When restored only the
        buffers matching mode are modified. get_draw_mode() -> gl_draw_buffer
        get_read_mode() -> gl_read_buffer get_both_mode() -> both
        """
        ret = self._wrap_call(self._vtk_obj.SaveCurrentBuffers, *args)
        return ret

    def start(self, *args):
        """
        V.start(int, int) -> bool
        C++: bool Start(int width, int height)
        User must take care that width/height match the dimensions of the
        user defined texture attachments. This method makes the "active
        buffers" the buffers that will get drawn into by subsequent
        drawing calls. Note that this does not clear the render buffers
        i.e. no gl_clear() calls are made by either of these methods. It's
        up to the caller to clear the buffers if needed.
        """
        ret = self._wrap_call(self._vtk_obj.Start, *args)
        return ret

    def start_non_ortho(self, *args):
        """
        V.start_non_ortho(int, int) -> bool
        C++: bool StartNonOrtho(int width, int height)
        User must take care that width/height match the dimensions of the
        user defined texture attachments. This method makes the "active
        buffers" the buffers that will get drawn into by subsequent
        drawing calls. Note that this does not clear the render buffers
        i.e. no gl_clear() calls are made by either of these methods. It's
        up to the caller to clear the buffers if needed.
        """
        ret = self._wrap_call(self._vtk_obj.StartNonOrtho, *args)
        return ret

    def un_bind(self, *args):
        """
        V.un_bind()
        C++: void UnBind()
        V.un_bind(int)
        C++: void UnBind(unsigned int mode)
        Unbind this buffer
        """
        ret = self._wrap_call(self._vtk_obj.UnBind, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLFramebufferObject, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLFramebufferObject properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

