# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class MultiObjectMassProperties(PolyDataAlgorithm):
    """
    MultiObjectMassProperties - compute volume and area of objects in
    a polygonal mesh
    
    Superclass: PolyDataAlgorithm
    
    MultiObjectMassProperties estimates the volume and the surface
    area of a polygonal mesh. Multiple, valid closed objects may be
    represented, and each object is assumed to be defined as a polyhedron
    defined by polygonal faces (i.e., the faces do not have to be
    triangles). The algorithm computes the total volume and area, as well
    as per object values which are placed in data arrays. Note that an
    object is valid only if it is manifold and closed (i.e., each edge is
    used exactly two times by two different polygons). Invalid objects
    are processed but may produce inaccurate results. Inconsistent
    polygon ordering is also allowed.
    
    The algorithm is composed of two basic parts. First a connected
    traversal is performed to identify objects, detect whether the
    objects are valid, and ensure that the composing polygons are ordered
    consistently. Next, in threaded execution, a parallel process of
    computing areas and volumes is performed. It is possible to skip the
    first part if the skip_validity_check is enabled, AND a IdTypeArray
    data array named "_object_ids" is associated with the polygon input
    (i.e., cell data) that enumerates which object every polygon belongs
    to (i.e., indictaes that it is a boundary polygon of a specified
    object).
    
    The algorithm implemented here is inspired by this paper:
    http://chenlab.ece.cornell.edu/Publication/Cha/icip01_Cha.pdf. Also
    see the Stackflow entry: https://stackoverflow.com/questions/1406029/
    how-to-calculate-the-volume-of-a-3d-mesh-object-the-surface-of-which-i
    s-made-up. The general assumption here is that the model is of closed
    surface.  Also, this approach requires triangulating the polygons so
    triangle meshes are processed much faster. Finally, the volume and
    area calculations are done in paraellel (threaded) after a
    connectivity pass is made (used to identify objects and verify that
    they are manifold and closed).
    
    The output contains six additional data arrays. The arrays
    "_object_validity", "_object_volumes" and "_object_areas" are placed in the
    output field data.  These are arrays which indicate which objects are
    valid; the volume of each object; and the surface area of each
    object. Three additional arrays are placed in the output cell data,
    and indicate, on a per polygons basis, which object the polygon
    bounds "_object_ids"; the polygon area "Areas"; and the contribution of
    volume "Volumes".  Additionally, the total_volume and total_area is
    available after the filter executes (i.e., the sum of the
    object_volumes and object_areas arrays).
    
    Per object validity, as mentioned previously, is reported in the
    object_validity array. However another variable, all_valid, is set
    after filter execution which indicates whether all objects are valid
    (!=0) or not. This information can be used as a shortcut in case you
    want to skip validity checking on an object-by-object basis.
    
    @warning
    This filter operates on the polygonal data contained in the input
    PolyData. Other types (verts, lines, triangle strips) are ignored
    and not passed to the output. The input polys and points, as well as
    associated point and cell data, are passed through to the output.
    
    @warning
    This filter is similar to MassProperties. However
    MassProperties operates on triangle meshes and assumes only a
    single, closed, properly oriented surface is represented.
    MultiObjectMassProperties performs additional topological and
    connectivity operations to identify separate objects, and confirms
    that they are manifold. It also accommodates inconsistent ordering.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    MassProperties
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMultiObjectMassProperties, obj, update, **traits)
    
    skip_validity_check = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to skip the validity check (the first part of
        the algorithm). By default this is off; however even if enabled
        validity skipping will only occur if a IdTypeArray named
        "_object_ids" is also provided on input to the filter.
        """
    )

    def _skip_validity_check_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSkipValidityCheck,
                        self.skip_validity_check_)

    def _get_all_valid(self):
        return self._vtk_obj.GetAllValid()
    all_valid = traits.Property(_get_all_valid, desc=\
        """
        Return whether all objects are valid or not. This is valid only
        after the filter executes.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_objects(self):
        return self._vtk_obj.GetNumberOfObjects()
    number_of_objects = traits.Property(_get_number_of_objects, desc=\
        """
        Return the number of objects identified. This is valid only after
        the filter executes. Check the object_validity array which
        indicates which of these identified objects are valid. Invalid
        objects may have incorrect volume and area values.
        """
    )

    def _get_total_area(self):
        return self._vtk_obj.GetTotalArea()
    total_area = traits.Property(_get_total_area, desc=\
        """
        Return the summed area of all objects. This is valid only after
        the filter executes.
        """
    )

    def _get_total_volume(self):
        return self._vtk_obj.GetTotalVolume()
    total_volume = traits.Property(_get_total_volume, desc=\
        """
        Return the summed volume of all objects. This is valid only after
        the filter executes.
        """
    )

    _updateable_traits_ = \
    (('skip_validity_check', 'GetSkipValidityCheck'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'skip_validity_check', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MultiObjectMassProperties, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MultiObjectMassProperties properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['skip_validity_check'], [], []),
            title='Edit MultiObjectMassProperties properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MultiObjectMassProperties properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

